/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.config.annotation.validator;

import com.hepl.tunefortwo.config.annotation.FileChecker;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;
import org.springframework.web.multipart.MultipartFile;

public class FileCheckValidator
implements ConstraintValidator<FileChecker, MultipartFile> {
    private String extension;
    private boolean isMandatory;

    public void initialize(FileChecker constraintAnnotation) {
        this.extension = constraintAnnotation.ext();
        this.isMandatory = constraintAnnotation.isMandatory();
    }

    public boolean isValid(MultipartFile file, ConstraintValidatorContext context) {
        List<String> allowedExtension = Arrays.stream(this.extension.split(",")).map(String::trim).toList();
        if (file != null) {
            return allowedExtension.contains(file.getContentType());
        }
        return !this.isMandatory;
    }
}

