/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.hepl.tunefortwo.dto.LoginRequestDto;
import com.hepl.tunefortwo.service.AuthService;
import com.hepl.tunefortwo.utils.JwtUtils;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Authentication for admin", description="")
@RestController
@RequestMapping(value={"/v1/authentication"})
public class AuthController {
    private static final Logger log = LoggerFactory.getLogger(AuthController.class);
    private final JwtUtils jwtUtils;
    private final AuthService authService;

    public AuthController(JwtUtils jwtutils, AuthService authService) {
        this.jwtUtils = jwtutils;
        this.authService = authService;
    }

    @PostMapping(value={"/login"})
    public ResponseEntity<?> authenticateUser(@Validated @RequestBody LoginRequestDto loginRequest) throws JsonProcessingException {
        return this.authService.autheticateUser(loginRequest);
    }
}

