/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.controller;

import com.hepl.tunefortwo.config.i18n.Translator;
import com.hepl.tunefortwo.dto.GenericData;
import com.hepl.tunefortwo.dto.GenericResponse;
import com.hepl.tunefortwo.entity.DeliveryDate;
import com.hepl.tunefortwo.service.DeliveryDateService;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Manage Delivery Date", description="")
@RestController
@RequestMapping(value={"/v1/deliveryDate"})
public class DeliveryDateController {
    private static final Logger log = LoggerFactory.getLogger(DeliveryDateController.class);
    private final DeliveryDateService deliveryDateService;
    private final Translator translator;

    public DeliveryDateController(DeliveryDateService deliveryDateService, Translator translator) {
        this.deliveryDateService = deliveryDateService;
        this.translator = translator;
    }

    @GetMapping
    public GenericResponse createDeliveryDateCollection() {
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        DeliveryDate addedData = this.deliveryDateService.addCollection();
        data.setDeliveryDate(addedData);
        response.setData(data);
        response.setMessage(this.translator.toLocale("deliveryDate.addData"));
        return response;
    }

    @PutMapping(value={"/updateDeliveryDate"})
    public GenericResponse updateDeliveryDate(@RequestParam(required=false) String estimatedDays, @RequestParam(required=false) Double priceForTotalDays, @RequestParam(required=false) Double pricePerDay) throws MessagingException {
        this.deliveryDateService.updateDeliveryDate(estimatedDays, priceForTotalDays, pricePerDay);
        GenericResponse response = new GenericResponse(true);
        response.setMessage(this.translator.toLocale("deliveryDate.updateData"));
        return response;
    }

    @GetMapping(value={"/getDeliveryDate"})
    public GenericResponse getDeliveryDateData() {
        GenericResponse response = new GenericResponse(true);
        DeliveryDate deliveryDateData = this.deliveryDateService.getDeliveryDateData();
        GenericData data = new GenericData();
        data.setDeliveryDate(deliveryDateData);
        response.setData(data);
        response.setMessage(this.translator.toLocale("deliveryDate.getData"));
        return response;
    }
}

