/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.controller;

import com.hepl.tunefortwo.config.i18n.Translator;
import com.hepl.tunefortwo.dto.GenericData;
import com.hepl.tunefortwo.dto.GenericResponse;
import com.hepl.tunefortwo.service.HashingService;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Manage Data Hashing", description="Encryption and Decryption of data through hashing mechanism")
@SecurityRequirement(name="Bearer Authentication")
@RestController
@RequestMapping(value={"/v1/hashing"})
public class HashingController {
    private static final Logger log = LoggerFactory.getLogger(HashingController.class);
    private final Translator translator;
    private final HashingService hashingService;

    public HashingController(HashingService hashingService, Translator translator) {
        this.hashingService = hashingService;
        this.translator = translator;
    }

    @PostMapping(value={"/encryption"})
    public GenericResponse encryption(@RequestBody String plainData) throws Exception {
        log.info("encrypting the data: ${}", (Object)plainData);
        String encryptedData = this.hashingService.encryption(plainData);
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setEncryptedData(encryptedData);
        response.setMessage(this.translator.toLocale("hashing.dataEncryptedSuccessfully"));
        response.setData(data);
        return response;
    }

    @PostMapping(value={"/decryption"})
    public GenericResponse decryption(@RequestBody String encryptedData) throws Exception {
        log.info("decrypting the data: {}", (Object)encryptedData);
        String decryptedData = this.hashingService.decryption(encryptedData);
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setDecryptedData(decryptedData);
        response.setMessage(this.translator.toLocale("hashing.dataDecryptedSuccessfully"));
        response.setData(data);
        return response;
    }
}

