/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.controller;

import com.hepl.tunefortwo.config.i18n.Translator;
import com.hepl.tunefortwo.dto.AccessControlStatus;
import com.hepl.tunefortwo.dto.GenericData;
import com.hepl.tunefortwo.dto.GenericResponse;
import com.hepl.tunefortwo.dto.InstrumentRequestDto;
import com.hepl.tunefortwo.entity.FileType;
import com.hepl.tunefortwo.service.AudioService;
import com.hepl.tunefortwo.service.FileService;
import com.hepl.tunefortwo.service.InstrumentService;
import com.hepl.tunefortwo.utils.JwtUtils;
import io.jsonwebtoken.Claims;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.mail.MessagingException;
import jakarta.validation.Valid;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@Tag(name="Create and Manage Instrument", description="")
@RestController
@RequestMapping(value={"/v1/instrument"})
public class InstrumentController {
    private static final Logger log = LoggerFactory.getLogger(InstrumentController.class);
    private final Translator translator;
    private final InstrumentService instrumentService;
    private final FileService fileService;
    private final AudioService audioService;
    private final JwtUtils jwtUtils;

    public InstrumentController(Translator translator, InstrumentService instrumentService, FileService fileService, AudioService audioService, JwtUtils jwtUtils) {
        this.instrumentService = instrumentService;
        this.translator = translator;
        this.fileService = fileService;
        this.audioService = audioService;
        this.jwtUtils = jwtUtils;
    }

    @PostMapping(consumes={"multipart/form-data"})
    public GenericResponse addInstrument(@Validated @ModelAttribute InstrumentRequestDto data, Authentication authentication) throws Exception {
        Object response;
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (!isAdmin) {
            response = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Unauthorized");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        if (data.getAudio() != null) {
            String originalFilename = data.getAudio().getOriginalFilename();
            if (originalFilename != null) {
                String fileExtension = originalFilename.substring(originalFilename.lastIndexOf(".") + 1);
                List<String> allowedExtensions = Arrays.asList("mp3", "wav", "ogg", "aac");
                if (!allowedExtensions.contains(fileExtension.toLowerCase())) {
                    throw new MessagingException("Only MP3, AAC, OGG, and WAV files are allowed");
                }
            }
            data.setAudioPath(this.fileService.uploadFile(data.getAudio(), FileType.CLIP));
            String filename = this.fileService.uploadFile(data.getAudio(), FileType.CLIP);
            Resource file = this.fileService.loadAsResource(filename, FileType.CLIP);
            Path filePath = Paths.get(file.getURI());
            System.out.println("FilePath while posting---" + filePath);
            double durationInSeconds = this.audioService.getAudioDuration(filePath.toFile());
            long durationRound = (long)Math.floor(durationInSeconds);
            long minutes = durationRound / 60L;
            long seconds = durationRound % 60L;
            String formattedTime = String.format("%02d:%02d", minutes, seconds);
            data.setAudioDuration(formattedTime);
        }
        log.info("Adding Instrument");
        this.instrumentService.saveInstrument(data);
        response = new GenericResponse(true);
        ((GenericResponse)response).setMessage(this.translator.toLocale("instrument.instrumentSavedSuccessully"));
        return response;
    }

    @GetMapping
    public GenericResponse getAllInstrumentSortedByPrice() {
        log.info("Get all Instruments sorted by price in ascending order");
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setInstruments(this.instrumentService.getAllInstrumentsSortedByPrice(Sort.Direction.ASC));
        response.setData(data);
        return response;
    }

    @GetMapping(value={"/getallinsrumentimages"})
    public GenericResponse getAllImagesForInstruments() {
        log.info("Get all Instruments with Images and description");
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setAllInstrumentImages(this.instrumentService.getAllImagesForInstruments());
        response.setData(data);
        return response;
    }

    @GetMapping(value={"/get-AllInstrument-Active"})
    public GenericResponse getAllInstrumentsByActive() {
        log.info("Get all Instruments");
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setInstruments(this.instrumentService.getAllInstrumentsByActive());
        response.setData(data);
        return response;
    }

    @GetMapping(value={"/{id}"})
    public GenericResponse getInstrumentById(@PathVariable String id, Authentication authentication) {
        Object response;
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (!isAdmin) {
            response = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Unauthorized");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        log.info("Get instrument");
        response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setInstrument(this.instrumentService.getInstrumentById(id));
        ((GenericResponse)response).setData(data);
        return response;
    }

    @Operation(description="Update Instrument based on id")
    @PutMapping(value={"/{id}"}, consumes={"multipart/form-data"})
    public GenericResponse updateInstrument(@PathVariable String id, @Valid @ModelAttribute InstrumentRequestDto instrument, Authentication authentication) throws MessagingException, IOException {
        Object response;
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (!isAdmin) {
            response = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Unauthorized");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        if (instrument.getAudio() != null) {
            String originalFilename = instrument.getAudio().getOriginalFilename();
            if (originalFilename != null) {
                String fileExtension = originalFilename.substring(originalFilename.lastIndexOf(".") + 1);
                List<String> allowedExtensions = Arrays.asList("mp3", "wav", "OGG", "AAC");
                if (!allowedExtensions.contains(fileExtension.toLowerCase())) {
                    throw new MessagingException("Only MP3,AAC,OGG, and WAV files are allowed");
                }
            }
            instrument.setAudioPath(this.fileService.uploadFile(instrument.getAudio(), FileType.CLIP));
            String filename = this.fileService.uploadFile(instrument.getAudio(), FileType.CLIP);
            Resource file = this.fileService.loadAsResource(filename, FileType.CLIP);
            Path filePath = Paths.get(file.getURI());
            System.out.println("FilePath while posting---" + filePath);
            double durationInSeconds = this.audioService.getAudioDuration(filePath.toFile());
            long durationRound = (long)Math.floor(durationInSeconds);
            long minutes = durationRound / 60L;
            long seconds = durationRound % 60L;
            String formattedTime = String.format("%02d:%02d", minutes, seconds);
            instrument.setAudioDuration(formattedTime);
        }
        log.info("Update instrument ... {}", (Object)id);
        this.instrumentService.updateInstrument(instrument, id);
        response = new GenericResponse(true);
        ((GenericResponse)response).setMessage(this.translator.toLocale("instrument.instrumentUpdatedSuccessfully"));
        return response;
    }

    @Operation(summary="Change action control status")
    @PutMapping(value={"/action-control/{id}"})
    public GenericResponse updateActionControlStatus(@RequestParam AccessControlStatus status, @PathVariable String id, Authentication authentication) throws MessagingException {
        Object response;
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (!isAdmin) {
            response = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Unauthorized");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        log.info("Update instrument control status ... {}", (Object)id);
        this.instrumentService.updateActionControlStatus(status, id);
        response = new GenericResponse(true);
        ((GenericResponse)response).setMessage(this.translator.toLocale("instrument.instrumentStatusChanged"));
        return response;
    }

    @DeleteMapping(value={"/{id}"})
    public GenericResponse deleteInstrument(@PathVariable String id, Authentication authentication) {
        Object response;
        log.info("delete instrument.....{}", (Object)id);
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (!isAdmin) {
            response = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Unauthorized");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        this.instrumentService.deleteInstrument(id);
        response = new GenericResponse(true);
        ((GenericResponse)response).setMessage(this.translator.toLocale("instrument.instrumentDeleted"));
        return response;
    }

    @GetMapping(value={"/song/{filename}"})
    public ResponseEntity<byte[]> serveFile(@PathVariable String filename, Authentication authentication) throws IOException, UnsupportedAudioFileException {
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (!isAdmin) {
            ResponseEntity response = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Unauthorized");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        log.info("Get filename .. {}", (Object)filename);
        Resource file = this.fileService.loadAsResource(filename, FileType.INSTRUMENT);
        if (file == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "error.fileNotFound");
        }
        Path filePath = Paths.get(file.getURI());
        double durationInSeconds = this.audioService.getAudioDuration(filePath.toFile());
        System.out.println(durationInSeconds);
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + file.getFilename() + "\""})).header("Audio-Duration", new String[]{String.valueOf(durationInSeconds)})).body((Object)file.getContentAsByteArray());
    }

    @DeleteMapping(value={"/"})
    public GenericResponse deleteAllInstrument(@RequestBody List<String> id, Authentication authentication) {
        Object response;
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (!isAdmin) {
            response = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Unauthorized");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        log.info("delete all instrument.....{}", id);
        this.instrumentService.deleteAllInstrument(id);
        response = new GenericResponse(true);
        ((GenericResponse)response).setMessage(this.translator.toLocale("instrument.instrumentAllDeleted"));
        return response;
    }

    @Operation(summary="Change all action control status")
    @PutMapping(value={"/action-controls"})
    public GenericResponse updateAllActionControlStatus(@RequestParam AccessControlStatus status, @RequestBody List<String> id, Authentication authentication) throws MessagingException {
        Object response;
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (!isAdmin) {
            response = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Unauthorized");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        log.info("Update instrument control status ... {}", id);
        this.instrumentService.updateAllActionControlStatus(status, id);
        response = new GenericResponse(true);
        ((GenericResponse)response).setMessage(this.translator.toLocale("instrument.instrumentAllStatusChanged"));
        return response;
    }

    @GetMapping(value={"/instrumentimage/{filename}"})
    public ResponseEntity<byte[]> serveImage(@PathVariable String filename) throws IOException, UnsupportedAudioFileException {
        log.info("Get filename .. {}", (Object)filename);
        Resource file = this.fileService.loadAsResource(filename, FileType.INSTRUMENT);
        if (file == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "error.fileNotFound");
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + file.getFilename() + "\""})).body((Object)file.getContentAsByteArray());
    }

    @GetMapping(value={"/files/imagelist"})
    public ResponseEntity<Map<String, Object>> listInstrumentFiles() throws IOException {
        Path instrumentDirectory = this.fileService.getFilePathService(FileType.INSTRUMENT).getDestinationPath();
        List fileNames = Files.list(instrumentDirectory).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(path -> path.getFileName().toString()).collect(Collectors.toList());
        int count = fileNames.size();
        HashMap<String, Object> imageMap = new HashMap<String, Object>();
        imageMap.put("count", count);
        imageMap.put("instrumentImageList", fileNames);
        return ResponseEntity.ok(imageMap);
    }
}

