/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.controller;

import com.hepl.tunefortwo.config.i18n.Translator;
import com.hepl.tunefortwo.dto.GenericData;
import com.hepl.tunefortwo.dto.GenericResponse;
import com.hepl.tunefortwo.service.MixtureMasterService;
import com.hepl.tunefortwo.utils.JwtUtils;
import io.jsonwebtoken.Claims;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@Tag(name="Set Price For MixtureMaster", description="")
@RestController
@RequestMapping(value={"/v1/mixturemaster"})
public class MixtureMasterController {
    private static final Logger log = LoggerFactory.getLogger(MixtureMasterController.class);
    private final MixtureMasterService mixtureMasterService;
    private final JwtUtils jwtUtils;
    private final Translator translator;

    public MixtureMasterController(MixtureMasterService mixtureMasterService, Translator translator, JwtUtils jwtUtils) {
        this.mixtureMasterService = mixtureMasterService;
        this.translator = translator;
        this.jwtUtils = jwtUtils;
    }

    @GetMapping
    public GenericResponse getmixtureMasterPrice() {
        log.info("Get mixturemaster Price");
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setMixtureMasters(this.mixtureMasterService.getmixtureMasterPrice());
        response.setData(data);
        return response;
    }

    @GetMapping(value={"/{id}"})
    public GenericResponse getmixtureMasterPrice(@PathVariable String id) {
        log.info("Get mixturemaster Price");
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setMixtureMaster(this.mixtureMasterService.getmixtureMaster(id));
        response.setData(data);
        return response;
    }

    @PutMapping(value={"/{id}"})
    public GenericResponse setmixtureMasterById(@RequestParam Double price, @PathVariable String id, Authentication authentication) {
        Object response;
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (!isAdmin) {
            response = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Unauthorized");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        log.info("Set mixturemaster Price");
        response = new GenericResponse(true);
        this.mixtureMasterService.setmixtureMasterById(price, id);
        ((GenericResponse)response).setMessage(this.translator.toLocale("mixtureMaster.priceUpdatedSuccessfully"));
        return response;
    }
}

