/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.controller;

import com.hepl.tunefortwo.config.i18n.Translator;
import com.hepl.tunefortwo.config.security.JWTHelper;
import com.hepl.tunefortwo.dto.GenericResponse;
import com.hepl.tunefortwo.dto.ResetPasswordDto;
import com.hepl.tunefortwo.dto.UserDTO;
import com.hepl.tunefortwo.entity.FileType;
import com.hepl.tunefortwo.entity.Users;
import com.hepl.tunefortwo.service.FileService;
import com.hepl.tunefortwo.service.UserService;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@Tag(name="Create and Manage users", description="")
@SecurityRequirement(name="Bearer Authentication")
@RestController
@RequestMapping(value={"/v1/users"})
public class UserController {
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    private final JWTHelper jwtHelper;
    private final Translator translator;
    private final FileService fileService;
    private final UserService userService;
    private final BCryptPasswordEncoder bCryptPasswordEncoder;

    public UserController(JWTHelper jwtHelper, Translator translator, FileService fileService, UserService userService, BCryptPasswordEncoder bCryptPasswordEncoder) {
        this.jwtHelper = jwtHelper;
        this.translator = translator;
        this.fileService = fileService;
        this.userService = userService;
        this.bCryptPasswordEncoder = bCryptPasswordEncoder;
    }

    @PostMapping(consumes={"multipart/form-data"})
    public GenericResponse addUser(@ModelAttribute UserDTO userRequest) throws MessagingException, IOException {
        log.info("Adding Users for meeting agenda");
        if (userRequest.getProfilePhoto() != null) {
            this.fileService.uploadFile(userRequest.getProfilePhoto(), FileType.PROFILE);
        }
        userRequest.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)userRequest.getPassword()));
        this.userService.saveUser(userRequest);
        GenericResponse response = new GenericResponse(true);
        response.setMessage(this.translator.toLocale("user.userSavedSuccessfully"));
        return response;
    }

    @GetMapping(value={"/profile-pic/{filename}"})
    public ResponseEntity<byte[]> serveFile(@PathVariable(value="filename") String filename) throws IOException {
        log.info("Get filename .. {}", (Object)filename);
        Resource file = this.fileService.loadAsResource(filename, FileType.PROFILE);
        if (file == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "error.fileNotFound");
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + file.getFilename() + "\""})).body((Object)file.getContentAsByteArray());
    }

    @PostMapping(value={"/forgot-password"})
    public ResponseEntity<?> forgotPassword(@RequestParam(value="email") String email) throws MessagingException {
        Users user = this.userService.findUserForEmail(email);
        if (user == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("User with email " + email + " not found."));
        }
        String resetToken = this.userService.generateResetToken();
        Users forgotUser = this.userService.setResetToken(user, resetToken);
        HashMap<String, String> responseData = new HashMap<String, String>();
        responseData.put("email", forgotUser.getEmail());
        responseData.put("userName", forgotUser.getUsername());
        responseData.put("token", forgotUser.getResetToken());
        return ResponseEntity.ok(responseData);
    }

    @GetMapping(value={"/reset-password"})
    public ResponseEntity<?> showResetPasswordForm(@RequestParam(value="token") String token) {
        Users user = this.userService.findUserByToken(token);
        if (user == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Access Denied");
        }
        if (this.userService.isResetTokenExpired(user)) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Please Try Password Reset Request again !!!");
        }
        HashMap<String, String> responseData = new HashMap<String, String>();
        responseData.put("email", user.getEmail());
        return ResponseEntity.ok(responseData);
    }

    @PostMapping(value={"/reset-password"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> resetPassword(@ModelAttribute ResetPasswordDto passwordData) {
        Users userForToken = new Users();
        userForToken.setEmail(passwordData.getEmail());
        if (this.userService.isResetTokenExpired(userForToken)) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Please Try Password Reset Request again !!!");
        }
        passwordData.setNewPassword(this.bCryptPasswordEncoder.encode((CharSequence)passwordData.getNewPassword()));
        return this.userService.updateNewPassword(passwordData);
    }
}

