/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hepl.tunefortwo.config.annotation.FileChecker;
import com.hepl.tunefortwo.config.jackson.ForceStringDeserializer;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import org.springframework.web.multipart.MultipartFile;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UserDTO {
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private String id;
    @NotBlank(message="{validation.user.userIdCannotBeEmpty}")
    @Size(max=6, message="{validation.user.userIdMustBeMaximumOf_6Characters}")
    @JsonDeserialize(using=ForceStringDeserializer.class)
    private @NotBlank(message="{validation.user.userIdCannotBeEmpty}") @Size(max=6, message="{validation.user.userIdMustBeMaximumOf_6Characters}") String userId;
    @NotBlank(message="{validation.user.usernameCannotBeEmpty}")
    @Size(max=60, message="{validation.user.usernameMustBeMaximumOf_60Characters}")
    @JsonDeserialize(using=ForceStringDeserializer.class)
    private @NotBlank(message="{validation.user.usernameCannotBeEmpty}") @Size(max=60, message="{validation.user.usernameMustBeMaximumOf_60Characters}") String username;
    @NotBlank(message="{validation.user.emailCannotBeEmpty}")
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, example="test@hepl.com", description="Encrypt data using AES/GCM")
    @Pattern(regexp="^[a-z0-9]{1,25}(?:[._+][a-z0-9]+)*@[a-z0-9.-]+\\.[a-z]{2,}$", message="{validation.user.emailIsInvalid}")
    @JsonDeserialize(using=ForceStringDeserializer.class)
    private @NotBlank(message="{validation.user.emailCannotBeEmpty}") @Pattern(regexp="^[a-z0-9]{1,25}(?:[._+][a-z0-9]+)*@[a-z0-9.-]+\\.[a-z]{2,}$", message="{validation.user.emailIsInvalid}") String email;
    @NotBlank(message="{validation.user.mobileCannotBeEmpty}")
    @Pattern(regexp="^[+]*[(]?\\d{1,4}[)]?[-\\s\\./0-9]{10,15}$", message="{validation.user.mobileNoIsInvalid}")
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Encrypt data using AES/GCM", example="+128484444545")
    @JsonDeserialize(using=ForceStringDeserializer.class)
    private @NotBlank(message="{validation.user.mobileCannotBeEmpty}") @Pattern(regexp="^[+]*[(]?\\d{1,4}[)]?[-\\s\\./0-9]{10,15}$", message="{validation.user.mobileNoIsInvalid}") String mobile;
    @NotBlank(message="{validation.user.roleIdCannotBeEmpty}")
    @JsonDeserialize(using=ForceStringDeserializer.class)
    private @NotBlank(message="{validation.user.roleIdCannotBeEmpty}") String roleId;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.WRITE_ONLY)
    @JsonDeserialize(using=ForceStringDeserializer.class)
    private String password;
    @Schema(accessMode=Schema.AccessMode.WRITE_ONLY)
    @FileChecker(ext="image/png, image/jpg, image/jpeg", isMandatory=false, message="{error.fileNotSupported}")
    private MultipartFile profilePhoto;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private String profilePhotoPath;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private String status;

    public static UserDTOBuilder builder() {
        return new UserDTOBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getEmail() {
        return this.email;
    }

    public String getMobile() {
        return this.mobile;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public String getPassword() {
        return this.password;
    }

    public MultipartFile getProfilePhoto() {
        return this.profilePhoto;
    }

    public String getProfilePhotoPath() {
        return this.profilePhotoPath;
    }

    public String getStatus() {
        return this.status;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonDeserialize(using=ForceStringDeserializer.class)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @JsonDeserialize(using=ForceStringDeserializer.class)
    public void setUsername(String username) {
        this.username = username;
    }

    @JsonDeserialize(using=ForceStringDeserializer.class)
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonDeserialize(using=ForceStringDeserializer.class)
    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @JsonDeserialize(using=ForceStringDeserializer.class)
    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    @JsonDeserialize(using=ForceStringDeserializer.class)
    public void setPassword(String password) {
        this.password = password;
    }

    public void setProfilePhoto(MultipartFile profilePhoto) {
        this.profilePhoto = profilePhoto;
    }

    public void setProfilePhotoPath(String profilePhotoPath) {
        this.profilePhotoPath = profilePhotoPath;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public UserDTO(String id, String userId, String username, String email, String mobile, String roleId, String password, MultipartFile profilePhoto, String profilePhotoPath, String status) {
        this.id = id;
        this.userId = userId;
        this.username = username;
        this.email = email;
        this.mobile = mobile;
        this.roleId = roleId;
        this.password = password;
        this.profilePhoto = profilePhoto;
        this.profilePhotoPath = profilePhotoPath;
        this.status = status;
    }

    public UserDTO() {
    }

    public static class UserDTOBuilder {
        private String id;
        private String userId;
        private String username;
        private String email;
        private String mobile;
        private String roleId;
        private String password;
        private MultipartFile profilePhoto;
        private String profilePhotoPath;
        private String status;

        UserDTOBuilder() {
        }

        public UserDTOBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonDeserialize(using=ForceStringDeserializer.class)
        public UserDTOBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @JsonDeserialize(using=ForceStringDeserializer.class)
        public UserDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        @JsonDeserialize(using=ForceStringDeserializer.class)
        public UserDTOBuilder email(String email) {
            this.email = email;
            return this;
        }

        @JsonDeserialize(using=ForceStringDeserializer.class)
        public UserDTOBuilder mobile(String mobile) {
            this.mobile = mobile;
            return this;
        }

        @JsonDeserialize(using=ForceStringDeserializer.class)
        public UserDTOBuilder roleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        @JsonDeserialize(using=ForceStringDeserializer.class)
        public UserDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public UserDTOBuilder profilePhoto(MultipartFile profilePhoto) {
            this.profilePhoto = profilePhoto;
            return this;
        }

        public UserDTOBuilder profilePhotoPath(String profilePhotoPath) {
            this.profilePhotoPath = profilePhotoPath;
            return this;
        }

        public UserDTOBuilder status(String status) {
            this.status = status;
            return this;
        }

        public UserDTO build() {
            return new UserDTO(this.id, this.userId, this.username, this.email, this.mobile, this.roleId, this.password, this.profilePhoto, this.profilePhotoPath, this.status);
        }

        public String toString() {
            return "UserDTO.UserDTOBuilder(id=" + this.id + ", userId=" + this.userId + ", username=" + this.username + ", email=" + this.email + ", mobile=" + this.mobile + ", roleId=" + this.roleId + ", password=" + this.password + ", profilePhoto=" + this.profilePhoto + ", profilePhotoPath=" + this.profilePhotoPath + ", status=" + this.status + ")";
        }
    }
}

