/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.mapper;

import com.hepl.tunefortwo.dto.FormRequestDto;
import com.hepl.tunefortwo.dto.FormRequestDtoCoAdmin;
import com.hepl.tunefortwo.dto.OrderTrackerDto;
import com.hepl.tunefortwo.entity.Form;
import com.hepl.tunefortwo.mapper.FormMapper;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class FormMapperImpl
implements FormMapper {
    @Override
    public Form toFormEntity(FormRequestDto formRequestDto) {
        List<String> list1;
        if (formRequestDto == null) {
            return null;
        }
        Form form = new Form();
        form.setMixtureMaster(this.mapMasterRequestToString(formRequestDto.getMasterRequest()));
        form.setId(formRequestDto.getId());
        form.setName(formRequestDto.getName());
        form.setMail(formRequestDto.getMail());
        form.setPhonenumber(formRequestDto.getPhonenumber());
        form.setInstrument(formRequestDto.getInstrument());
        form.setMood(formRequestDto.getMood());
        form.setLanuage(formRequestDto.getLanuage());
        form.setArtist(formRequestDto.getArtist());
        form.setSongto(formRequestDto.getSongto());
        form.setSongfrom(formRequestDto.getSongfrom());
        form.setOccasion(formRequestDto.getOccasion());
        form.setStory(formRequestDto.getStory());
        form.setClipPath(formRequestDto.getClipPath());
        form.setAdminClipPath(formRequestDto.getAdminClipPath());
        form.setClipDuration(formRequestDto.getClipDuration());
        form.setOrderNumber(formRequestDto.getOrderNumber());
        form.setComments(formRequestDto.getComments());
        form.setScreenshot(formRequestDto.getScreenshot());
        List<OrderTrackerDto> list = formRequestDto.getOrderPosition();
        if (list != null) {
            form.setOrderPosition(new ArrayList<OrderTrackerDto>(list));
        }
        form.setCustomerDeliveryDate(formRequestDto.getCustomerDeliveryDate());
        form.setReview(formRequestDto.getReview());
        if (formRequestDto.getRating() != null) {
            form.setRating(Integer.parseInt(formRequestDto.getRating()));
        }
        if ((list1 = formRequestDto.getImages()) != null) {
            form.setImages(new ArrayList<String>(list1));
        }
        if (formRequestDto.getDeliveryDate() != null) {
            form.setDeliveryDate(Date.from(formRequestDto.getDeliveryDate().atStartOfDay(ZoneOffset.UTC).toInstant()));
        }
        form.setDurationInMMSS(formRequestDto.getDurationInMMSS());
        form.setOrderTotal(formRequestDto.getOrderTotal());
        form.setActiveStatus(formRequestDto.getActiveStatus());
        form.setPaymentId(formRequestDto.getPaymentId());
        form.setPaymentStatus(formRequestDto.getPaymentStatus());
        form.setPaymentOrderId(formRequestDto.getPaymentOrderId());
        form.setCreatedDate(LocalDateTime.now());
        return form;
    }

    @Override
    public FormRequestDto toDto(Form form) {
        if (form == null) {
            return null;
        }
        FormRequestDto.FormRequestDtoBuilder formRequestDto = FormRequestDto.builder();
        List<OrderTrackerDto> list = form.getOrderPosition();
        if (list != null) {
            formRequestDto.orderPosition(new ArrayList<OrderTrackerDto>(list));
        }
        formRequestDto.screenshot(form.getScreenshot());
        formRequestDto.status(form.getStatus());
        formRequestDto.mixtureMaster(form.getMixtureMaster());
        List<String> list1 = form.getImages();
        if (list1 != null) {
            formRequestDto.images(new ArrayList<String>(list1));
        }
        formRequestDto.adminClipPath(form.getAdminClipPath());
        formRequestDto.videoPath(form.getVideo());
        formRequestDto.orderTotal(form.getOrderTotal());
        formRequestDto.activeStatus(form.getActiveStatus());
        formRequestDto.paymentId(form.getPaymentId());
        formRequestDto.id(form.getId());
        formRequestDto.name(form.getName());
        formRequestDto.mail(form.getMail());
        formRequestDto.phonenumber(form.getPhonenumber());
        formRequestDto.instrument(form.getInstrument());
        formRequestDto.mood(form.getMood());
        formRequestDto.lanuage(form.getLanuage());
        formRequestDto.artist(form.getArtist());
        formRequestDto.songto(form.getSongto());
        formRequestDto.songfrom(form.getSongfrom());
        formRequestDto.occasion(form.getOccasion());
        formRequestDto.story(form.getStory());
        formRequestDto.clipDuration(form.getClipDuration());
        formRequestDto.clipPath(form.getClipPath());
        formRequestDto.orderNumber(form.getOrderNumber());
        formRequestDto.createdDate(form.getCreatedDate());
        formRequestDto.customerDeliveryDate(form.getCustomerDeliveryDate());
        if (form.getDeliveryDate() != null) {
            formRequestDto.deliveryDate(LocalDateTime.ofInstant(form.getDeliveryDate().toInstant(), ZoneOffset.UTC).toLocalDate());
        }
        formRequestDto.durationInMMSS(form.getDurationInMMSS());
        formRequestDto.comments(form.getComments());
        formRequestDto.rating(String.valueOf(form.getRating()));
        formRequestDto.review(form.getReview());
        formRequestDto.paymentStatus(form.getPaymentStatus());
        formRequestDto.paymentOrderId(form.getPaymentOrderId());
        return formRequestDto.build();
    }

    @Override
    public FormRequestDtoCoAdmin toDtoCoAdmin(Form form) {
        if (form == null) {
            return null;
        }
        FormRequestDtoCoAdmin.FormRequestDtoCoAdminBuilder formRequestDtoCoAdmin = FormRequestDtoCoAdmin.builder();
        List<OrderTrackerDto> list = form.getOrderPosition();
        if (list != null) {
            formRequestDtoCoAdmin.orderPosition(new ArrayList<OrderTrackerDto>(list));
        }
        formRequestDtoCoAdmin.status(form.getStatus());
        formRequestDtoCoAdmin.mixtureMaster(form.getMixtureMaster());
        List<String> list1 = form.getImages();
        if (list1 != null) {
            formRequestDtoCoAdmin.images(new ArrayList<String>(list1));
        }
        formRequestDtoCoAdmin.adminClipPath(form.getAdminClipPath());
        formRequestDtoCoAdmin.videoPath(form.getVideo());
        formRequestDtoCoAdmin.id(form.getId());
        formRequestDtoCoAdmin.name(form.getName());
        formRequestDtoCoAdmin.instrument(form.getInstrument());
        formRequestDtoCoAdmin.mood(form.getMood());
        formRequestDtoCoAdmin.lanuage(form.getLanuage());
        formRequestDtoCoAdmin.artist(form.getArtist());
        formRequestDtoCoAdmin.songto(form.getSongto());
        formRequestDtoCoAdmin.songfrom(form.getSongfrom());
        formRequestDtoCoAdmin.occasion(form.getOccasion());
        formRequestDtoCoAdmin.story(form.getStory());
        formRequestDtoCoAdmin.clipDuration(form.getClipDuration());
        formRequestDtoCoAdmin.clipPath(form.getClipPath());
        formRequestDtoCoAdmin.orderNumber(form.getOrderNumber());
        formRequestDtoCoAdmin.createdDate(form.getCreatedDate());
        formRequestDtoCoAdmin.customerDeliveryDate(form.getCustomerDeliveryDate());
        if (form.getDeliveryDate() != null) {
            formRequestDtoCoAdmin.deliveryDate(LocalDateTime.ofInstant(form.getDeliveryDate().toInstant(), ZoneOffset.UTC).toLocalDate());
        }
        formRequestDtoCoAdmin.durationInMMSS(form.getDurationInMMSS());
        formRequestDtoCoAdmin.comments(form.getComments());
        formRequestDtoCoAdmin.rating(String.valueOf(form.getRating()));
        formRequestDtoCoAdmin.review(form.getReview());
        return formRequestDtoCoAdmin.build();
    }
}

