/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.service.impl;

import com.hepl.tunefortwo.entity.Artist;
import com.hepl.tunefortwo.entity.ArtistMaster;
import com.hepl.tunefortwo.repository.ArtistRepository;
import com.hepl.tunefortwo.service.ArtistService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class ArtistServiceImpl
implements ArtistService {
    private static final Logger log = LoggerFactory.getLogger(ArtistServiceImpl.class);
    private final ArtistRepository artistRepository;

    public ArtistServiceImpl(ArtistRepository artistRepository) {
        this.artistRepository = artistRepository;
    }

    @Override
    public List<ArtistMaster> getAllArtist() {
        log.info("Get all Language");
        return this.artistRepository.findAll();
    }

    @Override
    public ArtistMaster getArtistById(String id) {
        log.info("Fetching artist by ID: {}", (Object)id);
        ArtistMaster artistfound = (ArtistMaster)this.artistRepository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "artist.artistNotFound"));
        return artistfound;
    }

    @Override
    public ArtistMaster setArtistById(Double price, String id) throws ResponseStatusException {
        ArtistMaster artist = (ArtistMaster)this.artistRepository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "artist.artistNotFound"));
        artist.setPrice(price);
        ArtistMaster updatedData = (ArtistMaster)this.artistRepository.save(artist);
        return updatedData;
    }

    @Override
    public List<ArtistMaster> addCollection() {
        List findAllArtists = this.artistRepository.findAll();
        if (findAllArtists.isEmpty()) {
            ArtistMaster artistm = new ArtistMaster();
            artistm.setArtist(Artist.Male);
            artistm.setPrice(1000.0);
            this.artistRepository.save(artistm);
            ArtistMaster artistf = new ArtistMaster();
            artistf.setArtist(Artist.Female);
            artistf.setPrice(1000.0);
            this.artistRepository.save(artistf);
            ArrayList<ArtistMaster> finalList = new ArrayList<ArtistMaster>();
            finalList.add(artistm);
            finalList.add(artistf);
            return finalList;
        }
        throw new DataIntegrityViolationException("Artist collection already has data");
    }
}

