/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.service.impl;

import com.hepl.tunefortwo.entity.Contact;
import com.hepl.tunefortwo.repository.ContactRepository;
import com.hepl.tunefortwo.service.ContactService;
import com.hepl.tunefortwo.service.MailService;
import com.hepl.tunefortwo.service.TemplateService;
import jakarta.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ContactServiceImp
implements ContactService {
    private static final Logger log = LoggerFactory.getLogger(ContactServiceImp.class);
    @Value(value="${adminMail.contact}")
    private String adminMmailId;
    private final ContactRepository contactRepository;
    private final MailService mailService;
    private final TemplateService templateService;

    public ContactServiceImp(ContactRepository contactRepository, MailService mailService, TemplateService templateService) {
        this.contactRepository = contactRepository;
        this.mailService = mailService;
        this.templateService = templateService;
    }

    @Override
    public Contact saveContact(Contact contactDetails) throws MessagingException {
        this.mailService.sendMailByTemplate(this.templateService.getContactupTemplate(contactDetails), this.adminMmailId, "New Contact Information");
        return (Contact)this.contactRepository.save(contactDetails);
    }
}

