/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.service.impl;

import com.hepl.tunefortwo.entity.FileType;
import com.hepl.tunefortwo.service.FilePathService;
import com.hepl.tunefortwo.service.FileService;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@Service
public class FileServiceImpl
implements FileService {
    private static final Logger log = LoggerFactory.getLogger(FileServiceImpl.class);
    private final Map<String, FilePathService> filePath;

    public FileServiceImpl(List<FilePathService> filePathList) {
        this.filePath = filePathList.stream().collect(Collectors.toMap(path -> path.getClass().getSimpleName(), Function.identity()));
    }

    @Override
    public void init() {
        log.info("Creating upload directories");
        this.filePath.values().forEach(path -> {
            try {
                Files.createDirectories(path.getDestinationPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "error.couldNotInitializeStorage");
            }
        });
    }

    @Override
    public String uploadFile(MultipartFile files, FileType fileType) throws IOException {
        System.out.println(files + " == " + fileType);
        Date date = new Date();
        Long timestamp = date.getTime();
        String filename = timestamp + "-" + files.getOriginalFilename();
        System.out.println(filename);
        Path location = ((FilePathService)this.filePath.getOrDefault(fileType.label, null)).getDestinationPath();
        System.out.println((Object)this.filePath.getOrDefault(fileType.label, null));
        Path destinationFile = location.resolve(Paths.get(filename, new String[0])).normalize().toAbsolutePath();
        System.out.println(destinationFile);
        if (!destinationFile.getParent().equals(location.toAbsolutePath())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "error.badFilePath");
        }
        try (InputStream inputStream = files.getInputStream();){
            Files.copy(inputStream, destinationFile, StandardCopyOption.REPLACE_EXISTING);
        }
        return filename;
    }

    @Override
    public String uploadFile(byte[] fileByte, FileType fileType, String fileName) throws IOException {
        String filename = fileName;
        Path location = ((FilePathService)this.filePath.getOrDefault(fileType.label, null)).getDestinationPath();
        Path destinationFile = location.resolve(Paths.get(filename, new String[0])).normalize().toAbsolutePath();
        if (!destinationFile.getParent().equals(location.toAbsolutePath())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "error.badFilePath");
        }
        Files.write(destinationFile, fileByte, StandardOpenOption.CREATE);
        return filename;
    }

    @Override
    public void deleteFile(String filename, FileType fileType) throws IOException {
        log.info("Delete file ... {}", (Object)filename);
        Path file = this.load(filename, fileType);
        Files.delete(file);
    }

    @Override
    public Resource loadAsResource(String filename, FileType fileType) throws MalformedURLException {
        log.info("Downloading file ... {}", (Object)filename);
        Path file = this.load(filename, fileType);
        UrlResource resource = new UrlResource(file.toUri());
        if (resource.exists() || resource.isReadable()) {
            return resource;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "error.fileNotFound");
    }

    @Override
    public void moveToBin(String filename, FileType fileType) throws IOException {
        log.info("Moving file to bin ... {}", (Object)filename);
        Path currentfile = this.load(filename, fileType);
        Path destinationFile = ((FilePathService)this.filePath.getOrDefault(FileType.BIN.label, null)).getDestinationPath().resolve(Paths.get(filename, new String[0])).normalize().toAbsolutePath();
        Files.move(currentfile, destinationFile, StandardCopyOption.REPLACE_EXISTING);
    }

    private Path load(String filename, FileType fileType) {
        return ((FilePathService)this.filePath.getOrDefault(fileType.label, null)).getDestinationPath().resolve(filename);
    }

    @Override
    public FilePathService getFilePathService(FileType fileType) {
        return this.filePath.getOrDefault(fileType.label, null);
    }
}

