/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.service.impl;

import com.hepl.tunefortwo.service.HashingService;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HashingServiceImpl
implements HashingService {
    private static final Logger log = LoggerFactory.getLogger(HashingServiceImpl.class);
    private static final String ALGORITHM = "AES/GCM/NoPadding";
    private static final int KEY_SIZE = 256;
    private static final int ITERATION_COUNT = 100000;
    private static final int TAG_LENGTH = 128;
    private static final String PASSWORD = "SECRET_KEY";

    @Override
    public String encryption(String plainText) throws Exception {
        log.info("encrypting the data: ${}", (Object)plainText);
        return HashingServiceImpl.encrypt(plainText, PASSWORD);
    }

    @Override
    public String decryption(String encryptedData) throws Exception {
        log.info("decrypting the data: ${}", (Object)encryptedData);
        return HashingServiceImpl.decrypt(encryptedData, PASSWORD);
    }

    public static String encrypt(String plaintext, String password) throws Exception {
        byte[] salt = HashingServiceImpl.generateRandomBytes(16);
        SecretKey keySpec = HashingServiceImpl.deriveKeyFromPassword(password, salt);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        byte[] iv = HashingServiceImpl.generateRandomBytes(12);
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)keySpec, gcmParameterSpec);
        byte[] ciphertext = cipher.doFinal(plaintext.getBytes());
        return Base64.getEncoder().encodeToString(ciphertext) + ":" + Base64.getEncoder().encodeToString(iv) + ":" + Base64.getEncoder().encodeToString(salt);
    }

    public static String decrypt(String ciphertext, String password) throws Exception {
        String[] parts = ciphertext.split(":");
        byte[] encryptedData = Base64.getDecoder().decode(parts[0]);
        byte[] iv = Base64.getDecoder().decode(parts[1]);
        byte[] salt = Base64.getDecoder().decode(parts[2]);
        SecretKey keySpec = HashingServiceImpl.deriveKeyFromPassword(password, salt);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
        cipher.init(2, (Key)keySpec, gcmParameterSpec);
        byte[] decryptedData = cipher.doFinal(encryptedData);
        return new String(decryptedData);
    }

    private static SecretKey deriveKeyFromPassword(String password, byte[] salt) throws Exception {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, 100000, 256);
        SecretKey tmp = factory.generateSecret(spec);
        return new SecretKeySpec(tmp.getEncoded(), "AES");
    }

    private static byte[] generateRandomBytes(int length) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] bytes = new byte[length];
        secureRandom.nextBytes(bytes);
        return bytes;
    }
}

