/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.service.impl;

import com.hepl.tunefortwo.dto.AccessControlStatus;
import com.hepl.tunefortwo.dto.InstrumentImagesDTO;
import com.hepl.tunefortwo.dto.InstrumentRequestDto;
import com.hepl.tunefortwo.entity.Instrument;
import com.hepl.tunefortwo.repository.InstrumentRepository;
import com.hepl.tunefortwo.service.InstrumentService;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class InstrumentServiceImpl
implements InstrumentService {
    private static final Logger log = LoggerFactory.getLogger(InstrumentServiceImpl.class);
    private final InstrumentRepository instrumentRepository;
    private final MongoTemplate mongoTemplate;

    public InstrumentServiceImpl(InstrumentRepository instrumentRepository, MongoTemplate mongoTemplate) {
        this.instrumentRepository = instrumentRepository;
        this.mongoTemplate = mongoTemplate;
    }

    @Override
    public Instrument saveInstrument(InstrumentRequestDto data) {
        log.info("save Instrument");
        Instrument instrument = new Instrument();
        Instrument existingInstrument = this.instrumentRepository.findByName(data.getName());
        if (existingInstrument != null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "An Instrument already exists with the name :" + data.getName());
        }
        instrument.setName(data.getName());
        instrument.setPrice(data.getPrice());
        instrument.setAudio(data.getAudioPath());
        instrument.setAudioDuration(data.getAudioDuration());
        instrument.setDescription(data.getDescription());
        instrument.setImage(data.getImage());
        instrument.setImage(data.getImage());
        instrument.setImageTitle(data.getImageTitle());
        instrument.setBestSeller(data.isBestSeller());
        if (data.getInstrumentCategory() != null) {
            instrument.setInstrumentCategory(data.getInstrumentCategory());
        }
        return (Instrument)this.instrumentRepository.save(instrument);
    }

    @Override
    public List<Instrument> getAllInstrumentsSortedByPrice(Sort.Direction direction) {
        log.info("Get all Instruments sorted by price in {} order", (Object)direction);
        return this.instrumentRepository.findActiveInstrumentsSortedByPrice(direction);
    }

    @Override
    public List<Instrument> getAllInstrumentsByActive() {
        log.info("Get all Instruments");
        return this.instrumentRepository.findActiveInstruments(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"price")}));
    }

    @Override
    public void updateInstrument(InstrumentRequestDto requestDto, String id) {
        Instrument instrumentWithSameName;
        log.info("Updating instrument with ID: {}", (Object)id);
        Instrument existingInstrument = (Instrument)this.instrumentRepository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "instrument.instrumentNotFoundwith ID: " + id));
        if (!existingInstrument.getName().equals(requestDto.getName()) && (instrumentWithSameName = this.instrumentRepository.findByName(requestDto.getName())) != null && !instrumentWithSameName.getId().equals(id)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "An Instrument already exists with the name :" + requestDto.getName());
        }
        existingInstrument.setName(requestDto.getName());
        existingInstrument.setPrice(requestDto.getPrice());
        if (requestDto.getAudio() != null) {
            existingInstrument.setAudio(requestDto.getAudioPath());
        }
        existingInstrument.setImage(requestDto.getImage());
        existingInstrument.setDescription(requestDto.getDescription());
        existingInstrument.setImageTitle(requestDto.getImageTitle());
        existingInstrument.setBestSeller(requestDto.isBestSeller());
        if (requestDto.getAudioDuration() != null) {
            existingInstrument.setAudioDuration(requestDto.getAudioDuration());
        }
        if (requestDto.getInstrumentCategory() != null) {
            existingInstrument.setInstrumentCategory(requestDto.getInstrumentCategory());
        }
        this.instrumentRepository.save(existingInstrument);
    }

    @Override
    public Instrument getInstrumentById(String id) {
        log.info("Get instrument by id");
        Instrument instrument = (Instrument)this.instrumentRepository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "error.resourceNotFound"));
        return instrument;
    }

    @Override
    public void updateActionControlStatus(AccessControlStatus status, String id) {
        log.info("Change action status .. ", (Object)id);
        this.instrumentRepository.updateAccessControlStatus(id, status.toString(), this.mongoTemplate);
    }

    public Long countAllInstrument() {
        log.info("Count all instrument");
        return this.instrumentRepository.count();
    }

    @Override
    public void deleteInstrument(String id) {
        log.info("Delete instrument");
        this.instrumentRepository.deleteById(id);
    }

    @Override
    public void deleteAllInstrument(List<String> ids) {
        log.info("Delete all instrument");
        for (String id : ids) {
            this.instrumentRepository.deleteById(id);
        }
    }

    @Override
    public void updateAllActionControlStatus(AccessControlStatus status, List<String> ids) {
        log.info("Change action status .. {} " + ids);
        for (String id : ids) {
            this.instrumentRepository.updateAccessControlStatus(id, status.toString(), this.mongoTemplate);
        }
    }

    @Override
    public List<InstrumentImagesDTO> getAllImagesForInstruments() {
        List allInst = this.instrumentRepository.findAll();
        if (allInst.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "error.resourceNotFound");
        }
        List<InstrumentImagesDTO> instrumentImages = allInst.stream().map(inst -> new InstrumentImagesDTO(inst.getName(), inst.getImage(), inst.getImageTitle())).collect(Collectors.toList());
        HashMap<String, List<InstrumentImagesDTO>> data = new HashMap<String, List<InstrumentImagesDTO>>();
        data.put("allInstrumentImages", instrumentImages);
        return instrumentImages;
    }
}

