/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.service.impl;

import com.hepl.tunefortwo.service.MailService;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.internet.MimeMessage;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Service
public class MailServiceImpl
implements MailService {
    private static final Logger log = LoggerFactory.getLogger(MailServiceImpl.class);
    public static String FRONTEND_BASE_URL;
    public static String BACKEND_BASE_URL;
    @Value(value="${adminMail.id}")
    public String adminFromMail;
    private final JavaMailSender javaMailSender;
    @Value(value="${spring.imap.host}")
    public String imapHost;
    @Value(value="${spring.imap.port}")
    public int imapPort;
    @Value(value="${spring.imap.username}")
    public String imapUsername;
    @Value(value="${spring.imap.password}")
    public String imapPassword;

    @Value(value="${baseUrl.frontend}")
    public void setFrontendBaseUrl(String frontendBaseUrl) {
        FRONTEND_BASE_URL = frontendBaseUrl;
    }

    @Value(value="${baseUrl.backend}")
    public void setBackendBaseUrl(String backendBaseUrl) {
        BACKEND_BASE_URL = backendBaseUrl;
    }

    public MailServiceImpl(JavaMailSender javaMailSender) {
        this.javaMailSender = javaMailSender;
    }

    @Override
    public void sendMailByTemplate(String content, String recepient, String subject) throws MessagingException {
        log.info("Sending mail ... {}", (Object)recepient);
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "UTF-8");
        message.setSubject(subject);
        message.setFrom(this.adminFromMail);
        if (subject == "Order Confirmed") {
            message.setFrom(this.adminFromMail);
        }
        if (subject == "Order Delivery Email") {
            message.setFrom(this.adminFromMail);
        }
        message.setTo(recepient);
        message.setText(content, true);
        this.javaMailSender.send(mimeMessage);
        this.saveToSentFolder(mimeMessage, recepient, subject, content);
    }

    public void saveToSentFolder(MimeMessage mimeMessage, String recipient, String subject, String content) throws MessagingException {
        try {
            Properties properties = new Properties();
            properties.put("mail.store.protocol", "imap");
            properties.put("mail.imap.host", this.imapHost);
            properties.put("mail.imap.port", (Object)this.imapPort);
            properties.put("mail.imap.ssl.enable", "true");
            Session emailSession = Session.getDefaultInstance((Properties)properties);
            Store store = emailSession.getStore("imap");
            store.connect(this.imapHost, this.imapUsername, this.imapPassword);
            Folder sentFolder = store.getFolder("INBOX.Sent");
            if (!sentFolder.exists()) {
                throw new MessagingException("Sent folder not found on the server.");
            }
            sentFolder.open(2);
            MimeMessage mimeMessageToSave = new MimeMessage(emailSession);
            mimeMessageToSave.setFrom(this.imapUsername);
            mimeMessageToSave.setRecipients(Message.RecipientType.TO, recipient);
            mimeMessageToSave.setSubject(subject);
            mimeMessageToSave.setContent((Object)content, "text/html");
            sentFolder.appendMessages(new Message[]{mimeMessageToSave});
            sentFolder.close(false);
            store.close();
        }
        catch (Exception e) {
            log.error("Failed to save the email to the Sent folder", (Throwable)e);
        }
    }
}

