/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.service.impl;

import com.hepl.tunefortwo.dto.AccessControlStatus;
import com.hepl.tunefortwo.entity.Mood;
import com.hepl.tunefortwo.repository.MoodRepository;
import com.hepl.tunefortwo.service.MoodService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class MoodServiceImpl
implements MoodService {
    private static final Logger log = LoggerFactory.getLogger(MoodServiceImpl.class);
    private final MoodRepository moodRepository;
    private final MongoTemplate mongoTemplate;

    public MoodServiceImpl(MoodRepository moodRepository, MongoTemplate mongoTemplate) {
        this.moodRepository = moodRepository;
        this.mongoTemplate = mongoTemplate;
    }

    @Override
    public Mood saveMood(String name) {
        log.info("save Mood");
        Mood mood = new Mood();
        Mood existingMood = this.moodRepository.findByName(name);
        if (existingMood != null) {
            throw new IllegalArgumentException("mood.moodAlreadyExistedname :" + existingMood.getName());
        }
        if (name != null) {
            mood.setName(name);
        }
        return (Mood)this.moodRepository.save(mood);
    }

    @Override
    public Mood getMoodById(String id) {
        log.info("Get mood by id");
        Mood mood = (Mood)this.moodRepository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "error.resourceNotFound"));
        return mood;
    }

    @Override
    public List<Mood> getAllMoods() {
        log.info("Get all mood");
        return this.moodRepository.findAll();
    }

    @Override
    public List<Mood> getAllMoodsByActive() {
        log.info("Get all mood");
        return this.moodRepository.findActiveMood();
    }

    @Override
    public void updateMood(String requestDto, String id) {
        Mood moodWithSameName;
        log.info("Updating mood with ID: {}", (Object)id);
        Mood existingMood = (Mood)this.moodRepository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "mood.moodNotFoundwith ID: " + id));
        if (!existingMood.getName().equals(requestDto) && (moodWithSameName = this.moodRepository.findByName(requestDto)) != null && !moodWithSameName.getId().equals(id)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "mood.moodAlreadyExistedname :" + requestDto);
        }
        existingMood.setName(requestDto);
        this.moodRepository.save(existingMood);
    }

    @Override
    public void updateActionControlStatus(AccessControlStatus status, String id) {
        log.info("Change action status .. {}", (Object)id);
        this.moodRepository.updateAccessControlStatus(id, status.toString(), this.mongoTemplate);
    }

    @Override
    public void deleteMood(String id) {
        log.info("Delete mood");
        this.moodRepository.deleteById(id);
    }

    @Override
    public void deleteAllMood(List<String> ids) {
        log.info("Delete all mood");
        for (String id : ids) {
            this.moodRepository.deleteById(id);
        }
    }

    @Override
    public void updateAllActionControlStatus(AccessControlStatus status, List<String> ids) {
        log.info("Change action status .. {} " + ids);
        for (String id : ids) {
            this.moodRepository.updateAccessControlStatus(id, status.toString(), this.mongoTemplate);
        }
    }
}

