/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.service.impl;

import com.hepl.tunefortwo.service.MailService;
import com.hepl.tunefortwo.service.OtpService;
import com.hepl.tunefortwo.service.TemplateService;
import jakarta.mail.MessagingException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

@Service
public class OtpServiceImpl
implements OtpService {
    private static final Logger logger = LoggerFactory.getLogger(OtpServiceImpl.class);
    private final JavaMailSender mailSender;
    private final MailService mailService;
    private final TemplateService templateService;
    private final RedisTemplate<String, String> redisTemplate;
    private static final long OTP_VALID_DURATION = 600000L;
    private static final long RESEND_OTP_DELAY = 60000L;
    private static final int MAX_RESEND_ATTEMPTS = 5;
    private static final int MAX_REQUESTS_PER_WINDOW = 50;
    private static final long THROTTLE_WINDOW_DURATION = 3600000L;
    private static final String LAST_SENT_KEY_SUFFIX = ":lastSent";
    private static final String RESEND_COUNT_KEY_SUFFIX = ":resendCount";
    private static final String REQUEST_COUNT_KEY_SUFFIX = ":requestCount";

    @Autowired
    public OtpServiceImpl(JavaMailSender mailSender, MailService mailService, TemplateService templateService, RedisTemplate<String, String> redisTemplate) {
        this.mailSender = mailSender;
        this.mailService = mailService;
        this.templateService = templateService;
        this.redisTemplate = redisTemplate;
    }

    @Override
    public void sendOtp(String email, String name) throws MessagingException {
        if (this.isThrottled(email)) {
            throw new IllegalStateException("Too many requests. Please try again later.");
        }
        String otp = this.generateOtp();
        logger.info("Generated OTP for {}: {}", (Object)email, (Object)otp);
        this.saveOtpToRedis(email, otp);
        this.updateOtpMetaData(email, true);
        this.mailService.sendMailByTemplate(this.templateService.getOtpTemplate(name, otp), email, "OTP Email");
    }

    @Override
    public boolean verifyOtp(String email, String otp) {
        String cachedOtp = (String)this.redisTemplate.opsForValue().get((Object)email);
        if (cachedOtp != null && cachedOtp.equals(otp)) {
            this.redisTemplate.delete((Object)email);
            this.redisTemplate.delete((Object)(email + LAST_SENT_KEY_SUFFIX));
            this.redisTemplate.delete((Object)(email + RESEND_COUNT_KEY_SUFFIX));
            String verifiedKey = email + ":verified";
            this.redisTemplate.opsForValue().set((Object)verifiedKey, (Object)"true", 600000L, TimeUnit.MILLISECONDS);
            return true;
        }
        return false;
    }

    @Override
    public String generateOtp() {
        return String.format("%06d", new Random().nextInt(999999));
    }

    @Override
    public void resendOtp(String email, String name) throws MessagingException {
        String lastSentKey = email + LAST_SENT_KEY_SUFFIX;
        String resendCountKey = email + RESEND_COUNT_KEY_SUFFIX;
        Long lastSentTime = this.redisTemplate.opsForValue().get((Object)lastSentKey) != null ? Long.parseLong((String)this.redisTemplate.opsForValue().get((Object)lastSentKey)) : 0L;
        Integer resendCount = this.redisTemplate.opsForValue().get((Object)resendCountKey) != null ? Integer.parseInt((String)this.redisTemplate.opsForValue().get((Object)resendCountKey)) : 0;
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastSentTime < 60000L) {
            throw new IllegalStateException("Please wait before requesting a new OTP.");
        }
        if (resendCount >= 5) {
            throw new IllegalStateException("Too many resend attempts. Please try again later.");
        }
        String otp = this.generateOtp();
        this.saveOtpToRedis(email, otp);
        this.updateOtpMetaData(email, false);
        logger.info("Resent OTP for {}: {}", (Object)email, (Object)otp);
        this.sendOtp(email, name);
    }

    @Override
    public void saveOtpToRedis(String email, String otp) {
        this.redisTemplate.opsForValue().set((Object)email, (Object)otp, 600000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void updateOtpMetaData(String email, boolean isFirstSend) {
        String lastSentKey = email + LAST_SENT_KEY_SUFFIX;
        String resendCountKey = email + RESEND_COUNT_KEY_SUFFIX;
        long currentTime = System.currentTimeMillis();
        this.redisTemplate.opsForValue().set((Object)lastSentKey, (Object)String.valueOf(currentTime), 600000L, TimeUnit.MILLISECONDS);
        if (isFirstSend) {
            this.redisTemplate.opsForValue().set((Object)resendCountKey, (Object)"0", 600000L, TimeUnit.MILLISECONDS);
        } else {
            this.redisTemplate.opsForValue().increment((Object)resendCountKey);
        }
    }

    private boolean isThrottled(String email) {
        String requestCountKey = email + REQUEST_COUNT_KEY_SUFFIX;
        Long requestCount = this.redisTemplate.opsForValue().get((Object)requestCountKey) != null ? Long.parseLong((String)this.redisTemplate.opsForValue().get((Object)requestCountKey)) : 0L;
        Long currentTime = System.currentTimeMillis();
        Long windowStart = currentTime - 3600000L;
        if (requestCount >= 50L) {
            return true;
        }
        this.redisTemplate.opsForValue().increment((Object)requestCountKey);
        this.redisTemplate.expire((Object)requestCountKey, 3600000L, TimeUnit.MILLISECONDS);
        return false;
    }

    @Override
    public boolean isEmailVerified(String email) {
        String verifiedKey = email + ":verified";
        return "true".equals(this.redisTemplate.opsForValue().get((Object)verifiedKey));
    }
}

