/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.service.impl;

import com.hepl.tunefortwo.entity.Contact;
import com.hepl.tunefortwo.service.TemplateService;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

@Service
public class TemplateServiceImpl
implements TemplateService {
    private static final Logger log = LoggerFactory.getLogger(TemplateServiceImpl.class);
    @Value(value="${com.custom.reset-link}")
    private String resetPasswordLink;
    private final TemplateEngine templateEngine;

    public TemplateServiceImpl(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    @Override
    public String getForgotPasswordTemplate(String email, String recepientName, String hashed) {
        log.info("Generating forgot mail using html ...");
        Context context = new Context();
        context.setVariable("to", (Object)email);
        this.setDefaultContext(context);
        context.setVariable("recepient", (Object)recepientName);
        context.setVariable("resetLink", (Object)(this.resetPasswordLink + "?token=" + hashed));
        return this.templateEngine.process("reset-mail", (IContext)context);
    }

    @Override
    public String getAccountSetupTemlate(String recepientName, LocalDate createdDate, String artist, String instrument, LocalDate specificDate, String orderNumber, String tracker) {
        log.info("Generating account setup mail using html ...");
        Context context = new Context();
        this.setDefaultContext(context);
        context.setVariable("customerName", (Object)recepientName);
        context.setVariable("specificDate", (Object)specificDate);
        context.setVariable("orderNumber", (Object)orderNumber);
        context.setVariable("orderDate", (Object)createdDate);
        context.setVariable("artist", (Object)artist);
        context.setVariable("orderNumber", (Object)orderNumber);
        context.setVariable("instrument", (Object)instrument);
        context.setVariable("base64EncodedString", (Object)"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");
        context.setVariable("trackYourOrder", (Object)tracker);
        return this.templateEngine.process("confirmMail", (IContext)context);
    }

    @Override
    public String getContactupTemplate(Contact contactDetails) {
        log.info("Generating account setup mail using html ...");
        Context context = new Context();
        this.setDefaultContext(context);
        context.setVariable("visitorName", (Object)contactDetails.getName());
        context.setVariable("visitorEmail", (Object)contactDetails.getMail());
        context.setVariable("mobileNumber", (Object)contactDetails.getPhonenumber());
        context.setVariable("VisitorMessage", (Object)contactDetails.getMessage());
        context.setVariable("base64EncodedString", (Object)"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");
        return this.templateEngine.process("mailtemplate2 4", (IContext)context);
    }

    @Override
    public String getOrderConfirmTemplate(String songLink, String reviewLink, String orderNumber, String Name, String artist, String instrument, LocalDate createdDate, String title, LocalDate deliveryDate) {
        log.info("Generating account setup mail using html ...");
        Context context = new Context();
        this.setDefaultContext(context);
        log.info("songDownload......." + songLink);
        context.setVariable("songDownload", (Object)songLink);
        context.setVariable("songreviewlink", (Object)reviewLink);
        context.setVariable("customerName", (Object)Name);
        context.setVariable("orderDate", (Object)createdDate);
        context.setVariable("instrument", (Object)instrument);
        context.setVariable("orderNumber", (Object)orderNumber);
        context.setVariable("artist", (Object)artist);
        context.setVariable("songTitle", (Object)title);
        context.setVariable("deliveryDate", (Object)deliveryDate);
        return this.templateEngine.process("deliveryTemplate", (IContext)context);
    }

    @Override
    public String getCustomPdfData(String paragraph) {
        log.info("Generating forgot mail using html ...");
        Context context = new Context();
        context.setVariable("data", (Object)paragraph);
        return this.templateEngine.process("custom-pdf", (IContext)context);
    }

    @Override
    public String getComposeMailTemplate(String content) {
        log.info("generating compose mail using html...");
        Context context = new Context();
        context.setVariable("content", (Object)content);
        this.setDefaultContext(context);
        return this.templateEngine.process("custom-mail", (IContext)context);
    }

    private void setDefaultContext(Context context) {
        context.setVariable("logo", (Object)"logo");
        context.setVariable("header", (Object)"header");
        context.setVariable("background", (Object)"background");
    }

    @Override
    public String getResetPasswordTemplateNew(String userName, String resetPassWordLink) {
        log.info("Generating reset password mail using html ...");
        Context context = new Context();
        this.setDefaultContext(context);
        context.setVariable("adminUserName", (Object)userName);
        context.setVariable("resetPasswordLink", (Object)resetPassWordLink);
        return this.templateEngine.process("reset-password", (IContext)context);
    }

    @Override
    public String getOtpTemplate(String name, String otp) {
        log.info("Generating OTP mail using html ...");
        Context context = new Context();
        this.setDefaultContext(context);
        context.setVariable("otp", (Object)otp);
        context.setVariable("recipientName", (Object)name);
        return this.templateEngine.process("mailOtpVerification", (IContext)context);
    }

    @Override
    public String getPaymentMessageTemplate(String paymentStatus, String paymentMode, BigDecimal paymentAmount, String userName, String formOrderId, int attempts, LocalDate createdDate, BigDecimal amountDue, String paymentId, String mail, String mobileNumber) {
        log.info("Generating account setup mail using html ...");
        Context context = new Context();
        context.setVariable("amountDue", (Object)amountDue);
        context.setVariable("emailId", (Object)mail);
        context.setVariable("mobileNumber", (Object)mobileNumber);
        this.setDefaultContext(context);
        context.setVariable("userName", (Object)userName);
        context.setVariable("formOrderNumber", (Object)formOrderId);
        context.setVariable("createdDate", (Object)createdDate);
        context.setVariable("amountPaid", (Object)paymentAmount);
        context.setVariable("paymentStatus", (Object)paymentStatus);
        context.setVariable("paymentMethod", (Object)paymentMode);
        context.setVariable("paymentId", (Object)paymentId);
        return this.templateEngine.process("payment", (IContext)context);
    }
}

