/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.utils;

import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class PasswordGenerator {
    public static final String ALLOWED_SPL_CHARACTERS = "!@#$%^&*()_+";
    public static final String ERROR_CODE = "ERRONEOUS_SPECIAL_CHARS";
    static Random random = new SecureRandom();

    private PasswordGenerator() {
        throw new IllegalStateException("Password Generator");
    }

    public static String generateSecureRandomPassword() {
        Stream<Character> pwdStream = Stream.concat(PasswordGenerator.getRandomNumbers(2), Stream.concat(PasswordGenerator.getRandomSpecialAllowerdChars(2), Stream.concat(PasswordGenerator.getRandomAlphabets(2, true), PasswordGenerator.getRandomAlphabets(4, false))));
        List charList = pwdStream.collect(Collectors.toList());
        Collections.shuffle(charList);
        return charList.stream().collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
    }

    public static Stream<Character> getRandomAlphabets(int count, boolean upperCase) {
        IntStream characters = null;
        characters = upperCase ? random.ints(count, 65, 90) : random.ints(count, 97, 122);
        return characters.mapToObj(data -> Character.valueOf((char)data));
    }

    public static Stream<Character> getRandomNumbers(int count) {
        IntStream numbers = random.ints(count, 48, 57);
        return numbers.mapToObj(data -> Character.valueOf((char)data));
    }

    public static Stream<Character> getRandomSpecialChars(int count) {
        IntStream specialChars = random.ints(count, 33, 45);
        return specialChars.mapToObj(data -> Character.valueOf((char)data));
    }

    public static Stream<Character> getRandomSpecialAllowerdChars(int count) {
        IntStream specialChars = random.ints(count, 0, 12);
        char[] specialCharacters = ALLOWED_SPL_CHARACTERS.toCharArray();
        return specialChars.mapToObj(data -> Character.valueOf(specialCharacters[data]));
    }
}

