/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.utils;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.hepl.tunefortwo.utils.ValidPhoneNumber;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;

public class PhoneNumberValidator
implements ConstraintValidator<ValidPhoneNumber, String> {
    private final PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();

    public boolean isValid(String phoneNumber, ConstraintValidatorContext context) {
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            return true;
        }
        try {
            Phonenumber.PhoneNumber number = this.phoneNumberUtil.parse((CharSequence)phoneNumber, "IN");
            return this.phoneNumberUtil.isValidNumber(number);
        }
        catch (NumberParseException e) {
            return false;
        }
    }
}

