/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo;

import com.hepl.tunefortwo.config.properties.StorageProperties;
import com.hepl.tunefortwo.service.FileService;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.servers.Server;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;

@SpringBootApplication
@EnableMethodSecurity
@OpenAPIDefinition(info=@Info(title="Tune For Two", version="v1.0", contact=@Contact(email="prem.l@hepl.com")), servers={@Server(url="${com.custom.swagger-path}"), @Server(url="${com.custom.swagger-live-path}")})
@SecurityScheme(name="Bearer Authentication", type=SecuritySchemeType.HTTP, bearerFormat="JWT", scheme="bearer")
@EnableConfigurationProperties(value={StorageProperties.class})
public class TunefortwoApplication {
    public static void main(String[] args) {
        SpringApplication.run(TunefortwoApplication.class, (String[])args);
    }

    @Bean
    CommandLineRunner init(FileService fileService) {
        return args -> fileService.init();
    }
}

