/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.config.annotation.validator;

import com.hepl.tunefortwo.config.annotation.ValueOfEnum;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ValueOfEnumValidator
implements ConstraintValidator<ValueOfEnum, CharSequence> {
    private List<String> acceptedValues;

    public void initialize(ValueOfEnum annotation) {
        this.acceptedValues = Stream.of(annotation.enumClass().getEnumConstants()).map(Enum::name).collect(Collectors.toList());
    }

    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        return this.acceptedValues.contains(value.toString());
    }
}

