/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.config.exceptions;

import com.hepl.tunefortwo.config.exceptions.FieldException;
import com.hepl.tunefortwo.config.i18n.Translator;
import com.hepl.tunefortwo.dto.GenericResponse;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.server.ResponseStatusException;

@ControllerAdvice
public class ErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(ErrorHandler.class);
    private final Translator translator;

    public ErrorHandler(Translator translator) {
        this.translator = translator;
    }

    @ExceptionHandler
    public ResponseEntity<GenericResponse> handleException(ResponseStatusException exc) {
        GenericResponse error = new GenericResponse(false);
        error.setMessage(this.translator.toLocale(exc.getReason()));
        error.setErrorType("OPERATIONAL");
        log.error("Operational Exception occured - {}", (Object)error.getTimestamp(), (Object)exc);
        return new ResponseEntity((Object)error, exc.getStatusCode());
    }

    @ExceptionHandler
    public ResponseEntity<GenericResponse> handleException(Exception exc) {
        GenericResponse error = new GenericResponse(false);
        error.setMessage(exc.getLocalizedMessage());
        error.setErrorType("FATAL");
        log.error("Fatal Exception occured - {}", (Object)error.getTimestamp(), (Object)exc);
        return new ResponseEntity((Object)error, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler
    public ResponseEntity<GenericResponse> handleValidationExceptions(MethodArgumentNotValidException exc) {
        HashMap<String, String> errors = new HashMap<String, String>();
        exc.getBindingResult().getAllErrors().forEach(error -> {
            String fieldName = ((FieldError)error).getField();
            String errorMessage = error.getDefaultMessage();
            errors.put(fieldName, errorMessage);
        });
        GenericResponse error2 = new GenericResponse(false);
        error2.setMessage(this.translator.toLocale("error.validationError"));
        error2.setErrorType("OPERATIONAL");
        error2.setErrors(errors);
        log.error("Validation error - {}", (Object)error2.getTimestamp(), (Object)exc);
        return new ResponseEntity((Object)error2, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler
    public ResponseEntity<GenericResponse> handleException(DuplicateKeyException exc) {
        GenericResponse error = new GenericResponse(false);
        error.setMessage(this.translator.toLocale("error.valueExists"));
        error.setErrorType("OPERATIONAL");
        log.error("Operational Exception occured - {}", (Object)error.getTimestamp(), (Object)exc);
        return new ResponseEntity((Object)error, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler
    public ResponseEntity<GenericResponse> handleFieldErrorExceptions(FieldException exc) {
        HashMap<String, String> errors = new HashMap<String, String>();
        exc.getErrors().forEach((k, v) -> errors.put((String)k, this.translator.toLocale((String)v)));
        GenericResponse error = new GenericResponse(false);
        error.setMessage(this.translator.toLocale("error.valueExists"));
        error.setErrorType("OPERATIONAL");
        error.setErrors(errors);
        log.error("Validation error - {}", (Object)error.getTimestamp(), (Object)exc);
        return new ResponseEntity((Object)error, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }
}

