/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.config.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hepl.tunefortwo.dto.GenericResponse;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.stereotype.Component;

@Component
public class CustomAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    private static final Logger log = LoggerFactory.getLogger(CustomAuthenticationEntryPoint.class);

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        GenericResponse re = new GenericResponse(false);
        re.setMessage("Unauthourized");
        log.error("Unauthorized - {}", (Object)re.getTimestamp());
        response.setContentType("application/json");
        response.setStatus(401);
        ServletOutputStream responseStream = response.getOutputStream();
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue((OutputStream)responseStream, (Object)re);
        responseStream.flush();
    }
}

