/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.config.security;

import com.hepl.tunefortwo.entity.Users;
import java.util.Map;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.stereotype.Component;

@Component
public class JWTHelper {
    private final JwtDecoder jwtDecoder;

    public JWTHelper(JwtDecoder jwtDecoder) {
        this.jwtDecoder = jwtDecoder;
    }

    public Map<String, Object> getDetails(Authentication authentication) {
        Jwt jwt = (Jwt)authentication.getPrincipal();
        Jwt decode = this.jwtDecoder.decode(jwt.getTokenValue());
        return decode.getClaimAsMap("userDetails");
    }

    public Users getUserDetail(Authentication authentication) {
        Map<String, Object> details = this.getDetails(authentication);
        Users user = new Users();
        user.setId(details.get("_id").toString());
        user.setUserId(details.get("userId").toString());
        user.setUsername(details.get("username").toString());
        return user;
    }

    public boolean isSecretary(Authentication authentication) {
        Map details = (Map)this.getDetails(authentication).get("role");
        return details.get("name").toString().equalsIgnoreCase("Secretary");
    }
}

