/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.controller;

import com.hepl.tunefortwo.config.i18n.Translator;
import com.hepl.tunefortwo.dto.FiledDto;
import com.hepl.tunefortwo.dto.GenericData;
import com.hepl.tunefortwo.dto.GenericResponse;
import com.hepl.tunefortwo.dto.IsMandatory;
import com.hepl.tunefortwo.entity.Filed;
import com.hepl.tunefortwo.service.FiledService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Create and Manage Filed", description="")
@RestController
@RequestMapping(value={"/v1/Filed"})
public class FiledController {
    private static final Logger log = LoggerFactory.getLogger(FiledController.class);
    private final FiledService filedService;
    private final Translator translator;

    public FiledController(FiledService filedService, Translator translator) {
        this.filedService = filedService;
        this.translator = translator;
    }

    @PostMapping(consumes={"multipart/form-data"})
    public GenericResponse addPayemnt(@ModelAttribute FiledDto data) throws MessagingException, IOException {
        log.info("add Filed");
        this.filedService.addFiled(data);
        GenericResponse response = new GenericResponse(true);
        response.setMessage(this.translator.toLocale("filed.filedSavedSuccessully"));
        return response;
    }

    @GetMapping(value={"/{id}"})
    public GenericResponse getFiledById(@PathVariable String id) {
        log.info("Get Filed");
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setFiled(this.filedService.getFiledById(id));
        response.setData(data);
        return response;
    }

    @GetMapping(value={"/"})
    public GenericResponse getAllFileds() {
        log.info("Get All Filed");
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        Set<String> namesToRemove = Set.of("Mood", "Song Delivery", "Record your story audio");
        List<Filed> allFields = this.filedService.getAllFiled();
        if (allFields.size() > 4) {
            allFields = allFields.subList(4, allFields.size());
        } else {
            allFields.clear();
        }
        List<Filed> filteredList = allFields.stream().filter(f -> !namesToRemove.contains(f.getName())).collect(Collectors.toList());
        data.setFileds(filteredList);
        response.setData(data);
        return response;
    }

    @Operation(description="Update Filed based on id")
    @PutMapping(value={"/{id}"})
    public GenericResponse updateFiled(@PathVariable String id, @RequestParam IsMandatory isMandatory) throws IOException {
        log.info("Update Filed ... {}", (Object)id);
        this.filedService.updateFiled(isMandatory, id);
        GenericResponse response = new GenericResponse(true);
        response.setMessage(this.translator.toLocale("filed.filedUpdatedSuccessfully"));
        return response;
    }
}

