/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.controller;

import com.hepl.tunefortwo.config.i18n.Translator;
import com.hepl.tunefortwo.dto.ContactDto;
import com.hepl.tunefortwo.dto.FormRequestDto;
import com.hepl.tunefortwo.dto.GenericData;
import com.hepl.tunefortwo.dto.GenericResponse;
import com.hepl.tunefortwo.dto.OrderPosition;
import com.hepl.tunefortwo.entity.Contact;
import com.hepl.tunefortwo.entity.FileType;
import com.hepl.tunefortwo.entity.Form;
import com.hepl.tunefortwo.service.AudioService;
import com.hepl.tunefortwo.service.ContactService;
import com.hepl.tunefortwo.service.FileService;
import com.hepl.tunefortwo.service.FormService;
import com.hepl.tunefortwo.service.OtpService;
import com.hepl.tunefortwo.utils.JwtUtils;
import com.itextpdf.text.DocumentException;
import io.jsonwebtoken.Claims;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.mail.MessagingException;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@Tag(name="Create and Manage Form", description="")
@RestController
@RequestMapping(value={"/v1/form"})
public class FormController {
    private static final Logger log = LoggerFactory.getLogger(FormController.class);
    private final Translator translator;
    private final FormService formService;
    private final FileService fileService;
    private final AudioService audioService;
    private final ContactService contactService;
    private final JwtUtils jwtUtils;
    private final OtpService otpService;

    public FormController(Translator translator, FormService formService, FileService fileService, AudioService audioService, ContactService contactService, JwtUtils jwtUtils, OtpService otpService) {
        this.translator = translator;
        this.formService = formService;
        this.fileService = fileService;
        this.audioService = audioService;
        this.contactService = contactService;
        this.jwtUtils = jwtUtils;
        this.otpService = otpService;
    }

    @PostMapping(consumes={"multipart/form-data"})
    public GenericResponse addUser(@Valid @ModelAttribute FormRequestDto formRequestDto) throws MessagingException, IOException {
        log.info("Adding Songs for  Form");
        String phoneNumber = formRequestDto.getPhonenumber();
        String[] phoneComponents = this.formService.extractCountryCodeAndNationalNumber(phoneNumber);
        String countryCode = phoneComponents[0];
        String nationalNumber = phoneComponents[1];
        if (countryCode == null || nationalNumber == null || !this.formService.validateMobileNumber(countryCode, nationalNumber)) {
            GenericResponse response = new GenericResponse(false);
            response.setMessage("Invalid mobile number format or number");
            response.setErrorType("INVALID_PHONE_NUMBER");
            return response;
        }
        if (formRequestDto.getClip() != null) {
            String originalFilename = formRequestDto.getClip().getOriginalFilename();
            if (originalFilename != null) {
                String fileExtension = originalFilename.substring(originalFilename.lastIndexOf(".") + 1);
                List<String> allowedExtensions = Arrays.asList("mp3", "wav", "OGG", "AAC");
                if (!allowedExtensions.contains(fileExtension.toLowerCase())) {
                    throw new MessagingException("Only MP3,AAC, and WAV files are allowed");
                }
            }
            String filename = this.fileService.uploadFile(formRequestDto.getClip(), FileType.CLIP);
            Resource file = this.fileService.loadAsResource(filename, FileType.CLIP);
            formRequestDto.setClipPath(filename);
            Path filePath = Paths.get(file.getURI());
            System.out.println("FilePath while posting---" + filePath);
            double durationInSecondsOne = this.audioService.getAudioDuration(filePath.toFile());
            formRequestDto.setClipDuration(durationInSecondsOne);
            long durationRoundOne = (long)Math.floor(durationInSecondsOne);
            long inMinutes = durationRoundOne / 60L;
            long inSeconds = durationRoundOne % 60L;
            String inFormattedTime = String.format("%02d:%02d", inMinutes, inSeconds);
            formRequestDto.setDurationInMMSS(inFormattedTime);
            if (formRequestDto.getClipDuration() == null) {
                double durationInSeconds = this.audioService.getAudioDuration(filePath.toFile());
                formRequestDto.setClipDuration(durationInSeconds);
                long durationRound = (long)Math.floor(durationInSeconds);
                long minutes = durationRound / 60L;
                long seconds = durationRound % 60L;
                String formattedTime = String.format("%02d:%02d", minutes, seconds);
                formRequestDto.setDurationInMMSS(formattedTime);
            }
        }
        Form form = this.formService.saveForm(formRequestDto);
        GenericResponse response = new GenericResponse(true);
        response.setMessage(this.translator.toLocale("song.songSavedSuccessully") + "id : " + form.getId());
        return response;
    }

    @GetMapping(value={"/paginated"})
    public GenericResponse getAllForms(@RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="10") int size, @RequestParam(defaultValue="orderPosition.updatedDate") String sortBy, @RequestParam(defaultValue="desc") String sortDirection, @RequestParam(value="query", required=false) String query, Authentication authentication) {
        if (authentication == null || !authentication.isAuthenticated()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        Sort sort = Sort.by((String[])new String[]{sortDirection, "orderPosition.updatedDate"});
        Sort.Direction direction = sortDirection.equalsIgnoreCase("desc") ? Sort.Direction.DESC : Sort.Direction.ASC;
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)direction, (String[])new String[]{sortBy}));
        log.info("Fetching forms...");
        GenericResponse response = new GenericResponse(true);
        Map<String, Object> formsPage = this.formService.allForms((Pageable)pageable, isAdmin, query);
        GenericData data = new GenericData();
        data.setFormRequestDtos(formsPage);
        response.setData(data);
        return response;
    }

    @GetMapping(value={"/"})
    public GenericResponse getAllFormsByStatus(@RequestParam OrderPosition position, Authentication authentication) {
        if (authentication == null || !authentication.isAuthenticated()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        log.info("Fetching forms by orderPosition...");
        boolean isAdmin = false;
        boolean isUser = false;
        try {
            String sortDirection = "DESC";
            if (authentication instanceof JwtAuthenticationToken) {
                JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
                Jwt jwt = (Jwt)jwtAuthToken.getToken();
                String tokenValue = jwt.getTokenValue();
                Claims claims = this.jwtUtils.extractClaims(tokenValue);
                String email = claims.getSubject();
                Map userDetails = (Map)claims.get((Object)"userDetails");
                if (userDetails != null) {
                    String roleId = (String)userDetails.get("roleId");
                    String userId = (String)userDetails.get("id");
                    if (roleId.equals("1")) {
                        isAdmin = true;
                    }
                } else {
                    System.out.println("No userDetails found in claims.");
                }
            } else {
                log.debug("Not a valid JWT Token}");
            }
            Sort sort = Sort.by((Sort.Direction)Sort.Direction.fromString((String)sortDirection), (String[])new String[]{"orderPosition.updatedDate"});
            GenericResponse response = new GenericResponse(true);
            Map<String, Object> formsPage = this.formService.getFormsByOrderPosition(position, sort, isAdmin);
            GenericData data = new GenericData();
            data.setFormDtos(formsPage);
            response.setData(data);
            return response;
        }
        catch (Exception e) {
            log.error("Error occurred while fetching forms: {}", (Object)e.getMessage());
            System.out.println(e.getMessage());
            return new GenericResponse(false);
        }
    }

    @GetMapping(value={"/{id}"})
    public GenericResponse getAllFormsByStatus(@PathVariable String id) {
        log.info("Fetching forms by orderPosition...");
        GenericResponse response = new GenericResponse(true);
        FormRequestDto formsPage = this.formService.getFormById(id);
        GenericData data = new GenericData();
        data.setFormRequestDto(formsPage);
        response.setData(data);
        return response;
    }

    @PutMapping(value={"/{id}"}, consumes={"multipart/form-data"})
    public GenericResponse updateSongStatus(@RequestParam OrderPosition orderPosition, @RequestParam(value="file", required=false) MultipartFile audio, @PathVariable(value="id") String id) throws IOException, DocumentException, MessagingException {
        log.info("Update song status");
        if (audio != null) {
            String originalFilename = audio.getOriginalFilename();
            if (originalFilename != null) {
                String fileExtension = originalFilename.substring(originalFilename.lastIndexOf(".") + 1);
                List<String> allowedExtensions = Arrays.asList("mp3", "wav", "OGG", "AAC");
                if (!allowedExtensions.contains(fileExtension.toLowerCase())) {
                    throw new MessagingException("Only MP3,AAC,OGG, and WAV files are allowed");
                }
            }
        } else if (orderPosition == OrderPosition.DELIVERED) {
            throw new MessagingException("For Delivered Orderposition, File attachment is necessary");
        }
        String filePath = "";
        if (audio != null) {
            filePath = this.fileService.uploadFile(audio, FileType.CLIP);
        }
        String updatedStatus = this.formService.updateOrderPosition(orderPosition, id, filePath);
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setId(id);
        data.setStatus(orderPosition.toString());
        response.setData(data);
        String msg = "from : " + orderPosition.toString() + " to : " + updatedStatus;
        response.setMessage(this.translator.toLocale("song.songStatusUpdatedSuccessfully") + msg);
        return response;
    }

    @GetMapping(value={"/song/{filename}"})
    public ResponseEntity<StreamingResponseBody> serveFile(@PathVariable String filename, @RequestHeader HttpHeaders headers) throws IOException {
        log.info("Get filename .. {}", (Object)filename);
        Resource file = this.fileService.loadAsResource(filename, FileType.CLIP);
        if (file == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "error.fileNotFound");
        }
        Path filePath = Paths.get(file.getURI());
        if (!Files.exists(filePath, new LinkOption[0])) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "error.fileNotFound");
        }
        String contentType = Files.probeContentType(filePath);
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        long fileLength = Files.size(filePath);
        long rangeStart = 0L;
        long rangeEnd = fileLength - 1L;
        String range = headers.getFirst("Range");
        if (range != null) {
            String[] ranges = range.replace("bytes=", "").split("-");
            rangeStart = Long.parseLong(ranges[0]);
            if (ranges.length > 1 && !ranges[1].isEmpty()) {
                rangeEnd = Long.parseLong(ranges[1]);
            }
        }
        rangeStart = Math.max(rangeStart, 0L);
        rangeEnd = Math.min(rangeEnd, fileLength - 1L);
        long finalRangeStart = rangeStart;
        long finalRangeEnd = rangeEnd;
        long finalFileLength = fileLength;
        long contentLength = finalRangeEnd - finalRangeStart + 1L;
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Type", contentType);
        responseHeaders.add("Content-Length", String.valueOf(contentLength));
        responseHeaders.add("Accept-Ranges", "bytes");
        responseHeaders.add("Content-Range", String.format("bytes %d-%d/%d", finalRangeStart, finalRangeEnd, finalFileLength));
        StreamingResponseBody responseBody = outputStream -> {
            try (InputStream inputStream = Files.newInputStream(filePath, new OpenOption[0]);){
                int bytesRead;
                inputStream.skip(finalRangeStart);
                byte[] buffer = new byte[8192];
                for (long bytesToRead = contentLength; bytesToRead > 0L && (bytesRead = inputStream.read(buffer, 0, (int)Math.min((long)buffer.length, bytesToRead))) != -1; bytesToRead -= (long)bytesRead) {
                    outputStream.write(buffer, 0, bytesRead);
                }
            }
        };
        return new ResponseEntity((Object)responseBody, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.PARTIAL_CONTENT);
    }

    @GetMapping(value={"/songDownload/{filename}"})
    public ResponseEntity<byte[]> serveFile(@PathVariable String filename) throws IOException, UnsupportedAudioFileException {
        log.info("Get filename .. {}", (Object)filename);
        Resource file = this.fileService.loadAsResource(filename, FileType.CLIP);
        if (file == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "error.fileNotFound");
        }
        String fileNameNew = file.getFilename();
        String modifiedFilename = fileNameNew.replaceAll("^\\d+-", "");
        Path filePath = Paths.get(file.getURI());
        double durationInSeconds = this.audioService.getAudioDuration(filePath.toFile());
        System.out.println(durationInSeconds);
        String mimeType = Files.probeContentType(filePath);
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + modifiedFilename + "\""})).header("Audio-Duration", new String[]{String.valueOf(durationInSeconds)})).contentType(MediaType.parseMediaType((String)(mimeType != null ? mimeType : "application/octet-stream"))).body((Object)file.getContentAsByteArray());
    }

    @PutMapping(value={"/form-update/{id}"}, consumes={"multipart/form-data"})
    public GenericResponse updateSong(@ModelAttribute FormRequestDto dto, @PathVariable(value="id") String id) throws IOException, DocumentException, MessagingException {
        log.info("Update song status");
        this.formService.updateForm(dto, id);
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        response.setData(data);
        response.setMessage(this.translator.toLocale("song.songUpdatedSuccessfully"));
        return response;
    }

    @GetMapping(value={"/orderTracker"})
    public GenericResponse getAllFormsByStatus(@RequestParam String mobileNumber, @RequestParam String orderNumber) {
        log.info("Fetching forms by orderPosition for mobile number: {} and order number: {}", (Object)mobileNumber, (Object)orderNumber);
        GenericResponse response = new GenericResponse(true);
        List<Object> formsPage = this.formService.trackerOrder(mobileNumber, orderNumber);
        GenericData data = new GenericData();
        data.setTracker(formsPage);
        response.setData(data);
        return response;
    }

    @PutMapping(value={"/add-screenshot/{orderNumber}"})
    public GenericResponse addScreenShot(@RequestParam(value="file", required=false) MultipartFile file, @PathVariable(value="orderNumber") String orderNumber) throws IOException, DocumentException {
        log.info("Update screenshot");
        String filePath = null;
        if (file != null) {
            String originalFilename = file.getOriginalFilename();
            if (originalFilename != null) {
                String fileExtension = originalFilename.substring(originalFilename.lastIndexOf(".") + 1);
                List<String> allowedExtensions = Arrays.asList("jpeg", "png", "jpg", "BMP");
                if (!allowedExtensions.contains(fileExtension.toLowerCase())) {
                    throw new IOException("Only Jpeg,Jpg,BMP and Png files are supported");
                }
            }
            filePath = this.fileService.uploadFile(file, FileType.CLIP);
        }
        if (file == null || file.isEmpty()) {
            throw new IllegalArgumentException("No file provided for updating screenshot");
        }
        this.formService.addScreenShot(orderNumber, filePath);
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setId(orderNumber);
        response.setData(data);
        response.setMessage(this.translator.toLocale("screenshot.screenshotSavedSuccessfully"));
        return response;
    }

    @PutMapping(value={"/add-comment/{orderNumber}"})
    public GenericResponse addComment(@PathVariable(value="orderNumber") String orderNumber, @RequestParam(value="comment", required=false) String comment, @RequestParam(value="deliverydate", required=false) LocalDate date) throws IOException, DocumentException, MessagingException {
        log.info("Update comment");
        this.formService.addcomment(orderNumber, comment, date, orderNumber);
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setId(orderNumber);
        response.setData(data);
        response.setMessage(this.translator.toLocale("comments.commentsSavedSuccessfully"));
        return response;
    }

    @PutMapping(value={"/rating-review/{id}"}, consumes={"multipart/form-data"})
    public GenericResponse updateRatingAndReviewForForm(@PathVariable(value="id") String id, @RequestParam(value="rating", required=true) int rating, @RequestParam(value="review", required=false) String review, @RequestParam(required=false) List<MultipartFile> images, @RequestParam(required=false) MultipartFile video) throws IOException {
        ArrayList<String> imagePaths = new ArrayList<String>();
        String videopath = null;
        if (images != null && images.size() > 0) {
            for (MultipartFile image : images) {
                String originalFilename = image.getOriginalFilename();
                if (originalFilename != null) {
                    String fileExtension = originalFilename.substring(originalFilename.lastIndexOf(".") + 1);
                    List<String> allowedExtensions = Arrays.asList("jpeg", "png", "jpg", "BMP");
                    if (!allowedExtensions.contains(fileExtension.toLowerCase())) {
                        throw new IOException("Only Jpeg,Jpg,BMP and Png files are supported");
                    }
                }
                String imagepathForOneImage = this.fileService.uploadFile(image, FileType.CLIP);
                imagePaths.add(imagepathForOneImage);
            }
        }
        if (video != null) {
            String originalFilename = video.getOriginalFilename();
            if (originalFilename != null) {
                String fileExtension = originalFilename.substring(originalFilename.lastIndexOf(".") + 1);
                List<String> allowedExtensions = Arrays.asList("mp4", "MKV", "FLV", "AVI", "WMV");
                if (!allowedExtensions.contains(fileExtension.toLowerCase())) {
                    throw new IOException("Only MP4,WMV,MKV,FLV, and AVI files are supported");
                }
            }
            videopath = this.fileService.uploadFile(video, FileType.CLIP);
        }
        this.formService.updateRatingAndReview(rating, review, id, imagePaths, videopath);
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setId(id);
        response.setData(data);
        response.setMessage(this.translator.toLocale("rating.reviewUpdate"));
        return response;
    }

    @PostMapping(value={"/contactus"}, consumes={"multipart/form-data"})
    public GenericResponse addUser(@Valid @ModelAttribute ContactDto contactDto) throws MessagingException {
        Contact newContact = new Contact();
        newContact.setMail(contactDto.getEmail());
        newContact.setMessage(contactDto.getMessage());
        newContact.setName(contactDto.getName());
        newContact.setPhonenumber(contactDto.getMobileNumber());
        Contact savedContact = this.contactService.saveContact(newContact);
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setContact(savedContact);
        response.setMessage(" Contact Message Saved");
        return response;
    }

    @GetMapping(value={"/rating-review/{id}"})
    public GenericResponse getRatingandReview(@PathVariable(value="id") String id) throws IOException {
        Object imagepath = null;
        Object videopath = null;
        try {
            FormRequestDto formPage = this.formService.getRatingandReview(id);
            GenericResponse response = new GenericResponse(true);
            GenericData data = new GenericData();
            data.setFormRequestDto(formPage);
            response.setData(data);
            return response;
        }
        catch (Exception e) {
            log.error("Error occured while fetching form: {}", (Object)e.getMessage());
            System.out.println(e.getMessage());
            return new GenericResponse(false);
        }
    }

    @PutMapping(value={"/rejectForm/{id}"})
    public GenericResponse rejectAForm(@PathVariable String id, @RequestParam String formStatus) {
        FormRequestDto modifiedStatusOfThForm = this.formService.rejectAFormByItsId(id, formStatus);
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setFormRequestDto(modifiedStatusOfThForm);
        response.setData(data);
        return response;
    }

    @GetMapping(value={"/getrejectedforms"})
    public GenericResponse getAllRejectedForms(@RequestParam String activeStatus) {
        Map<String, Object> availableForms = this.formService.getAllRejectedForms(activeStatus);
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setFormRequestDtos(availableForms);
        response.setData(data);
        return response;
    }

    @PostMapping(value={"/send-otp"})
    public ResponseEntity<String> sendOtp(@RequestParam String email, String name) throws MessagingException {
        this.otpService.sendOtp(email, name);
        return ResponseEntity.ok((Object)("OTP sent to " + email));
    }

    @PostMapping(value={"/verify-otp"})
    public ResponseEntity<String> verifyOtp(@RequestParam String email, @RequestParam String otp) {
        boolean isValid = this.otpService.verifyOtp(email, otp);
        if (isValid) {
            return ResponseEntity.ok((Object)"OTP verified successfully!");
        }
        return ResponseEntity.badRequest().body((Object)"Invalid OTP.");
    }

    @PostMapping(value={"/resend-otp"})
    public ResponseEntity<String> resendOtp(@RequestParam String email, String name) {
        try {
            this.otpService.resendOtp(email, name);
            return ResponseEntity.ok((Object)"OTP resent successfully.");
        }
        catch (IllegalStateException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)e.getMessage());
        }
        catch (MessagingException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Failed to resend OTP.");
        }
    }

    @GetMapping(value={"/validatemobilenumber"})
    public ResponseEntity<String> validateNumber(@RequestParam String countryCode, @RequestParam String mobileNumber) {
        boolean isValid = this.formService.validateMobileNumber(countryCode, mobileNumber);
        if (isValid) {
            return ResponseEntity.ok((Object)"Valid mobile number");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Invalid mobile number");
    }

    @GetMapping(value={"/mobile-number-info"})
    public ResponseEntity<String> getNumberInfo(@RequestParam String countryCode, @RequestParam String mobileNumber) {
        return ResponseEntity.ok((Object)this.formService.getNumberInfo(countryCode, mobileNumber));
    }

    @GetMapping(value={"/genericFormSearch"})
    public GenericResponse genericOrderSearch(@RequestParam(value="query") String query, Authentication authentication) {
        if (authentication == null || !authentication.isAuthenticated()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        GenericResponse response = new GenericResponse(true);
        Map<String, Object> formsPage = this.formService.genericFormSearch(query, isAdmin);
        GenericData data = new GenericData();
        data.setFormRequestDtos(formsPage);
        response.setData(data);
        return response;
    }
}

