/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.controller;

import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Tag(name="Fetch the Instagram Posts", description="")
@RestController
@RequestMapping(value={"/v1/instaIntegration"})
public class InstagramController {
    private static final Logger log = LoggerFactory.getLogger(InstagramController.class);
    @Value(value="${instagram.access-token}")
    private String accessToken;

    @GetMapping(value={"/posts"})
    public ResponseEntity<List<Map<String, Object>>> getInstagramPosts() {
        String postsUrl = "https://graph.instagram.com/me/media";
        RestTemplate restTemplate = new RestTemplate();
        URI uri = UriComponentsBuilder.fromUriString((String)postsUrl).queryParam("fields", new Object[]{"id,caption,media_url,thumbnail_url,permalink,media_type,children{media_url,thumbnail_url,permalink}"}).queryParam("access_token", new Object[]{this.accessToken}).build().toUri();
        ResponseEntity response = restTemplate.getForEntity(uri, Map.class);
        if (response.getStatusCode() == HttpStatus.OK) {
            List responseData = (List)((Map)response.getBody()).get("data");
            ArrayList<Map> newPosts = new ArrayList<Map>();
            int count = 0;
            block0: for (Map post : responseData) {
                if (count >= 12) break;
                if ("CAROUSEL_ALBUM".equals(post.get("media_type"))) {
                    Map childrenMap = (Map)post.get("children");
                    List children = (List)childrenMap.get("data");
                    for (Map child : children) {
                        HashMap newPost = new HashMap(child);
                        newPost.put("id", post.get("id"));
                        newPost.put("caption", post.get("caption"));
                        newPosts.add(newPost);
                        if (++count < 12) continue;
                        continue block0;
                    }
                    continue;
                }
                newPosts.add(post);
                ++count;
            }
            return ResponseEntity.ok(newPosts);
        }
        return ResponseEntity.status((HttpStatusCode)response.getStatusCode()).build();
    }

    private Map<String, Object> createNewPost(Map<String, Object> post, Map<String, Object> child) {
        HashMap<String, Object> newPost = new HashMap<String, Object>(post);
        newPost.put("media_url", child.get("media_url"));
        newPost.put("thumbnail_url", child.get("thumbnail_url"));
        newPost.put("permalink", child.get("permalink"));
        return newPost;
    }
}

