/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.controller;

import com.hepl.tunefortwo.config.i18n.Translator;
import com.hepl.tunefortwo.dto.AccessControlStatus;
import com.hepl.tunefortwo.dto.GenericData;
import com.hepl.tunefortwo.dto.GenericResponse;
import com.hepl.tunefortwo.dto.LanguageRequestDto;
import com.hepl.tunefortwo.service.LanguageService;
import com.hepl.tunefortwo.utils.JwtUtils;
import io.jsonwebtoken.Claims;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.mail.MessagingException;
import jakarta.validation.Valid;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@Tag(name="Create and Manage Language", description="")
@RestController
@RequestMapping(value={"/v1/language"})
public class LanguageController {
    private static final Logger log = LoggerFactory.getLogger(LanguageController.class);
    private final LanguageService languageService;
    private final Translator translator;
    private final JwtUtils jwtUtils;

    public LanguageController(LanguageService languageService, Translator translator, JwtUtils jwtUtils) {
        this.languageService = languageService;
        this.translator = translator;
        this.jwtUtils = jwtUtils;
    }

    @PostMapping(consumes={"multipart/form-data"})
    public GenericResponse addLanguage(@Valid @ModelAttribute LanguageRequestDto data, Authentication authentication) throws MessagingException, IOException {
        Object response;
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (!isAdmin) {
            response = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Unauthorized");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        log.info("Adding Languge");
        this.languageService.saveLanugae(data);
        response = new GenericResponse(true);
        ((GenericResponse)response).setMessage(this.translator.toLocale("language.languageSavedSuccessully"));
        return response;
    }

    @GetMapping
    public GenericResponse getAllLanguage(Authentication authentication) {
        Object response;
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (!isAdmin) {
            response = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Unauthorized");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        log.info("Get all Languages");
        response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setLanguages(this.languageService.getAllLanguage());
        ((GenericResponse)response).setData(data);
        return response;
    }

    @GetMapping(value={"/get-AllLanguage-Active"})
    public GenericResponse getAllLanguageByActive() {
        log.info("Get all languages");
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setLanguages(this.languageService.getAllLanguageByActive());
        response.setData(data);
        return response;
    }

    @GetMapping(value={"/{id}"})
    public GenericResponse getLanguageById(@PathVariable String id, Authentication authentication) {
        Object response;
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (!isAdmin) {
            response = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Unauthorized");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        log.info("Get language");
        response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setLanguage(this.languageService.getLanguageById(id));
        ((GenericResponse)response).setData(data);
        return response;
    }

    @Operation(summary="Change action control status")
    @PutMapping(value={"/action-control/{id}"})
    public GenericResponse updateActionControlStatus(@RequestParam AccessControlStatus status, @PathVariable String id, Authentication authentication) throws MessagingException {
        Object response;
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (!isAdmin) {
            response = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Unauthorized");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        log.info("Update language control status ... {}", (Object)id);
        this.languageService.updateActionControlStatus(status, id);
        response = new GenericResponse(true);
        ((GenericResponse)response).setMessage(this.translator.toLocale("language.languageStatusChanged"));
        return response;
    }

    @Operation(description="Update Language based on id")
    @PutMapping(value={"/{id}"})
    public GenericResponse updateLanguage(@PathVariable String id, @Valid @RequestBody LanguageRequestDto language, Authentication authentication) {
        Object response;
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (!isAdmin) {
            response = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Unauthorized");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        log.info("Update language ... {}", (Object)id);
        this.languageService.updateLanguage(language, id);
        response = new GenericResponse(true);
        ((GenericResponse)response).setMessage(this.translator.toLocale("language.languageUpdatedSuccessfully"));
        return response;
    }

    @DeleteMapping(value={"/{id}"})
    public GenericResponse deleteLanguage(@PathVariable String id, Authentication authentication) {
        Object response;
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (!isAdmin) {
            response = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Unauthorized");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        log.info("delete language.....{}", (Object)id);
        this.languageService.deleteLanguage(id);
        response = new GenericResponse(true);
        ((GenericResponse)response).setMessage(this.translator.toLocale("language.languageDeleted"));
        return response;
    }

    @DeleteMapping(value={"/"})
    public GenericResponse deleteAllLanguage(@RequestBody List<String> id, Authentication authentication) {
        Object response;
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (!isAdmin) {
            response = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Unauthorized");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        log.info("delete all language.....{}", id);
        this.languageService.deleteAllLanguage(id);
        response = new GenericResponse(true);
        ((GenericResponse)response).setMessage(this.translator.toLocale("language.languageAllDeleted"));
        return response;
    }

    @Operation(summary="Change all action control status")
    @PutMapping(value={"/action-controls"})
    public GenericResponse updateAllActionControlStatus(@RequestParam AccessControlStatus status, @RequestBody List<String> id, Authentication authentication) throws MessagingException {
        Object response;
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (!isAdmin) {
            response = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Unauthorized");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        log.info("Update instrument control status ... {}", id);
        this.languageService.updateAllActionControlStatus(status, id);
        response = new GenericResponse(true);
        ((GenericResponse)response).setMessage(this.translator.toLocale("language.languageAllStatusChanged"));
        return response;
    }
}

