/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.controller;

import com.hepl.tunefortwo.config.i18n.Translator;
import com.hepl.tunefortwo.dto.AccessControlStatus;
import com.hepl.tunefortwo.dto.GenericData;
import com.hepl.tunefortwo.dto.GenericResponse;
import com.hepl.tunefortwo.service.MoodService;
import com.itextpdf.io.exceptions.IOException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.mail.MessagingException;
import jakarta.validation.Valid;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Create and Manage Mood", description="")
@RestController
@RequestMapping(value={"/v1/mood"})
public class MoodController {
    private static final Logger log = LoggerFactory.getLogger(MoodController.class);
    private final Translator translator;
    private final MoodService moodService;

    public MoodController(Translator translator, MoodService moodService) {
        this.moodService = moodService;
        this.translator = translator;
    }

    @PostMapping
    public GenericResponse addMood(@RequestParam String name) throws MessagingException, IOException {
        log.info("Adding Mood");
        this.moodService.saveMood(name);
        GenericResponse response = new GenericResponse(true);
        response.setMessage(this.translator.toLocale("mood.moodSavedSuccessully"));
        return response;
    }

    @GetMapping(value={"/{id}"})
    public GenericResponse getMoodById(@PathVariable String id) {
        log.info("Get mood");
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setMood(this.moodService.getMoodById(id));
        response.setData(data);
        return response;
    }

    @GetMapping
    public GenericResponse getAllMood() {
        log.info("Get all moods");
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setMoods(this.moodService.getAllMoods());
        response.setData(data);
        return response;
    }

    @GetMapping(value={"/get-AllMood-Active"})
    public GenericResponse getAllMoodsByActive() {
        log.info("Get all Moods");
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setMoods(this.moodService.getAllMoodsByActive());
        response.setData(data);
        return response;
    }

    @Operation(description="Update Mood based on id")
    @PutMapping(value={"/{id}"})
    public GenericResponse updateMood(@PathVariable String id, @Valid @RequestParam String name) {
        log.info("Update mood ... {}", (Object)id);
        this.moodService.updateMood(name, id);
        GenericResponse response = new GenericResponse(true);
        response.setMessage(this.translator.toLocale("mood.moodUpdatedSuccessfully"));
        return response;
    }

    @Operation(summary="Change action control status")
    @PutMapping(value={"/action-control/{id}"})
    public GenericResponse updateActionControlStatus(@RequestParam AccessControlStatus status, @PathVariable String id) throws MessagingException {
        log.info("Update mood control status ... {}", (Object)id);
        this.moodService.updateActionControlStatus(status, id);
        GenericResponse response = new GenericResponse(true);
        response.setMessage(this.translator.toLocale("mood.moodStatusChanged"));
        return response;
    }

    @DeleteMapping(value={"/{id}"})
    public GenericResponse deleteMood(@PathVariable String id) {
        log.info("delete mood.....{}", (Object)id);
        this.moodService.deleteMood(id);
        GenericResponse response = new GenericResponse(true);
        response.setMessage(this.translator.toLocale("mood.moodDeleted"));
        return response;
    }

    @DeleteMapping(value={"/"})
    public GenericResponse deleteAllMood(@RequestBody List<String> id) {
        log.info("delete all mood.....{}", id);
        this.moodService.deleteAllMood(id);
        GenericResponse response = new GenericResponse(true);
        response.setMessage(this.translator.toLocale("mood.moodAllDeleted"));
        return response;
    }

    @Operation(summary="Change all action control status")
    @PutMapping(value={"/action-controls"})
    public GenericResponse updateAllActionControlStatus(@RequestParam AccessControlStatus status, @RequestBody List<String> id) throws MessagingException {
        log.info("Update instrument control status ... {}", id);
        this.moodService.updateAllActionControlStatus(status, id);
        GenericResponse response = new GenericResponse(true);
        response.setMessage(this.translator.toLocale("mood.moodAllStatusChanged"));
        return response;
    }
}

