/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.controller;

import com.hepl.tunefortwo.dto.GenericData;
import com.hepl.tunefortwo.dto.GenericResponse;
import com.hepl.tunefortwo.dto.OrderSummaryDto;
import com.hepl.tunefortwo.entity.OrderSummary;
import com.hepl.tunefortwo.service.OrderSummaryService;
import com.itextpdf.text.DocumentException;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.mail.MessagingException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Create and Manage orderSummary", description="")
@RestController
@RequestMapping(value={"/v1/orderSummary"})
public class OrderSummaryController {
    private static final Logger log = LoggerFactory.getLogger(OrderSummaryController.class);
    private final OrderSummaryService orderSummaryService;

    public OrderSummaryController(OrderSummaryService orderSummaryService) {
        this.orderSummaryService = orderSummaryService;
    }

    @PutMapping(value={"/orderSummary/{id}"})
    public GenericResponse addorderSummary(@RequestParam String id, @RequestParam(value="languageAmount", required=false) double languageAmout, @RequestParam(value="versionAmount", required=false) double versionAmount, @RequestParam(value="masterAmount", required=false) double masterAmount, @RequestParam(value="deliverydateAmount", required=false) double deliverydateAmount, @RequestParam(value="artistAmount", required=false) double artistAmount) throws IOException, DocumentException, MessagingException {
        double totalAmount = languageAmout + versionAmount + masterAmount + deliverydateAmount + artistAmount;
        this.orderSummaryService.updateorderSummary(id, languageAmout, versionAmount, masterAmount, deliverydateAmount, totalAmount, artistAmount);
        GenericResponse response = new GenericResponse(true);
        response.setMessage("order updated");
        return response;
    }

    @GetMapping(value={"/{id}"})
    public GenericResponse getorderSummary(@PathVariable String id) {
        GenericResponse response = new GenericResponse(true);
        OrderSummary ordersummary = this.orderSummaryService.getordersummarybyid(id);
        GenericData data = new GenericData();
        data.setOrderSummary(ordersummary);
        response.setData(data);
        return response;
    }

    @PostMapping(consumes={"multipart/form-data"})
    public GenericResponse saveOrderSummary(@ModelAttribute OrderSummaryDto orderSummary) throws MessagingException {
        OrderSummary newSummary = new OrderSummary();
        GenericResponse response = new GenericResponse(true);
        if (!(Double.isNaN(orderSummary.getLanguageAmount()) || Double.isNaN(orderSummary.getVersionAmount()) || Double.isNaN(orderSummary.getMasterAmount()) || Double.isNaN(orderSummary.getDeliverydateAmount()) || Double.isNaN(orderSummary.getArtistAmount()))) {
            double total = orderSummary.getLanguageAmount() + orderSummary.getVersionAmount() + orderSummary.getMasterAmount() + orderSummary.getDeliverydateAmount() + orderSummary.getArtistAmount();
            OrderSummary summary = this.orderSummaryService.saveOrderSummary(orderSummary, total);
            response.setMessage("order savedid : " + summary.getId());
            System.out.println("ArtistAmount" + total);
            GenericData data = new GenericData();
            data.setOrderSummary(summary);
            response.setData(data);
            return response;
        }
        response.setMessage("Enter valid data");
        return response;
    }
}

