/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hepl.tunefortwo.config.jackson.ForceStringDeserializer;
import com.hepl.tunefortwo.dto.MixtureMaster;
import com.hepl.tunefortwo.dto.OrderTrackerDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.FutureOrPresent;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.web.multipart.MultipartFile;

public class FormRequestDto {
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private String id;
    @NotBlank(message="{validation.user.usernameCannotBeEmpty}")
    @Size(max=60, message="{validation.user.usernameMustBeMaximumOf_60Characters}")
    @Pattern(regexp="^[a-zA-Z\\s]*$", message="{validation.user.usernameCannotContainSpecialCharacters}")
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    private @NotBlank(message="{validation.user.usernameCannotBeEmpty}") @Size(max=60, message="{validation.user.usernameMustBeMaximumOf_60Characters}") @Pattern(regexp="^[a-zA-Z\\s]*$", message="{validation.user.usernameCannotContainSpecialCharacters}") String name;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_WRITE)
    @Pattern(regexp="^[a-z0-9]{1,25}(?:[._+][a-z0-9]+)*@[a-z0-9.-]+\\.[a-z]{2,}$", message="{validation.user.emailIsInvalid}")
    private @Pattern(regexp="^[a-z0-9]{1,25}(?:[._+][a-z0-9]+)*@[a-z0-9.-]+\\.[a-z]{2,}$", message="{validation.user.emailIsInvalid}") String mail;
    @NotBlank(message="{validation.user.mobileCannotBeEmpty}")
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Encrypt data using AES/GCM")
    @JsonDeserialize(using=ForceStringDeserializer.class)
    private @NotBlank(message="{validation.user.mobileCannotBeEmpty}") String phonenumber;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED)
    private String instrument;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED)
    private String mood;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED)
    private String lanuage;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED)
    private String artist;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED)
    private String songto;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED)
    private String songfrom;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED)
    private String occasion;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED)
    @Size(min=0, max=750, message="{validation.user.userstoryMustBeMaximumOf_750Characters}")
    private @Size(min=0, max=750, message="{validation.user.userstoryMustBeMaximumOf_750Characters}") String story;
    @Schema(accessMode=Schema.AccessMode.WRITE_ONLY, description="Clip file MP3 format", required=false)
    @NotNull(message="Clip file must be provided")
    private @NotNull(message="Clip file must be provided") MultipartFile clip;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    private Double clipDuration;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private String clipPath;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private String orderNumber;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private String screenshot;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private LocalDateTime createdDate;
    @Schema(accessMode=Schema.AccessMode.WRITE_ONLY)
    private MixtureMaster masterRequest;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private String status;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    @FutureOrPresent(message="{validation.user.usercustomerDeliveryDateShouldBeInPresentorFuture}")
    private @FutureOrPresent(message="{validation.user.usercustomerDeliveryDateShouldBeInPresentorFuture}") LocalDate customerDeliveryDate;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    @FutureOrPresent(message="{validation.user.userDeliveryDateShouldBeInPresentorFuture}")
    private @FutureOrPresent(message="{validation.user.userDeliveryDateShouldBeInPresentorFuture}") LocalDate deliveryDate;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private List<OrderTrackerDto> orderPosition;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private String durationInMMSS;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    @Size(min=0, max=750, message="{validation.user.usercommentsMustBeMaximumOf_750Characters}")
    private @Size(min=0, max=750, message="{validation.user.usercommentsMustBeMaximumOf_750Characters}") String comments;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private String mixtureMaster;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private String rating;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    @Size(min=0, max=750, message="{validation.user.userreviewMustBeMaximumOf_750Characters}")
    private @Size(min=0, max=750, message="{validation.user.userreviewMustBeMaximumOf_750Characters}") String review;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private List<String> images;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private String adminClipPath;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private String videoPath;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    private Double orderTotal;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private String activeStatus;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private String paymentId;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private String paymentStatus;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private String paymentOrderId;

    public static FormRequestDtoBuilder builder() {
        return new FormRequestDtoBuilder();
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    @JsonDeserialize(using=ForceStringDeserializer.class)
    public void setPhonenumber(String phonenumber) {
        this.phonenumber = phonenumber;
    }

    public void setInstrument(String instrument) {
        this.instrument = instrument;
    }

    public void setMood(String mood) {
        this.mood = mood;
    }

    public void setLanuage(String lanuage) {
        this.lanuage = lanuage;
    }

    public void setArtist(String artist) {
        this.artist = artist;
    }

    public void setSongto(String songto) {
        this.songto = songto;
    }

    public void setSongfrom(String songfrom) {
        this.songfrom = songfrom;
    }

    public void setOccasion(String occasion) {
        this.occasion = occasion;
    }

    public void setStory(String story) {
        this.story = story;
    }

    public void setClip(MultipartFile clip) {
        this.clip = clip;
    }

    public void setClipDuration(Double clipDuration) {
        this.clipDuration = clipDuration;
    }

    public void setClipPath(String clipPath) {
        this.clipPath = clipPath;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public void setScreenshot(String screenshot) {
        this.screenshot = screenshot;
    }

    public void setCreatedDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public void setMasterRequest(MixtureMaster masterRequest) {
        this.masterRequest = masterRequest;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setCustomerDeliveryDate(LocalDate customerDeliveryDate) {
        this.customerDeliveryDate = customerDeliveryDate;
    }

    public void setDeliveryDate(LocalDate deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public void setOrderPosition(List<OrderTrackerDto> orderPosition) {
        this.orderPosition = orderPosition;
    }

    public void setDurationInMMSS(String durationInMMSS) {
        this.durationInMMSS = durationInMMSS;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public void setMixtureMaster(String mixtureMaster) {
        this.mixtureMaster = mixtureMaster;
    }

    public void setRating(String rating) {
        this.rating = rating;
    }

    public void setReview(String review) {
        this.review = review;
    }

    public void setImages(List<String> images) {
        this.images = images;
    }

    public void setAdminClipPath(String adminClipPath) {
        this.adminClipPath = adminClipPath;
    }

    public void setVideoPath(String videoPath) {
        this.videoPath = videoPath;
    }

    public void setOrderTotal(Double orderTotal) {
        this.orderTotal = orderTotal;
    }

    public void setActiveStatus(String activeStatus) {
        this.activeStatus = activeStatus;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public void setPaymentStatus(String paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    public void setPaymentOrderId(String paymentOrderId) {
        this.paymentOrderId = paymentOrderId;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getMail() {
        return this.mail;
    }

    public String getPhonenumber() {
        return this.phonenumber;
    }

    public String getInstrument() {
        return this.instrument;
    }

    public String getMood() {
        return this.mood;
    }

    public String getLanuage() {
        return this.lanuage;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getSongto() {
        return this.songto;
    }

    public String getSongfrom() {
        return this.songfrom;
    }

    public String getOccasion() {
        return this.occasion;
    }

    public String getStory() {
        return this.story;
    }

    public MultipartFile getClip() {
        return this.clip;
    }

    public Double getClipDuration() {
        return this.clipDuration;
    }

    public String getClipPath() {
        return this.clipPath;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public String getScreenshot() {
        return this.screenshot;
    }

    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    public MixtureMaster getMasterRequest() {
        return this.masterRequest;
    }

    public String getStatus() {
        return this.status;
    }

    public LocalDate getCustomerDeliveryDate() {
        return this.customerDeliveryDate;
    }

    public LocalDate getDeliveryDate() {
        return this.deliveryDate;
    }

    public List<OrderTrackerDto> getOrderPosition() {
        return this.orderPosition;
    }

    public String getDurationInMMSS() {
        return this.durationInMMSS;
    }

    public String getComments() {
        return this.comments;
    }

    public String getMixtureMaster() {
        return this.mixtureMaster;
    }

    public String getRating() {
        return this.rating;
    }

    public String getReview() {
        return this.review;
    }

    public List<String> getImages() {
        return this.images;
    }

    public String getAdminClipPath() {
        return this.adminClipPath;
    }

    public String getVideoPath() {
        return this.videoPath;
    }

    public Double getOrderTotal() {
        return this.orderTotal;
    }

    public String getActiveStatus() {
        return this.activeStatus;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public String getPaymentStatus() {
        return this.paymentStatus;
    }

    public String getPaymentOrderId() {
        return this.paymentOrderId;
    }

    public FormRequestDto(String id, String name, String mail, String phonenumber, String instrument, String mood, String lanuage, String artist, String songto, String songfrom, String occasion, String story, MultipartFile clip, Double clipDuration, String clipPath, String orderNumber, String screenshot, LocalDateTime createdDate, MixtureMaster masterRequest, String status, LocalDate customerDeliveryDate, LocalDate deliveryDate, List<OrderTrackerDto> orderPosition, String durationInMMSS, String comments, String mixtureMaster, String rating, String review, List<String> images, String adminClipPath, String videoPath, Double orderTotal, String activeStatus, String paymentId, String paymentStatus, String paymentOrderId) {
        this.id = id;
        this.name = name;
        this.mail = mail;
        this.phonenumber = phonenumber;
        this.instrument = instrument;
        this.mood = mood;
        this.lanuage = lanuage;
        this.artist = artist;
        this.songto = songto;
        this.songfrom = songfrom;
        this.occasion = occasion;
        this.story = story;
        this.clip = clip;
        this.clipDuration = clipDuration;
        this.clipPath = clipPath;
        this.orderNumber = orderNumber;
        this.screenshot = screenshot;
        this.createdDate = createdDate;
        this.masterRequest = masterRequest;
        this.status = status;
        this.customerDeliveryDate = customerDeliveryDate;
        this.deliveryDate = deliveryDate;
        this.orderPosition = orderPosition;
        this.durationInMMSS = durationInMMSS;
        this.comments = comments;
        this.mixtureMaster = mixtureMaster;
        this.rating = rating;
        this.review = review;
        this.images = images;
        this.adminClipPath = adminClipPath;
        this.videoPath = videoPath;
        this.orderTotal = orderTotal;
        this.activeStatus = activeStatus;
        this.paymentId = paymentId;
        this.paymentStatus = paymentStatus;
        this.paymentOrderId = paymentOrderId;
    }

    public FormRequestDto() {
    }

    public static class FormRequestDtoBuilder {
        private String id;
        private String name;
        private String mail;
        private String phonenumber;
        private String instrument;
        private String mood;
        private String lanuage;
        private String artist;
        private String songto;
        private String songfrom;
        private String occasion;
        private String story;
        private MultipartFile clip;
        private Double clipDuration;
        private String clipPath;
        private String orderNumber;
        private String screenshot;
        private LocalDateTime createdDate;
        private MixtureMaster masterRequest;
        private String status;
        private LocalDate customerDeliveryDate;
        private LocalDate deliveryDate;
        private List<OrderTrackerDto> orderPosition;
        private String durationInMMSS;
        private String comments;
        private String mixtureMaster;
        private String rating;
        private String review;
        private List<String> images;
        private String adminClipPath;
        private String videoPath;
        private Double orderTotal;
        private String activeStatus;
        private String paymentId;
        private String paymentStatus;
        private String paymentOrderId;

        FormRequestDtoBuilder() {
        }

        public FormRequestDtoBuilder id(String id) {
            this.id = id;
            return this;
        }

        public FormRequestDtoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FormRequestDtoBuilder mail(String mail) {
            this.mail = mail;
            return this;
        }

        @JsonDeserialize(using=ForceStringDeserializer.class)
        public FormRequestDtoBuilder phonenumber(String phonenumber) {
            this.phonenumber = phonenumber;
            return this;
        }

        public FormRequestDtoBuilder instrument(String instrument) {
            this.instrument = instrument;
            return this;
        }

        public FormRequestDtoBuilder mood(String mood) {
            this.mood = mood;
            return this;
        }

        public FormRequestDtoBuilder lanuage(String lanuage) {
            this.lanuage = lanuage;
            return this;
        }

        public FormRequestDtoBuilder artist(String artist) {
            this.artist = artist;
            return this;
        }

        public FormRequestDtoBuilder songto(String songto) {
            this.songto = songto;
            return this;
        }

        public FormRequestDtoBuilder songfrom(String songfrom) {
            this.songfrom = songfrom;
            return this;
        }

        public FormRequestDtoBuilder occasion(String occasion) {
            this.occasion = occasion;
            return this;
        }

        public FormRequestDtoBuilder story(String story) {
            this.story = story;
            return this;
        }

        public FormRequestDtoBuilder clip(MultipartFile clip) {
            this.clip = clip;
            return this;
        }

        public FormRequestDtoBuilder clipDuration(Double clipDuration) {
            this.clipDuration = clipDuration;
            return this;
        }

        public FormRequestDtoBuilder clipPath(String clipPath) {
            this.clipPath = clipPath;
            return this;
        }

        public FormRequestDtoBuilder orderNumber(String orderNumber) {
            this.orderNumber = orderNumber;
            return this;
        }

        public FormRequestDtoBuilder screenshot(String screenshot) {
            this.screenshot = screenshot;
            return this;
        }

        public FormRequestDtoBuilder createdDate(LocalDateTime createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public FormRequestDtoBuilder masterRequest(MixtureMaster masterRequest) {
            this.masterRequest = masterRequest;
            return this;
        }

        public FormRequestDtoBuilder status(String status) {
            this.status = status;
            return this;
        }

        public FormRequestDtoBuilder customerDeliveryDate(LocalDate customerDeliveryDate) {
            this.customerDeliveryDate = customerDeliveryDate;
            return this;
        }

        public FormRequestDtoBuilder deliveryDate(LocalDate deliveryDate) {
            this.deliveryDate = deliveryDate;
            return this;
        }

        public FormRequestDtoBuilder orderPosition(List<OrderTrackerDto> orderPosition) {
            this.orderPosition = orderPosition;
            return this;
        }

        public FormRequestDtoBuilder durationInMMSS(String durationInMMSS) {
            this.durationInMMSS = durationInMMSS;
            return this;
        }

        public FormRequestDtoBuilder comments(String comments) {
            this.comments = comments;
            return this;
        }

        public FormRequestDtoBuilder mixtureMaster(String mixtureMaster) {
            this.mixtureMaster = mixtureMaster;
            return this;
        }

        public FormRequestDtoBuilder rating(String rating) {
            this.rating = rating;
            return this;
        }

        public FormRequestDtoBuilder review(String review) {
            this.review = review;
            return this;
        }

        public FormRequestDtoBuilder images(List<String> images) {
            this.images = images;
            return this;
        }

        public FormRequestDtoBuilder adminClipPath(String adminClipPath) {
            this.adminClipPath = adminClipPath;
            return this;
        }

        public FormRequestDtoBuilder videoPath(String videoPath) {
            this.videoPath = videoPath;
            return this;
        }

        public FormRequestDtoBuilder orderTotal(Double orderTotal) {
            this.orderTotal = orderTotal;
            return this;
        }

        public FormRequestDtoBuilder activeStatus(String activeStatus) {
            this.activeStatus = activeStatus;
            return this;
        }

        public FormRequestDtoBuilder paymentId(String paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        public FormRequestDtoBuilder paymentStatus(String paymentStatus) {
            this.paymentStatus = paymentStatus;
            return this;
        }

        public FormRequestDtoBuilder paymentOrderId(String paymentOrderId) {
            this.paymentOrderId = paymentOrderId;
            return this;
        }

        public FormRequestDto build() {
            return new FormRequestDto(this.id, this.name, this.mail, this.phonenumber, this.instrument, this.mood, this.lanuage, this.artist, this.songto, this.songfrom, this.occasion, this.story, this.clip, this.clipDuration, this.clipPath, this.orderNumber, this.screenshot, this.createdDate, this.masterRequest, this.status, this.customerDeliveryDate, this.deliveryDate, this.orderPosition, this.durationInMMSS, this.comments, this.mixtureMaster, this.rating, this.review, this.images, this.adminClipPath, this.videoPath, this.orderTotal, this.activeStatus, this.paymentId, this.paymentStatus, this.paymentOrderId);
        }

        public String toString() {
            return "FormRequestDto.FormRequestDtoBuilder(id=" + this.id + ", name=" + this.name + ", mail=" + this.mail + ", phonenumber=" + this.phonenumber + ", instrument=" + this.instrument + ", mood=" + this.mood + ", lanuage=" + this.lanuage + ", artist=" + this.artist + ", songto=" + this.songto + ", songfrom=" + this.songfrom + ", occasion=" + this.occasion + ", story=" + this.story + ", clip=" + this.clip + ", clipDuration=" + this.clipDuration + ", clipPath=" + this.clipPath + ", orderNumber=" + this.orderNumber + ", screenshot=" + this.screenshot + ", createdDate=" + this.createdDate + ", masterRequest=" + this.masterRequest + ", status=" + this.status + ", customerDeliveryDate=" + this.customerDeliveryDate + ", deliveryDate=" + this.deliveryDate + ", orderPosition=" + this.orderPosition + ", durationInMMSS=" + this.durationInMMSS + ", comments=" + this.comments + ", mixtureMaster=" + this.mixtureMaster + ", rating=" + this.rating + ", review=" + this.review + ", images=" + this.images + ", adminClipPath=" + this.adminClipPath + ", videoPath=" + this.videoPath + ", orderTotal=" + this.orderTotal + ", activeStatus=" + this.activeStatus + ", paymentId=" + this.paymentId + ", paymentStatus=" + this.paymentStatus + ", paymentOrderId=" + this.paymentOrderId + ")";
        }
    }
}

