/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.repository;

import com.hepl.tunefortwo.entity.Form;
import com.mongodb.client.result.UpdateResult;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.mongodb.repository.Aggregation;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.data.mongodb.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface FormRepository
extends MongoRepository<Form, String> {
    public static final String COLLECTION_NAME = "Form";

    public Form findTopByOrderByCreatedDateDesc();

    public Optional<Form> findFirstByOrderByCreatedDateDesc();

    @Query(value="{'orderPosition': ?0}")
    public List<Form> findByOrderPosition(String var1);

    @Query(value="{ $text: { $search: :#{#query} } }")
    public List<Form> findAllByTextSearch(@Param(value="query") String var1, Sort var2);

    @Aggregation(value={"{ $addFields: { lastOrderPosition: { $arrayElemAt: [ '$orderPosition', -1 ] } } }", "{ $match: { 'lastOrderPosition.orderPosition': ?0 } }"})
    public List<Form> findFormsByLastOrderPosition(String var1, Sort var2);

    @Aggregation(pipeline={"{$match: { 'phonenumber': ?0, 'orderNumber': ?1 }}", "{$project: { 'orderPosition': 1, '_id': 0 }}"})
    public List<Object> findOrderPositionByPhonenumberAndOrderNumber(String var1, String var2);

    public Optional<Form> findByPhonenumber(String var1);

    public Optional<Form> findByOrderNumber(String var1);

    public Optional<Form> findById(int var1);

    default public UpdateResult updateReview(int id, String review, int rating, String image, String video, MongoTemplate mongoTemplate) {
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query().addCriteria((CriteriaDefinition)Criteria.where((String)"_orderNumber").is((Object)id));
        Update update = new Update();
        update.set("review", (Object)review);
        update.set("rating", (Object)rating);
        update.set("image", (Object)image);
        update.set("video", (Object)video);
        return mongoTemplate.updateFirst(query, (UpdateDefinition)update, COLLECTION_NAME);
    }

    public Optional<Form> findByPhonenumberAndOrderNumber(String var1, String var2);

    public List<Form> findByActiveStatus(String var1);

    public List<Form> findByCreatedDateBetween(LocalDate var1, LocalDate var2);
}

