/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.service.impl;

import com.hepl.tunefortwo.entity.DeliveryDate;
import com.hepl.tunefortwo.repository.DeliveryDateRepository;
import com.hepl.tunefortwo.service.DeliveryDateService;
import jakarta.mail.MessagingException;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

@Service
public class DeliveryDateServiceImp
implements DeliveryDateService {
    private static final Logger log = LoggerFactory.getLogger(DeliveryDateServiceImp.class);
    private final DeliveryDateRepository deliveryDateRepository;

    public DeliveryDateServiceImp(DeliveryDateRepository deliveryDateRepository) {
        this.deliveryDateRepository = deliveryDateRepository;
    }

    @Override
    public DeliveryDate addCollection() {
        List findAllDeliveryDates = this.deliveryDateRepository.findAll();
        if (findAllDeliveryDates.isEmpty()) {
            DeliveryDate newDeliveryDate = new DeliveryDate();
            newDeliveryDate.setCreatedAt(LocalDate.now());
            newDeliveryDate.setUpdatedAt(LocalDate.now());
            newDeliveryDate.setEstimatedDays("10");
            newDeliveryDate.setPriceForTotalDays(1000.0);
            newDeliveryDate.setPricePerDay(100.0);
            return (DeliveryDate)this.deliveryDateRepository.save(newDeliveryDate);
        }
        throw new DataIntegrityViolationException("Delivery date collection already has data");
    }

    @Override
    public void updateDeliveryDate(String estimatedDays, Double priceForTotalDays, Double pricePerDay) throws MessagingException {
        List findAllDeliveryDates = this.deliveryDateRepository.findAll();
        if (!findAllDeliveryDates.isEmpty()) {
            DeliveryDate deliveryDateFound = (DeliveryDate)findAllDeliveryDates.get(0);
            deliveryDateFound.setUpdatedAt(LocalDate.now());
            if (estimatedDays != null && !estimatedDays.isEmpty()) {
                deliveryDateFound.setEstimatedDays(estimatedDays);
            }
            if (priceForTotalDays != null && !Double.isNaN(priceForTotalDays)) {
                deliveryDateFound.setPriceForTotalDays(priceForTotalDays);
            }
            if (pricePerDay != null && !Double.isNaN(pricePerDay)) {
                deliveryDateFound.setPricePerDay(pricePerDay);
            }
            this.deliveryDateRepository.save(deliveryDateFound);
        }
    }

    @Override
    public DeliveryDate getDeliveryDateData() {
        List findAllDeliveryDates = this.deliveryDateRepository.findAll();
        if (!findAllDeliveryDates.isEmpty()) {
            DeliveryDate deliveryDateFound = (DeliveryDate)findAllDeliveryDates.get(0);
            return deliveryDateFound;
        }
        throw new DataIntegrityViolationException("Delivery date collection has no data");
    }
}

