/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.service.impl;

import com.hepl.tunefortwo.dto.FiledDto;
import com.hepl.tunefortwo.dto.IsMandatory;
import com.hepl.tunefortwo.entity.Filed;
import com.hepl.tunefortwo.repository.FiledRepository;
import com.hepl.tunefortwo.service.FiledService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class FiledServiceImpl
implements FiledService {
    private static final Logger log = LoggerFactory.getLogger(FiledServiceImpl.class);
    private final FiledRepository filedRepository;

    public FiledServiceImpl(FiledRepository filedRepository) {
        this.filedRepository = filedRepository;
    }

    @Override
    public void addFiled(FiledDto dto) {
        log.info("add filed");
        Filed filed = new Filed();
        filed.setIsMandatory(dto.getIsMandatory().toString());
        filed.setName(dto.getName());
        this.filedRepository.save(filed);
    }

    @Override
    public void updateFiled(IsMandatory dto, String id) {
        log.info("update filed");
        Filed filed = (Filed)this.filedRepository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "error.resourceNotFound"));
        filed.setIsMandatory(dto.toString());
        this.filedRepository.save(filed);
    }

    @Override
    public List<Filed> getAllFiled() {
        log.info("get All filed");
        return this.filedRepository.findAll();
    }

    @Override
    public Filed getFiledById(String id) {
        log.info("get filed by id :" + id);
        return (Filed)this.filedRepository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "error.resourceNotFound"));
    }
}

