/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.service.impl;

import com.hepl.tunefortwo.dto.AccessControlStatus;
import com.hepl.tunefortwo.dto.LanguageRequestDto;
import com.hepl.tunefortwo.entity.Language;
import com.hepl.tunefortwo.repository.LanguageRepository;
import com.hepl.tunefortwo.service.LanguageService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class LanguageServiceImplement
implements LanguageService {
    private static final Logger log = LoggerFactory.getLogger(LanguageServiceImplement.class);
    private final MongoTemplate mongoTemplate;
    private final LanguageRepository languageRepository;

    public LanguageServiceImplement(LanguageRepository languageRepository, MongoTemplate mongoTemplate) {
        this.languageRepository = languageRepository;
        this.mongoTemplate = mongoTemplate;
    }

    @Override
    public Language saveLanugae(LanguageRequestDto data) {
        log.info("save Language");
        Language existingLanguage = this.languageRepository.findByName(data.getName());
        if (existingLanguage != null) {
            throw new IllegalArgumentException("language.languageAlreadyExistedname :" + data.getName());
        }
        Language language = new Language();
        language.setName(data.getName());
        language.setPrice(data.getPrice());
        return (Language)this.languageRepository.save(language);
    }

    @Override
    public List<Language> getAllLanguage() {
        log.info("Get all Language");
        return this.languageRepository.findAll();
    }

    @Override
    public List<Language> getAllLanguageByActive() {
        log.info("Get all Language");
        return this.languageRepository.findActiveLanguage();
    }

    @Override
    public Language getLanguageById(String id) {
        log.info("");
        Language language = (Language)this.languageRepository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "error.resourceNotFound"));
        return language;
    }

    @Override
    public void updateActionControlStatus(AccessControlStatus status, String id) {
        log.info("Change action status .. {}", (Object)id);
        this.languageRepository.updateAccessControlStatus(id, status.toString(), this.mongoTemplate);
    }

    @Override
    public void updateLanguage(LanguageRequestDto requestDto, String id) {
        Language languageWithSameName;
        log.info("Updating instrument with ID: {}", (Object)id);
        Language existingLanguage = (Language)this.languageRepository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "language.languageNotFoundwith ID: " + id));
        if (!existingLanguage.getName().equals(requestDto.getName()) && (languageWithSameName = this.languageRepository.findByName(requestDto.getName())) != null && !languageWithSameName.getId().equals(id)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "language.languageAlreadyExistedname :" + requestDto.getName());
        }
        existingLanguage.setName(requestDto.getName());
        existingLanguage.setPrice(requestDto.getPrice());
        this.languageRepository.save(existingLanguage);
    }

    @Override
    public void deleteLanguage(String id) {
        log.info("Delete Language");
        this.languageRepository.deleteById(id);
    }

    @Override
    public void deleteAllLanguage(List<String> ids) {
        log.info("Delete all language");
        for (String id : ids) {
            this.languageRepository.deleteById(id);
        }
    }

    @Override
    public void updateAllActionControlStatus(AccessControlStatus status, List<String> ids) {
        log.info("Change action status .. {} " + ids);
        for (String id : ids) {
            this.languageRepository.updateAccessControlStatus(id, status.toString(), this.mongoTemplate);
        }
    }
}

