/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hepl.tunefortwo.entity.Form;
import com.hepl.tunefortwo.entity.MasterPayment;
import com.hepl.tunefortwo.entity.PaymentTransaction;
import com.hepl.tunefortwo.repository.FormRepository;
import com.hepl.tunefortwo.repository.MasterPaymentRepository;
import com.hepl.tunefortwo.service.MailService;
import com.hepl.tunefortwo.service.MasterPaymentService;
import com.hepl.tunefortwo.service.TemplateService;
import com.hepl.tunefortwo.utils.PaymentUtils;
import com.razorpay.Order;
import com.razorpay.Payment;
import com.razorpay.RazorpayClient;
import com.razorpay.RazorpayException;
import jakarta.mail.MessagingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bson.types.Decimal128;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Service;

@Service
public class MasterPaymentServiceImpl
implements MasterPaymentService {
    private static final Logger logger = LoggerFactory.getLogger(MasterPaymentService.class);
    private final MasterPaymentRepository masterPaymentRepository;
    private final FormRepository formRepository;
    private final MailService mailService;
    private final TemplateService templateService;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Value(value="${razorPayCredentials.keyId}")
    private String keyId;
    @Value(value="${adminMail.payment}")
    private String paymentMailId;
    private String keyToEncrpytKeyId = "";
    @Value(value="${razorPayCredentials.keySecret}")
    private String keySecret;
    private static final String BASE_URL = "https://api.razorpay.com/v1/orders/{order_id}/payments";

    public MasterPaymentServiceImpl(MasterPaymentRepository masterPaymentRepository, FormRepository formRepository, MailService mailService, TemplateService templateService) {
        this.masterPaymentRepository = masterPaymentRepository;
        this.formRepository = formRepository;
        this.mailService = mailService;
        this.templateService = templateService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<String, String> createOrder(double amount, String formId) throws RazorpayException, MessagingException {
        String savedStatus = "unsaved";
        RazorpayClient razorpayClient = new RazorpayClient(this.keyId, this.keySecret);
        JSONObject orderRequest = new JSONObject();
        long amountInPaisa = (long)(amount * 100.0);
        orderRequest.put("amount", amountInPaisa);
        orderRequest.put("currency", (Object)"INR");
        orderRequest.put("receipt", (Object)"order_receipt_11");
        Order order = razorpayClient.Orders.create(orderRequest);
        logger.debug("Order Data from Razorpay: {}", (Object)order);
        System.out.println("OrderData" + order);
        String orderId = (String)order.get("id");
        int dueOrderAmount = (Integer)order.get("amount_due");
        int paidOrderAmount = (Integer)order.get("amount_paid");
        String currency = (String)order.get("currency");
        int attempts = (Integer)order.get("attempts");
        HashMap<String, String> paymentIdMap = new HashMap<String, String>();
        paymentIdMap.put("OrderId", orderId);
        List<MasterPayment> ordersFound = this.masterPaymentRepository.findByOrderId(orderId);
        if (ordersFound.size() > 0) throw new MessagingException("Order with orderId: " + orderId + " already Exists");
        Optional optionalFormDataForOrder = this.formRepository.findById(formId);
        if (optionalFormDataForOrder.isEmpty()) throw new MessagingException("Form with ID: " + formId + " does not exist.");
        Form formDataForOrder = (Form)optionalFormDataForOrder.get();
        String userName = formDataForOrder.getName();
        String email = formDataForOrder.getMail();
        MasterPayment newOrder = new MasterPayment();
        newOrder.setOrderId(orderId);
        newOrder.setFormId(formId);
        newOrder.setFormOrderNumber(formDataForOrder.getOrderNumber());
        newOrder.setContactMail(formDataForOrder.getMail());
        newOrder.setContactNumber(formDataForOrder.getPhonenumber());
        BigDecimal paisaAmountDue = this.getNumberAsBigDecimal(order.get("amount_due"));
        BigDecimal paisaAmountPaid = this.getNumberAsBigDecimal(order.get("amount_paid"));
        BigDecimal amountDueInRupees = paisaAmountDue.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
        BigDecimal amountPaidInRupees = paisaAmountPaid.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
        BigDecimal amountChargedInRupees = BigDecimal.valueOf(amountInPaisa).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
        newOrder.setAmountPaid(amountPaidInRupees);
        newOrder.setAmountDue(amountDueInRupees);
        newOrder.setAmountCharged(amountChargedInRupees);
        newOrder.setCurrency(currency);
        newOrder.setOrderAttempts(attempts);
        newOrder.setUserName(userName);
        newOrder.setCreatedAt(LocalDateTime.now());
        newOrder.setOrderStatus(this.getStringValue(order.get("status")));
        newOrder.setOrderReceipt(this.getStringValue(order.get("receipt")));
        formDataForOrder.setPaymentOrderId(orderId);
        formDataForOrder.setPaymentStatus(this.getStringValue(order.get("status")));
        this.formRepository.save(formDataForOrder);
        MasterPayment createdPaymentOrder = (MasterPayment)this.masterPaymentRepository.save(newOrder);
        if (createdPaymentOrder != null) {
            savedStatus = "saved";
        }
        paymentIdMap.put("savedStatus", savedStatus);
        return paymentIdMap;
    }

    @Override
    public boolean verifyPayment(String paymentId, String orderId, String signature) {
        return PaymentUtils.verifyPaymentSignature(paymentId, orderId, signature, this.keySecret);
    }

    @Override
    public String setPaymentsForAnOrderId(String paymentId, String paymentsignature) throws RazorpayException, JsonMappingException, JsonProcessingException, MessagingException {
        RazorpayClient razorpay = new RazorpayClient(this.keyId, this.keySecret);
        Payment payment = razorpay.Payments.fetch(paymentId);
        System.out.println("payment Data: " + payment);
        String id = (String)payment.get("id");
        String orderId = (String)payment.get("order_id");
        logger.debug("HandlerMethod Called - paymentId: {}, orderId: {}", (Object)paymentId, (Object)orderId);
        String paymentMethod = (String)payment.get("method");
        String paymentStatus = (String)payment.get("status");
        Optional<MasterPayment> existingPayment = this.masterPaymentRepository.findByPaymentId(paymentId);
        if (existingPayment.isPresent()) {
            return "Payment with this ID has already been processed.";
        }
        List<MasterPayment> paymentsForOrdersFound = this.masterPaymentRepository.findByOrderId(orderId);
        if (paymentsForOrdersFound.size() > 0) {
            MasterPayment upiData;
            MasterPayment cardData;
            MasterPayment netBankingData;
            MasterPayment paymentsForOrderFound = paymentsForOrdersFound.get(0);
            Order orderDataToBeUpdated = razorpay.Orders.fetch(orderId);
            System.out.println("orderDataToBeUpdated : " + orderDataToBeUpdated);
            BigDecimal paisaAmount = this.getNumberAsBigDecimal(orderDataToBeUpdated.get("amount"));
            BigDecimal paisaAmountPaid = this.getNumberAsBigDecimal(orderDataToBeUpdated.get("amount_paid"));
            BigDecimal paisaAmountDue = this.getNumberAsBigDecimal(orderDataToBeUpdated.get("amount_due"));
            paymentsForOrderFound.setAmountCharged(paisaAmount.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
            paymentsForOrderFound.setAmountPaid(paisaAmountPaid.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
            paymentsForOrderFound.setAmountDue(paisaAmountDue.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
            List<LocalDateTime> updatedAtList = paymentsForOrderFound.getUpdatedAtList();
            if (updatedAtList == null) {
                updatedAtList = new ArrayList<LocalDateTime>();
                paymentsForOrderFound.setUpdatedAtList(updatedAtList);
            }
            updatedAtList.add(LocalDateTime.now());
            paymentsForOrderFound.setOrderAttempts((Integer)orderDataToBeUpdated.get("attempts"));
            paymentsForOrderFound.setOrderStatus((String)orderDataToBeUpdated.get("status"));
            this.masterPaymentRepository.save(paymentsForOrderFound);
            logger.debug("Payment MailId {}:", (Object)this.paymentMailId);
            String formIdFound = paymentsForOrderFound.getFormId();
            Optional optionalFormDataForOrder = this.formRepository.findById(formIdFound);
            Form formDataForOrderForMail = (Form)optionalFormDataForOrder.get();
            this.mailService.sendMailByTemplate(this.templateService.getPaymentMessageTemplate((String)payment.get("status"), (String)payment.get("method"), paisaAmountPaid.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP), formDataForOrderForMail.getName(), formDataForOrderForMail.getOrderNumber(), (Integer)orderDataToBeUpdated.get("attempts"), LocalDate.now(), paisaAmount.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP), paymentId, formDataForOrderForMail.getMail(), formDataForOrderForMail.getPhonenumber()), this.paymentMailId, "Payment Details Mail");
            if (paymentStatus.equals("captured") && !optionalFormDataForOrder.isEmpty()) {
                Form formDataForOrder = (Form)optionalFormDataForOrder.get();
                if (orderDataToBeUpdated.get("status").equals("paid")) {
                    formDataForOrder.setPaymentStatus(this.getStringValue(orderDataToBeUpdated.get("status")));
                }
                formDataForOrder.setPaymentId(paymentId);
                this.formRepository.save(formDataForOrder);
            }
            if (paymentMethod.equals("netbanking") && (netBankingData = this.paymentWithNetBanking(payment, orderId, paymentsForOrderFound, paymentsignature)) != null) {
                return "NetBanking payment Data updated Successfully";
            }
            if (paymentMethod.equals("card") && (cardData = this.paymentWithCard(payment, orderId, paymentsForOrderFound, paymentsignature)) != null) {
                return "Card payment Data updated Successfully";
            }
            if (paymentMethod.equals("upi") && (upiData = this.paymentWithUPI(payment, orderId, paymentsForOrderFound, paymentsignature)) != null) {
                return "UPI payment Data updated Successfully";
            }
            if (paymentMethod.equals("wallet") && (upiData = this.paymentWithWallet(payment, orderId, paymentsForOrderFound, paymentsignature)) != null) {
                return "UPI payment Data updated Successfully";
            }
        }
        return "No orders Found";
    }

    @Override
    public MasterPayment paymentWithNetBanking(Payment payment, String orderId, MasterPayment paymentsForOrderFound, String signature) throws JsonMappingException, JsonProcessingException {
        Object notesObj;
        String value;
        String key;
        Map.Entry field;
        Iterator fieldsIterator;
        MasterPayment newData = new MasterPayment();
        List<PaymentTransaction> paymentTransactions = paymentsForOrderFound.getPayments();
        if (paymentTransactions == null) {
            paymentTransactions = new ArrayList<PaymentTransaction>();
        }
        PaymentTransaction paymentTransaction = new PaymentTransaction();
        paymentTransaction.setType("netbanking");
        paymentTransaction.setPaymentId((String)payment.get("id"));
        if (signature == null) {
            paymentTransaction.setPaymentSignature("no signature found");
        } else {
            paymentTransaction.setPaymentSignature(signature);
        }
        Object createdAtObject = payment.get("created_at");
        LocalDateTime createdAt = null;
        if (createdAtObject instanceof Date) {
            Date createdAtDate = (Date)createdAtObject;
            Instant instant = createdAtDate.toInstant();
            createdAt = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        } else if (createdAtObject instanceof Number) {
            long currentTimeMillis = ((Number)createdAtObject).longValue();
            Instant instant = Instant.ofEpochMilli(currentTimeMillis);
            createdAt = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        paymentTransaction.setCreatedDate(createdAt);
        paymentTransaction.setBank(this.getStringValue(payment.get("bank")));
        Object acquirerDataObject = payment.get("acquirer_data");
        if (acquirerDataObject != null) {
            JsonNode jsonNode;
            ObjectMapper mapper = new ObjectMapper();
            if (acquirerDataObject instanceof JSONObject) {
                String acquirerDataString = acquirerDataObject.toString();
                jsonNode = mapper.readTree(acquirerDataString);
            } else {
                jsonNode = (JsonNode)mapper.convertValue(acquirerDataObject, JsonNode.class);
            }
            String authCode = jsonNode.has("bank_transaction_id") ? jsonNode.get("bank_transaction_id").asText() : null;
            paymentTransaction.setBankTransactionId(authCode);
            StringBuilder formattedAcquirerData = new StringBuilder();
            fieldsIterator = jsonNode.fields();
            while (fieldsIterator.hasNext()) {
                field = (Map.Entry)fieldsIterator.next();
                key = (String)field.getKey();
                value = ((JsonNode)field.getValue()).asText();
                if (value == null || value.trim().isEmpty()) continue;
                if (formattedAcquirerData.length() > 0) {
                    formattedAcquirerData.append(" | ");
                }
                formattedAcquirerData.append(key).append(": ").append(value);
            }
            paymentTransaction.setAcquirerData(formattedAcquirerData.toString());
        }
        if ((notesObj = payment.get("notes")) != null) {
            JsonNode jsonNodeForNotes;
            ObjectMapper mapperForNotes = new ObjectMapper();
            if (notesObj instanceof JSONObject) {
                String notesString = notesObj.toString();
                jsonNodeForNotes = mapperForNotes.readTree(notesString);
            } else {
                jsonNodeForNotes = (JsonNode)mapperForNotes.convertValue(notesObj, JsonNode.class);
            }
            StringBuilder formattedNotes = new StringBuilder();
            fieldsIterator = jsonNodeForNotes.fields();
            while (fieldsIterator.hasNext()) {
                field = (Map.Entry)fieldsIterator.next();
                key = (String)field.getKey();
                value = ((JsonNode)field.getValue()).asText();
                if (value == null || value.trim().isEmpty()) continue;
                if (formattedNotes.length() > 0) {
                    formattedNotes.append(" | ");
                }
                formattedNotes.append(key).append(": ").append(value);
            }
            paymentTransaction.setNotes(formattedNotes.toString());
        }
        paymentTransaction.setErrorCode(this.getStringValue(payment.get("error_code")));
        paymentTransaction.setErrorDescription(this.getStringValue(payment.get("error_description")));
        paymentTransaction.setErrorSource(this.getStringValue(payment.get("error_source")));
        paymentTransaction.setErrorReason(this.getStringValue(payment.get("error_reason")));
        paymentTransaction.setErrorStep(this.getStringValue(payment.get("error_step")));
        BigDecimal paisaTax = this.getNumberAsBigDecimal(payment.get("tax"));
        BigDecimal paisaFee = this.getNumberAsBigDecimal(payment.get("fee"));
        paymentTransaction.setTax(paisaTax.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
        paymentTransaction.setFee(paisaFee.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
        paymentTransaction.setInvoiceId(this.getStringValue(payment.get("invoice_id")));
        paymentTransaction.setStatus(this.getStringValue(payment.get("status")));
        paymentTransaction.setAmountRefunded(this.getNumberAsBigDecimal(payment.get("amount_refunded")));
        BigDecimal paisaAmount = this.getNumberAsBigDecimal(payment.get("amount"));
        BigDecimal amountInRupees = paisaAmount.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
        paymentTransaction.setAmountPaid(amountInRupees);
        paymentTransaction.setIsCaptured(this.getBooleanValue(payment.get("captured")));
        paymentTransaction.setContactEmail(this.getStringValue(payment.get("email")));
        paymentTransaction.setContactNo(this.getStringValue(payment.get("contact")));
        paymentTransaction.setRefundStatus(this.getStringValue(payment.get("refund_status")));
        paymentTransactions.add(paymentTransaction);
        paymentsForOrderFound.setPayments(paymentTransactions);
        this.masterPaymentRepository.save(paymentsForOrderFound);
        newData = paymentsForOrderFound;
        return newData;
    }

    @Override
    public MasterPayment paymentWithUPI(Payment payment, String orderId, MasterPayment paymentsForOrderFound, String signature) throws JsonMappingException, JsonProcessingException {
        Object upiObject;
        Object notesObj;
        MasterPayment newData = new MasterPayment();
        List<PaymentTransaction> paymentTransactions = paymentsForOrderFound.getPayments();
        if (paymentTransactions == null) {
            paymentTransactions = new ArrayList<PaymentTransaction>();
        }
        PaymentTransaction paymentTransaction = new PaymentTransaction();
        paymentTransaction.setType("upi");
        paymentTransaction.setPaymentId((String)payment.get("id"));
        if (signature == null) {
            paymentTransaction.setPaymentSignature("no signature found");
        } else {
            paymentTransaction.setPaymentSignature(signature);
        }
        Object createdAtObject = payment.get("created_at");
        LocalDateTime createdAt = null;
        if (createdAtObject instanceof Date) {
            Date createdAtDate = (Date)createdAtObject;
            Instant instant = createdAtDate.toInstant();
            createdAt = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        } else if (createdAtObject instanceof Number) {
            long currentTimeMillis = ((Number)createdAtObject).longValue();
            Instant instant = Instant.ofEpochMilli(currentTimeMillis);
            createdAt = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        paymentTransaction.setCreatedDate(createdAt);
        paymentTransaction.setBank(this.getStringValue(payment.get("bank")));
        Object acquirerDataObject = payment.get("acquirer_data");
        if (acquirerDataObject != null) {
            JsonNode jsonNode;
            ObjectMapper mapper = new ObjectMapper();
            if (acquirerDataObject instanceof JSONObject) {
                String acquirerDataString = acquirerDataObject.toString();
                jsonNode = mapper.readTree(acquirerDataString);
            } else {
                jsonNode = (JsonNode)mapper.convertValue(acquirerDataObject, JsonNode.class);
            }
            String upiTransactionId = jsonNode.has("upi_transaction_id") ? jsonNode.get("upi_transaction_id").asText() : null;
            String rrnId = jsonNode.has("rrn") ? jsonNode.get("rrn").asText() : null;
            paymentTransaction.setUpiTransactionId(upiTransactionId);
            paymentTransaction.setRetrievalReferenceNumber(rrnId);
            StringBuilder formattedAcquirerData = new StringBuilder();
            Iterator fieldsIterator = jsonNode.fields();
            while (fieldsIterator.hasNext()) {
                Map.Entry field = (Map.Entry)fieldsIterator.next();
                String key = (String)field.getKey();
                String value = ((JsonNode)field.getValue()).asText();
                if (value == null || value.trim().isEmpty()) continue;
                if (formattedAcquirerData.length() > 0) {
                    formattedAcquirerData.append(" | ");
                }
                formattedAcquirerData.append(key).append(": ").append(value);
            }
            paymentTransaction.setAcquirerData(formattedAcquirerData.toString());
        }
        if ((notesObj = payment.get("notes")) != null) {
            JsonNode jsonNodeForNotes;
            ObjectMapper mapperForNotes = new ObjectMapper();
            if (notesObj instanceof JSONObject) {
                String notesString = notesObj.toString();
                jsonNodeForNotes = mapperForNotes.readTree(notesString);
            } else {
                jsonNodeForNotes = (JsonNode)mapperForNotes.convertValue(notesObj, JsonNode.class);
            }
            StringBuilder formattedNotes = new StringBuilder();
            Iterator fieldsIterator = jsonNodeForNotes.fields();
            while (fieldsIterator.hasNext()) {
                Map.Entry field = (Map.Entry)fieldsIterator.next();
                String key = (String)field.getKey();
                String value = ((JsonNode)field.getValue()).asText();
                if (value == null || value.trim().isEmpty()) continue;
                if (formattedNotes.length() > 0) {
                    formattedNotes.append(" | ");
                }
                formattedNotes.append(key).append(": ").append(value);
            }
            paymentTransaction.setNotes(formattedNotes.toString());
        }
        if ((upiObject = payment.get("upi")) != null) {
            String vpa;
            JsonNode upiNode;
            ObjectMapper mapper = new ObjectMapper();
            if (upiObject instanceof JSONObject) {
                String upiString = upiObject.toString();
                upiNode = mapper.readTree(upiString);
            } else {
                upiNode = (JsonNode)mapper.convertValue(upiObject, JsonNode.class);
            }
            String string = vpa = upiNode.get("vpa") != null ? upiNode.get("vpa").asText() : null;
            if (vpa != null) {
                paymentTransaction.setUpiVpa(vpa);
            }
        }
        paymentTransaction.setErrorCode(this.getStringValue(payment.get("error_code")));
        paymentTransaction.setErrorDescription(this.getStringValue(payment.get("error_description")));
        paymentTransaction.setErrorSource(this.getStringValue(payment.get("error_source")));
        paymentTransaction.setErrorReason(this.getStringValue(payment.get("error_reason")));
        paymentTransaction.setErrorStep(this.getStringValue(payment.get("error_step")));
        BigDecimal paisaTax = this.getNumberAsBigDecimal(payment.get("tax"));
        BigDecimal paisaFee = this.getNumberAsBigDecimal(payment.get("fee"));
        paymentTransaction.setTax(paisaTax.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
        paymentTransaction.setFee(paisaFee.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
        paymentTransaction.setInvoiceId(this.getStringValue(payment.get("invoice_id")));
        paymentTransaction.setStatus(this.getStringValue(payment.get("status")));
        paymentTransaction.setAmountRefunded(this.getNumberAsBigDecimal(payment.get("amount_refunded")));
        BigDecimal paisaAmount = this.getNumberAsBigDecimal(payment.get("amount"));
        BigDecimal amountInRupees = paisaAmount.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
        paymentTransaction.setAmountPaid(amountInRupees);
        paymentTransaction.setIsCaptured(this.getBooleanValue(payment.get("captured")));
        paymentTransaction.setContactEmail(this.getStringValue(payment.get("email")));
        paymentTransaction.setContactNo(this.getStringValue(payment.get("contact")));
        paymentTransaction.setRefundStatus(this.getStringValue(payment.get("refund_status")));
        paymentTransactions.add(paymentTransaction);
        paymentsForOrderFound.setPayments(paymentTransactions);
        this.masterPaymentRepository.save(paymentsForOrderFound);
        newData = paymentsForOrderFound;
        return newData;
    }

    @Override
    public MasterPayment paymentWithCard(Payment payment, String orderId, MasterPayment paymentsForOrderFound, String signature) throws JsonMappingException, JsonProcessingException {
        Object notesObj;
        Object cardDataObject;
        MasterPayment newDataForCardPayment = new MasterPayment();
        List<PaymentTransaction> paymentTransactions = paymentsForOrderFound.getPayments();
        if (paymentTransactions == null) {
            paymentTransactions = new ArrayList<PaymentTransaction>();
        }
        PaymentTransaction paymentTransaction = new PaymentTransaction();
        paymentTransaction.setType("card");
        paymentTransaction.setPaymentId((String)payment.get("id"));
        if (signature == null) {
            paymentTransaction.setPaymentSignature("no signature found");
        } else {
            paymentTransaction.setPaymentSignature(signature);
        }
        Object createdAtObject = payment.get("created_at");
        LocalDateTime createdAt = null;
        if (createdAtObject instanceof Number) {
            long createdAtSeconds = ((Number)createdAtObject).longValue();
            Instant instant = Instant.ofEpochSecond(createdAtSeconds);
            createdAt = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        } else if (createdAtObject instanceof Date) {
            Date createdAtDate = (Date)createdAtObject;
            Instant instant = createdAtDate.toInstant();
            createdAt = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        paymentTransaction.setCreatedDate(createdAt);
        paymentTransaction.setBank(this.getStringValue(payment.get("bank")));
        Object acquirerDataObject = payment.get("acquirer_data");
        if (acquirerDataObject != null) {
            JsonNode jsonNode;
            ObjectMapper mapper = new ObjectMapper();
            if (acquirerDataObject instanceof JSONObject) {
                String acquirerDataString = acquirerDataObject.toString();
                jsonNode = mapper.readTree(acquirerDataString);
            } else {
                jsonNode = (JsonNode)mapper.convertValue(acquirerDataObject, JsonNode.class);
            }
            String authCode = jsonNode.has("auth_code") ? jsonNode.get("auth_code").asText() : null;
            paymentTransaction.setAuthCode(authCode);
            StringBuilder formattedAcquirerData = new StringBuilder();
            Iterator fieldsIterator = jsonNode.fields();
            while (fieldsIterator.hasNext()) {
                Map.Entry field = (Map.Entry)fieldsIterator.next();
                String key = (String)field.getKey();
                String value = ((JsonNode)field.getValue()).asText();
                if (value == null || value.trim().isEmpty()) continue;
                if (formattedAcquirerData.length() > 0) {
                    formattedAcquirerData.append(" | ");
                }
                formattedAcquirerData.append(key).append(": ").append(value);
            }
            paymentTransaction.setAcquirerData(formattedAcquirerData.toString());
        }
        if ((cardDataObject = payment.get("card")) != null) {
            JsonNode jsonNode;
            ObjectMapper mapper = new ObjectMapper();
            if (cardDataObject instanceof JSONObject) {
                String cardDataString = cardDataObject.toString();
                jsonNode = mapper.readTree(cardDataString);
            } else {
                jsonNode = (JsonNode)mapper.convertValue(cardDataObject, JsonNode.class);
            }
            boolean emi = jsonNode.has("emi") ? jsonNode.get("emi").asBoolean() : false;
            boolean international = jsonNode.has("international") ? jsonNode.get("international").asBoolean() : false;
            paymentTransaction.setEmiCard(emi);
            paymentTransaction.setInternationalCard(international);
            String last4 = jsonNode.has("last4") ? jsonNode.get("last4").asText() : null;
            paymentTransaction.setLastFourDigitsOfCard(last4);
            String subType = jsonNode.has("sub_type") ? jsonNode.get("sub_type").asText() : null;
            paymentTransaction.setCardSubType(subType);
            String nameOnCard = jsonNode.has("name") ? jsonNode.get("name").asText() : null;
            paymentTransaction.setCardName(nameOnCard);
            String cardId = jsonNode.has("id") ? jsonNode.get("id").asText() : null;
            paymentTransaction.setCardId(cardId);
            String tokenIin = jsonNode.has("token_iin") ? jsonNode.get("token_iin").asText() : null;
            paymentTransaction.setCartTokenIIn(tokenIin);
            String cardType = jsonNode.has("type") ? jsonNode.get("type").asText() : null;
            paymentTransaction.setCardType(cardType);
            String cardEntity = jsonNode.has("entity") ? jsonNode.get("entity").asText() : null;
            paymentTransaction.setCardEntity(cardEntity);
            String cardIssuer = jsonNode.has("issuer") ? jsonNode.get("issuer").asText() : null;
            paymentTransaction.setCardIssuer(cardIssuer);
            String cardNetwork = jsonNode.has("network") ? jsonNode.get("network").asText() : null;
            paymentTransaction.setCardNetwork(cardNetwork);
            StringBuilder formattedCardData = new StringBuilder();
            Iterator fieldsIterator = jsonNode.fields();
            while (fieldsIterator.hasNext()) {
                Map.Entry field = (Map.Entry)fieldsIterator.next();
                String key = (String)field.getKey();
                String value = ((JsonNode)field.getValue()).asText();
                if (value == null || value.trim().isEmpty()) continue;
                if (formattedCardData.length() > 0) {
                    formattedCardData.append(" | ");
                }
                formattedCardData.append(key).append(": ").append(value);
            }
            paymentTransaction.setCardData(formattedCardData.toString());
        }
        if ((notesObj = payment.get("notes")) != null) {
            JsonNode jsonNodeForNotes;
            ObjectMapper mapperForNotes = new ObjectMapper();
            if (notesObj instanceof JSONObject) {
                String notesString = notesObj.toString();
                jsonNodeForNotes = mapperForNotes.readTree(notesString);
            } else {
                jsonNodeForNotes = (JsonNode)mapperForNotes.convertValue(notesObj, JsonNode.class);
            }
            StringBuilder formattedNotes = new StringBuilder();
            Iterator fieldsIterator = jsonNodeForNotes.fields();
            while (fieldsIterator.hasNext()) {
                Map.Entry field = (Map.Entry)fieldsIterator.next();
                String key = (String)field.getKey();
                String value = ((JsonNode)field.getValue()).asText();
                if (value == null || value.trim().isEmpty()) continue;
                if (formattedNotes.length() > 0) {
                    formattedNotes.append(" | ");
                }
                formattedNotes.append(key).append(": ").append(value);
            }
            paymentTransaction.setNotes(formattedNotes.toString());
        }
        paymentTransaction.setErrorCode(this.getStringValue(payment.get("error_code")));
        paymentTransaction.setErrorDescription(this.getStringValue(payment.get("error_description")));
        paymentTransaction.setErrorSource(this.getStringValue(payment.get("error_source")));
        paymentTransaction.setErrorReason(this.getStringValue(payment.get("error_reason")));
        paymentTransaction.setErrorStep(this.getStringValue(payment.get("error_step")));
        BigDecimal paisaTax = this.getNumberAsBigDecimal(payment.get("tax"));
        BigDecimal paisaFee = this.getNumberAsBigDecimal(payment.get("fee"));
        paymentTransaction.setTax(paisaTax.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
        paymentTransaction.setFee(paisaFee.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
        BigDecimal paisaAmount = this.getNumberAsBigDecimal(payment.get("amount"));
        BigDecimal amountInRupees = paisaAmount.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
        paymentTransaction.setAmountPaid(amountInRupees);
        paymentTransaction.setInvoiceId(this.getStringValue(payment.get("invoice_id")));
        paymentTransaction.setStatus(this.getStringValue(payment.get("status")));
        paymentTransaction.setAmountRefunded(this.getNumberAsBigDecimal(payment.get("amount_refunded")));
        paymentTransaction.setIsCaptured(this.getBooleanValue(payment.get("captured")));
        paymentTransaction.setContactEmail(this.getStringValue(payment.get("email")));
        paymentTransaction.setContactNo(this.getStringValue(payment.get("contact")));
        paymentTransaction.setRefundStatus(this.getStringValue(payment.get("refund_status")));
        paymentTransactions.add(paymentTransaction);
        paymentsForOrderFound.setPayments(paymentTransactions);
        this.masterPaymentRepository.save(paymentsForOrderFound);
        newDataForCardPayment = paymentsForOrderFound;
        return newDataForCardPayment;
    }

    @Override
    public MasterPayment paymentWithWallet(Payment payment, String orderId, MasterPayment paymentsForOrderFound, String signature) throws JsonMappingException, JsonProcessingException {
        Object notesObj;
        Object cardDataObject;
        MasterPayment newDataForWalletPayment = new MasterPayment();
        List<PaymentTransaction> paymentTransactions = paymentsForOrderFound.getPayments();
        if (paymentTransactions == null) {
            paymentTransactions = new ArrayList<PaymentTransaction>();
        }
        PaymentTransaction paymentTransaction = new PaymentTransaction();
        paymentTransaction.setType("wallet");
        paymentTransaction.setPaymentId((String)payment.get("id"));
        if (signature == null) {
            paymentTransaction.setPaymentSignature("no signature found");
        } else {
            paymentTransaction.setPaymentSignature(signature);
        }
        Object createdAtObject = payment.get("created_at");
        LocalDateTime createdAt = null;
        if (createdAtObject instanceof Number) {
            long createdAtSeconds = ((Number)createdAtObject).longValue();
            Instant instant = Instant.ofEpochSecond(createdAtSeconds);
            createdAt = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        } else if (createdAtObject instanceof Date) {
            Date createdAtDate = (Date)createdAtObject;
            Instant instant = createdAtDate.toInstant();
            createdAt = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        paymentTransaction.setCreatedDate(createdAt);
        paymentTransaction.setBank(this.getStringValue(payment.get("bank")));
        Object acquirerDataObject = payment.get("acquirer_data");
        if (acquirerDataObject != null) {
            JsonNode jsonNode;
            ObjectMapper mapper = new ObjectMapper();
            if (acquirerDataObject instanceof JSONObject) {
                String acquirerDataString = acquirerDataObject.toString();
                jsonNode = mapper.readTree(acquirerDataString);
            } else {
                jsonNode = (JsonNode)mapper.convertValue(acquirerDataObject, JsonNode.class);
            }
            String authCode = jsonNode.has("auth_code") ? jsonNode.get("auth_code").asText() : null;
            paymentTransaction.setAuthCode(authCode);
            StringBuilder formattedAcquirerData = new StringBuilder();
            Iterator fieldsIterator = jsonNode.fields();
            while (fieldsIterator.hasNext()) {
                Map.Entry field = (Map.Entry)fieldsIterator.next();
                String key = (String)field.getKey();
                String value = ((JsonNode)field.getValue()).asText();
                if (value == null || value.trim().isEmpty()) continue;
                if (formattedAcquirerData.length() > 0) {
                    formattedAcquirerData.append(" | ");
                }
                formattedAcquirerData.append(key).append(": ").append(value);
            }
            paymentTransaction.setAcquirerData(formattedAcquirerData.toString());
        }
        if ((cardDataObject = payment.get("wallet")) != null) {
            JsonNode jsonNode;
            ObjectMapper mapper = new ObjectMapper();
            if (cardDataObject instanceof JSONObject) {
                String cardDataString = cardDataObject.toString();
                jsonNode = mapper.readTree(cardDataString);
            } else {
                jsonNode = (JsonNode)mapper.convertValue(cardDataObject, JsonNode.class);
            }
            boolean emi = jsonNode.has("emi") ? jsonNode.get("emi").asBoolean() : false;
            boolean international = jsonNode.has("international") ? jsonNode.get("international").asBoolean() : false;
            paymentTransaction.setEmiCard(emi);
            paymentTransaction.setInternationalCard(international);
            String last4 = jsonNode.has("last4") ? jsonNode.get("last4").asText() : null;
            paymentTransaction.setLastFourDigitsOfCard(last4);
            String subType = jsonNode.has("sub_type") ? jsonNode.get("sub_type").asText() : null;
            paymentTransaction.setCardSubType(subType);
            String nameOnCard = jsonNode.has("name") ? jsonNode.get("name").asText() : null;
            paymentTransaction.setCardName(nameOnCard);
            String cardId = jsonNode.has("id") ? jsonNode.get("id").asText() : null;
            paymentTransaction.setCardId(cardId);
            String tokenIin = jsonNode.has("token_iin") ? jsonNode.get("token_iin").asText() : null;
            paymentTransaction.setCartTokenIIn(tokenIin);
            String cardType = jsonNode.has("type") ? jsonNode.get("type").asText() : null;
            paymentTransaction.setCardType(cardType);
            String cardEntity = jsonNode.has("entity") ? jsonNode.get("entity").asText() : null;
            paymentTransaction.setCardEntity(cardEntity);
            String cardIssuer = jsonNode.has("issuer") ? jsonNode.get("issuer").asText() : null;
            paymentTransaction.setCardIssuer(cardIssuer);
            String cardNetwork = jsonNode.has("network") ? jsonNode.get("network").asText() : null;
            paymentTransaction.setCardNetwork(cardNetwork);
            StringBuilder formattedCardData = new StringBuilder();
            Iterator fieldsIterator = jsonNode.fields();
            while (fieldsIterator.hasNext()) {
                Map.Entry field = (Map.Entry)fieldsIterator.next();
                String key = (String)field.getKey();
                String value = ((JsonNode)field.getValue()).asText();
                if (value == null || value.trim().isEmpty()) continue;
                if (formattedCardData.length() > 0) {
                    formattedCardData.append(" | ");
                }
                formattedCardData.append(key).append(": ").append(value);
            }
            paymentTransaction.setCardData(formattedCardData.toString());
        }
        if ((notesObj = payment.get("notes")) != null) {
            JsonNode jsonNodeForNotes;
            ObjectMapper mapperForNotes = new ObjectMapper();
            if (notesObj instanceof JSONObject) {
                String notesString = notesObj.toString();
                jsonNodeForNotes = mapperForNotes.readTree(notesString);
            } else {
                jsonNodeForNotes = (JsonNode)mapperForNotes.convertValue(notesObj, JsonNode.class);
            }
            StringBuilder formattedNotes = new StringBuilder();
            Iterator fieldsIterator = jsonNodeForNotes.fields();
            while (fieldsIterator.hasNext()) {
                Map.Entry field = (Map.Entry)fieldsIterator.next();
                String key = (String)field.getKey();
                String value = ((JsonNode)field.getValue()).asText();
                if (value == null || value.trim().isEmpty()) continue;
                if (formattedNotes.length() > 0) {
                    formattedNotes.append(" | ");
                }
                formattedNotes.append(key).append(": ").append(value);
            }
            paymentTransaction.setNotes(formattedNotes.toString());
        }
        paymentTransaction.setErrorCode(this.getStringValue(payment.get("error_code")));
        paymentTransaction.setErrorDescription(this.getStringValue(payment.get("error_description")));
        paymentTransaction.setErrorSource(this.getStringValue(payment.get("error_source")));
        paymentTransaction.setErrorReason(this.getStringValue(payment.get("error_reason")));
        paymentTransaction.setErrorStep(this.getStringValue(payment.get("error_step")));
        BigDecimal paisaTax = this.getNumberAsBigDecimal(payment.get("tax"));
        BigDecimal paisaFee = this.getNumberAsBigDecimal(payment.get("fee"));
        paymentTransaction.setTax(paisaTax.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
        paymentTransaction.setFee(paisaFee.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
        BigDecimal paisaAmount = this.getNumberAsBigDecimal(payment.get("amount"));
        BigDecimal amountInRupees = paisaAmount.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
        paymentTransaction.setAmountPaid(amountInRupees);
        paymentTransaction.setInvoiceId(this.getStringValue(payment.get("invoice_id")));
        paymentTransaction.setStatus(this.getStringValue(payment.get("status")));
        paymentTransaction.setAmountRefunded(this.getNumberAsBigDecimal(payment.get("amount_refunded")));
        paymentTransaction.setIsCaptured(this.getBooleanValue(payment.get("captured")));
        paymentTransaction.setContactEmail(this.getStringValue(payment.get("email")));
        paymentTransaction.setContactNo(this.getStringValue(payment.get("contact")));
        paymentTransaction.setRefundStatus(this.getStringValue(payment.get("refund_status")));
        paymentTransactions.add(paymentTransaction);
        paymentsForOrderFound.setPayments(paymentTransactions);
        this.masterPaymentRepository.save(paymentsForOrderFound);
        newDataForWalletPayment = paymentsForOrderFound;
        return newDataForWalletPayment;
    }

    @Override
    public void updateCommonFields(MasterPayment paymentData, Payment payment) {
    }

    private BigDecimal getNumberAsBigDecimal(Object value) {
        if (value instanceof Decimal128) {
            return ((Decimal128)value).bigDecimalValue();
        }
        if (value instanceof Number) {
            return new BigDecimal(((Number)value).toString());
        }
        return BigDecimal.ZERO;
    }

    private boolean isJSONObjectNull(Object obj) {
        return obj == null || obj.getClass().getName().equals("org.json.JSONObject$Null");
    }

    private String getStringValue(Object value) {
        if (this.isJSONObjectNull(value)) {
            return null;
        }
        return value.toString();
    }

    private Boolean getBooleanValue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.FALSE;
    }

    @Override
    public List<PaymentTransaction> getPaymentsForOrderId(String orderId) {
        List<Object> allPaymentsForAnOrder = new ArrayList();
        List<MasterPayment> paymentsForOrdersFound = this.masterPaymentRepository.findByOrderId(orderId);
        if (paymentsForOrdersFound.isEmpty()) {
            throw new IllegalArgumentException("No payments found for order ID: " + orderId);
        }
        MasterPayment order = paymentsForOrdersFound.get(0);
        allPaymentsForAnOrder = order.getPayments();
        if (allPaymentsForAnOrder == null || allPaymentsForAnOrder.isEmpty()) {
            throw new IllegalArgumentException("No payment transactions found for order ID: " + orderId);
        }
        logger.debug("paymentsForOrder results: {}", allPaymentsForAnOrder);
        return allPaymentsForAnOrder;
    }

    @Override
    public List<MasterPayment> getPaymentsByUserName(String userName) {
        return this.masterPaymentRepository.findByUserNamePartialMatch(userName);
    }

    @Override
    public List<MasterPayment> getPaymentsByFormId(String formId) {
        return this.masterPaymentRepository.findByFormIdPartialMatch(formId);
    }

    @Override
    public List<MasterPayment> getPaymentsWithStatusCapturedOrFailed() {
        return this.masterPaymentRepository.findByPaymentStatusCapturedOrFailed();
    }

    @Override
    public Map<String, Object> getPaymentsWithBYStatus(String status) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)Criteria.where((String)"orderStatus").is((Object)status)), Aggregation.project((String[])new String[]{"orderId", "formId", "userName", "amountCharged", "amountDue", "amountPaid", "currency", "orderAttempts", "createdAt", "formOrderNumber", "orderStatus", "orderReceipt", "payments", "updatedAtList"}), Aggregation.group((String[])new String[]{"_id"}).first("orderId").as("orderId").first("formId").as("formId").first("userName").as("userName").first("amountCharged").as("amountCharged").first("amountDue").as("amountDue").first("amountPaid").as("amountPaid").first("currency").as("currency").first("orderAttempts").as("orderAttempts").first("createdAt").as("createdAt").first("formOrderNumber").as("formOrderNumber").first("orderStatus").as("orderStatus").first("orderReceipt").as("orderReceipt").first("payments").as("payments").first("updatedAtList").as("updatedAtList").count().as("countOfMatchingPayments")});
        AggregationResults results = this.mongoTemplate.aggregate(aggregation, "masterpayment", MasterPayment.class);
        List orderResultsForStatus = results.getMappedResults();
        int orderResultsForStatusCount = orderResultsForStatus.size();
        HashMap<String, Object> pagedOrdersWithCount = new HashMap<String, Object>();
        pagedOrdersWithCount.put("OrdersCount", orderResultsForStatusCount);
        pagedOrdersWithCount.put("OrderData", orderResultsForStatus);
        return pagedOrdersWithCount;
    }

    @Override
    public Map<String, Object> getAllOrders(Pageable pageable, String status, String searchQuery) {
        if (searchQuery != null && !searchQuery.isEmpty()) {
            String regexSearchTerm = ".*" + searchQuery + ".*";
            Criteria criteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"payments.paymentId").regex(regexSearchTerm, "i"), Criteria.where((String)"userName").regex(regexSearchTerm, "i"), Criteria.where((String)"orderId").regex(regexSearchTerm, "i"), Criteria.where((String)"payments.contactEmail").regex(regexSearchTerm, "i")});
            Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.unwind((String)"payments", (String)"preserveNullAndEmptyArrays"), Aggregation.sort((Sort)Sort.by((Sort.Direction)Sort.Direction.fromString((String)((Sort.Order)pageable.getSort().iterator().next()).getDirection().name()), (String[])new String[]{((Sort.Order)pageable.getSort().iterator().next()).getProperty()})), Aggregation.group((String[])new String[]{"_id"}).first("orderId").as("orderId").first("formId").as("formId").first("userName").as("userName").first("amountCharged").as("amountCharged").first("amountDue").as("amountDue").first("amountPaid").as("amountPaid").first("paymentMethod").as("paymentMethod").first("currency").as("currency").first("orderStatus").as("orderStatus").first("contactMail").as("contactMail").first("contactNumber").as("contactNumber").first("orderAttempts").as("orderAttempts").first("createdAt").as("createdAt").first("status").as("status").first("formOrderNumber").as("formOrderNumber").first("totalAmountPaid").as("totalAmountPaid").first("tokenId").as("tokenId").first("updatedAtList").as("updatedAtList").push("payments").as("payments"), Aggregation.project((String[])new String[0]).and("orderId").as("orderId").and("formId").as("formId").and("userName").as("userName").and("amountCharged").as("amountCharged").and("amountDue").as("amountDue").and("amountPaid").as("amountPaid").and("paymentMethod").as("paymentMethod").and("orderStatus").as("orderStatus").and("contactMail").as("contactMail").and("contactNumber").as("contactNumber").and("currency").as("currency").and("orderAttempts").as("orderAttempts").and("createdAt").as("createdAt").and("status").as("status").and("formOrderNumber").as("formOrderNumber").and("totalAmountPaid").as("totalAmountPaid").and("tokenId").as("tokenId").and("payments").as("payments").and("updatedAtList").as("updatedAtList")});
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, "masterpayment", MasterPayment.class);
            List masterPayments = results.getMappedResults();
            logger.debug("Full Aggregation Results: {}", (Object)masterPayments);
            if (masterPayments.isEmpty()) {
                logger.debug("No results found for the query: {}", (Object)searchQuery);
            }
            long orderCount = masterPayments.size();
            logger.debug("Orders count Found for pagination: {}", (Object)orderCount);
            int start = (int)pageable.getOffset();
            int end = Math.min(start + pageable.getPageSize(), masterPayments.size());
            List pagedOrders = masterPayments.subList(start, end);
            HashMap<String, Object> pagedOrdersWithCount = new HashMap<String, Object>();
            pagedOrdersWithCount.put("OrdersCount", orderCount);
            pagedOrdersWithCount.put("OrderData", pagedOrders);
            return pagedOrdersWithCount;
        }
        if (status.equals("all")) {
            Page pagedOrders = this.masterPaymentRepository.findAll(pageable);
            long orderCount = pagedOrders.getTotalElements();
            logger.debug("Orders count Found for pagination: {}", (Object)orderCount);
            HashMap<String, Object> pagedOrdersWithCount = new HashMap<String, Object>();
            pagedOrdersWithCount.put("OrdersCount", orderCount);
            pagedOrdersWithCount.put("OrderData", pagedOrders.getContent());
            return pagedOrdersWithCount;
        }
        if (status != null && !status.isEmpty() && status != "all") {
            Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)Criteria.where((String)"orderStatus").is((Object)status)), Aggregation.project((String[])new String[]{"orderId", "formId", "userName", "amountCharged", "amountDue", "amountPaid", "currency", "orderAttempts", "createdAt", "formOrderNumber", "contactMail", "contactNumber", "orderStatus", "orderReceipt", "payments", "updatedAtList"}), Aggregation.group((String[])new String[]{"_id"}).first("orderId").as("orderId").first("formId").as("formId").first("userName").as("userName").first("amountCharged").as("amountCharged").first("amountDue").as("amountDue").first("amountPaid").as("amountPaid").first("currency").as("currency").first("orderAttempts").as("orderAttempts").first("createdAt").as("createdAt").first("formOrderNumber").as("formOrderNumber").first("orderStatus").as("orderStatus").first("orderReceipt").as("orderReceipt").first("payments").as("payments").first("updatedAtList").as("updatedAtList").first("orderStatus").as("orderStatus").first("contactMail").as("contactMail").first("contactNumber").as("contactNumber").first("orderAttempts").as("orderAttempts").first("createdAt").as("createdAt").count().as("countOfMatchingPayments"), Aggregation.sort((Sort)Sort.by((Sort.Direction)Sort.Direction.fromString((String)((Sort.Order)pageable.getSort().iterator().next()).getDirection().name()), (String[])new String[]{((Sort.Order)pageable.getSort().iterator().next()).getProperty()}))});
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, "masterpayment", MasterPayment.class);
            List orderResultsForStatus = results.getMappedResults();
            int orderResultsForStatusCount = orderResultsForStatus.size();
            int start = (int)pageable.getOffset();
            int end = Math.min(start + pageable.getPageSize(), orderResultsForStatus.size());
            List pagedOrders = orderResultsForStatus.subList(start, end);
            HashMap<String, Object> pagedOrdersWithCount = new HashMap<String, Object>();
            pagedOrdersWithCount.put("OrdersCount", orderResultsForStatusCount);
            pagedOrdersWithCount.put("OrderData", pagedOrders);
            return pagedOrdersWithCount;
        }
        Page pagedOrders = this.masterPaymentRepository.findAll(pageable);
        long orderCount = pagedOrders.getTotalElements();
        logger.debug("Orders count Found for pagination: {}", (Object)orderCount);
        HashMap<String, Object> pagedOrdersWithCount = new HashMap<String, Object>();
        pagedOrdersWithCount.put("OrdersCount", orderCount);
        pagedOrdersWithCount.put("OrderData", pagedOrders.getContent());
        return pagedOrdersWithCount;
    }

    @Override
    public PaymentTransaction findPaymentById(String paymentId) {
        Optional<MasterPayment> masterPayment = this.masterPaymentRepository.findByPaymentId(paymentId);
        if (masterPayment.isPresent()) {
            return masterPayment.get().getPayments().stream().filter(payment -> paymentId.equals(payment.getPaymentId())).findFirst().orElse(null);
        }
        return null;
    }

    @Override
    public List<PaymentTransaction> searchPaymentsByPaymentId(String query) {
        String regexSearchTerm = ".*" + query + ".*";
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.unwind((String)"payments"), Aggregation.match((Criteria)Criteria.where((String)"payments.paymentId").regex(regexSearchTerm, "i")), Aggregation.project((String[])new String[]{"payments"}).and("payments.paymentId").as("paymentId").and("payments.status").as("status").and("payments.type").as("type").and("payments.invoiceId").as("invoiceId").and("payments.amountRefunded").as("amountRefunded").and("payments.amountPaid").as("amountPaid").and("payments.refundStatus").as("refundStatus").and("payments.isCaptured").as("isCaptured").and("payments.contactEmail").as("contactEmail").and("payments.contactNo").as("contactNo").and("payments.fee").as("fee").and("payments.tax").as("tax").and("payments.bankTransactionId").as("bankTransactionId").and("payments.createdDate").as("createdDate").and("payments.notes").as("notes").and("payments.paymentSignature").as("paymentSignature").and("payments.bank").as("bank").and("payments.vpa").as("vpa").and("payments.cardId").as("cardId").and("payments.customerId").as("customerId").and("payments.tokenId").as("tokenId").and("payments.acquirerData").as("acquirerData").and("payments.upiVpa").as("upiVpa").and("payments.errorCode").as("errorCode").and("payments.errorDescription").as("errorDescription").and("payments.errorSource").as("errorSource").and("payments.errorStep").as("errorStep").and("payments.errorReason").as("errorReason")});
        AggregationResults results = this.mongoTemplate.aggregate(aggregation, "masterpayment", PaymentTransaction.class);
        List paymentTransactions = results.getMappedResults();
        logger.debug("Aggregation results: {}", (Object)paymentTransactions);
        return paymentTransactions;
    }

    @Override
    public List<PaymentTransaction> genericSearchPayments(String query) {
        String regexSearchTerm = ".*" + query + ".*";
        Criteria criteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"payments.paymentId").regex(regexSearchTerm, "i"), Criteria.where((String)"userName").regex(regexSearchTerm, "i"), Criteria.where((String)"orderId").regex(regexSearchTerm, "i"), Criteria.where((String)"payments.contactEmail").regex(regexSearchTerm, "i")});
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.unwind((String)"payments"), Aggregation.match((Criteria)criteria), Aggregation.project((String[])new String[]{"payments"}).and("payments.paymentId").as("paymentId").and("payments.status").as("status").and("payments.type").as("type").and("payments.invoiceId").as("invoiceId").and("payments.amountRefunded").as("amountRefunded").and("payments.amountPaid").as("amountPaid").and("payments.refundStatus").as("refundStatus").and("payments.isCaptured").as("isCaptured").and("payments.contactEmail").as("contactEmail").and("payments.contactNo").as("contactNo").and("payments.fee").as("fee").and("payments.tax").as("tax").and("payments.bankTransactionId").as("bankTransactionId").and("payments.createdDate").as("createdDate").and("payments.notes").as("notes").and("payments.paymentSignature").as("paymentSignature").and("payments.bank").as("bank").and("payments.vpa").as("vpa").and("payments.cardId").as("cardId").and("payments.customerId").as("customerId").and("payments.tokenId").as("tokenId").and("payments.acquirerData").as("acquirerData").and("payments.upiVpa").as("upiVpa").and("payments.errorCode").as("errorCode").and("payments.errorDescription").as("errorDescription").and("payments.errorSource").as("errorSource").and("payments.errorStep").as("errorStep").and("payments.errorReason").as("errorReason")});
        AggregationResults results = this.mongoTemplate.aggregate(aggregation, "masterpayment", PaymentTransaction.class);
        List paymentTransactions = results.getMappedResults();
        logger.debug("Aggregation results: {}", (Object)paymentTransactions);
        return paymentTransactions;
    }

    @Override
    public Map<String, Object> genericOrderSearch(String query) {
        String regexSearchTerm = ".*" + query + ".*";
        Criteria criteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"payments.paymentId").regex(regexSearchTerm, "i"), Criteria.where((String)"userName").regex(regexSearchTerm, "i"), Criteria.where((String)"orderId").regex(regexSearchTerm, "i"), Criteria.where((String)"payments.contactEmail").regex(regexSearchTerm, "i")});
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.unwind((String)"payments", (String)"preserveNullAndEmptyArrays"), Aggregation.group((String[])new String[]{"_id"}).first("orderId").as("orderId").first("formId").as("formId").first("userName").as("userName").first("amountCharged").as("amountCharged").first("amountDue").as("amountDue").first("amountPaid").as("amountPaid").first("paymentMethod").as("paymentMethod").first("currency").as("currency").first("orderAttempts").as("orderAttempts").first("createdAt").as("createdAt").first("status").as("status").first("formOrderNumber").as("formOrderNumber").first("totalAmountPaid").as("totalAmountPaid").first("tokenId").as("tokenId").push("payments").as("payments"), Aggregation.project((String[])new String[0]).and("orderId").as("orderId").and("formId").as("formId").and("userName").as("userName").and("amountCharged").as("amountCharged").and("amountDue").as("amountDue").and("amountPaid").as("amountPaid").and("paymentMethod").as("paymentMethod").and("currency").as("currency").and("orderAttempts").as("orderAttempts").and("createdAt").as("createdAt").and("status").as("status").and("formOrderNumber").as("formOrderNumber").and("totalAmountPaid").as("totalAmountPaid").and("tokenId").as("tokenId").and("payments").as("payments")});
        AggregationResults results = this.mongoTemplate.aggregate(aggregation, "masterpayment", MasterPayment.class);
        List masterPayments = results.getMappedResults();
        logger.debug("Full Aggregation Results: {}", (Object)masterPayments);
        if (masterPayments.isEmpty()) {
            logger.debug("No results found for the query: {}", (Object)query);
        }
        long orderCount = masterPayments.size();
        logger.debug("Orders count Found for pagination: {}", (Object)orderCount);
        HashMap<String, Object> pagedOrdersWithCount = new HashMap<String, Object>();
        pagedOrdersWithCount.put("OrdersCount", orderCount);
        pagedOrdersWithCount.put("OrderData", masterPayments);
        return pagedOrdersWithCount;
    }
}

