/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.controller;

import com.hepl.tunefortwo.config.i18n.Translator;
import com.hepl.tunefortwo.dto.ArtistDto;
import com.hepl.tunefortwo.dto.GenericData;
import com.hepl.tunefortwo.dto.GenericResponse;
import com.hepl.tunefortwo.entity.ArtistMaster;
import com.hepl.tunefortwo.service.ArtistService;
import com.hepl.tunefortwo.utils.JwtUtils;
import io.jsonwebtoken.Claims;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@Tag(name="Manage Artist", description="")
@RestController
@RequestMapping(value={"/v1/artistmaster"})
public class ArtistMasterController {
    private static final Logger log = LoggerFactory.getLogger(ArtistMasterController.class);
    private final ArtistService artistService;
    private final Translator translator;
    private final JwtUtils jwtUtils;

    public ArtistMasterController(ArtistService artistService, Translator translator, JwtUtils jwtUtils) {
        this.artistService = artistService;
        this.translator = translator;
        this.jwtUtils = jwtUtils;
    }

    @GetMapping(value={"/getall"})
    public GenericResponse getAllArtist() {
        log.info("Get all Artist");
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setArtist(this.artistService.getAllArtist());
        response.setData(data);
        return response;
    }

    @GetMapping(value={"/{id}"})
    public GenericResponse getArtistById(@PathVariable String id) {
        log.info("Fetching artist by ID: {}", (Object)id);
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setArtistMaster(this.artistService.getArtistById(id));
        response.setData(data);
        return response;
    }

    @GetMapping(value={"/createartistcollection"})
    public GenericResponse createArtistCollection(Authentication authentication) {
        if (authentication == null || !authentication.isAuthenticated()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (isAdmin) {
            GenericResponse response = new GenericResponse(true);
            GenericData data = new GenericData();
            List<ArtistMaster> addedData = this.artistService.addCollection();
            data.setArtist(addedData);
            response.setData(data);
            response.setMessage(this.translator.toLocale("deliveryDate.addData"));
            return response;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "You dont have the previllege to perform this action");
    }

    @Operation(description="Update Artist based on id")
    @PutMapping(value={"/{id}"})
    public GenericResponse updateArtist(@PathVariable String id, @RequestBody ArtistDto artistDto) {
        log.info("Update Artist with ID: {}", (Object)id);
        Double artistPrice = artistDto.getPrice();
        ArtistMaster updatedArtist = this.artistService.setArtistById(artistPrice, id);
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        ArrayList<ArtistMaster> updatedData = new ArrayList<ArtistMaster>();
        updatedData.add(updatedArtist);
        data.setArtist(updatedData);
        response.setData(data);
        response.setMessage("Artist Updated Successfully");
        return response;
    }
}

