/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.hepl.tunefortwo.dto.PaymentDetailsDto;
import com.hepl.tunefortwo.service.MasterPaymentService;
import com.hepl.tunefortwo.service.RefundRequestService;
import com.hepl.tunefortwo.utils.JwtUtils;
import com.razorpay.RazorpayException;
import io.jsonwebtoken.Claims;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.mail.MessagingException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@Tag(name="Manage Master Payment", description="")
@RestController
@RequestMapping(value={"/v1/masterpayment"})
public class MasterPaymentController {
    private static final Logger log = LoggerFactory.getLogger(MasterPaymentController.class);
    private final MasterPaymentService masterPaymentService;
    private final RefundRequestService refundRequestService;
    private final JwtUtils jwtUtils;

    public MasterPaymentController(MasterPaymentService masterPaymentService, RefundRequestService refundRequestService, JwtUtils jwtUtils) {
        this.masterPaymentService = masterPaymentService;
        this.refundRequestService = refundRequestService;
        this.jwtUtils = jwtUtils;
    }

    @PostMapping(value={"/createOrder"})
    public Map<String, String> createOrder(@RequestParam double amount, String formId) throws MessagingException {
        try {
            return this.masterPaymentService.createOrder(amount, formId);
        }
        catch (RazorpayException e) {
            throw new RuntimeException("Failed to create order", e);
        }
    }

    @PostMapping(value={"/handle"})
    public String handlePayment(@RequestBody PaymentDetailsDto paymentDetails, @RequestHeader(value="x-razorpay-signature", required=false) String razorpaySignature) throws RazorpayException, JsonMappingException, JsonProcessingException, MessagingException {
        String paymentId = paymentDetails.getPayment_id();
        String orderId = paymentDetails.getOrder_id();
        String paymentUpdateStatus = this.masterPaymentService.setPaymentsForAnOrderId(paymentId, razorpaySignature);
        return paymentUpdateStatus;
    }

    @GetMapping(value={"/getOrdersByStatus"})
    public Map<String, Object> getPaymentsByStatus(@RequestParam String status, Authentication authentication) {
        if (authentication == null || !authentication.isAuthenticated()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (isAdmin) {
            Map<String, Object> paymentsFound = this.masterPaymentService.getPaymentsWithBYStatus(status);
            return this.masterPaymentService.getPaymentsWithBYStatus(status);
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "You dont have the previllege to view this information");
    }

    @GetMapping(value={"/getallorders"})
    public Map<String, Object> getAllOrders(@RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="10") int size, @RequestParam(defaultValue="id") String sortBy, @RequestParam(defaultValue="asc") String sortDirection, @RequestParam(required=false) String searchQuery, @RequestParam(required=false) String status, Authentication authentication) {
        if (authentication == null || !authentication.isAuthenticated()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (isAdmin) {
            Sort.Direction direction = sortDirection.equalsIgnoreCase("desc") ? Sort.Direction.DESC : Sort.Direction.ASC;
            PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)direction, (String[])new String[]{sortBy}));
            return this.masterPaymentService.getAllOrders((Pageable)pageable, status, searchQuery);
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "You dont have the previllege to view this information");
    }

    @GetMapping(value={"/getPayments/generalOrderSearch"})
    public Map<String, Object> genericOrderSearch(@RequestParam(value="query") String query, Authentication authentication) {
        if (authentication == null || !authentication.isAuthenticated()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (isAdmin) {
            Map<String, Object> payments = this.masterPaymentService.genericOrderSearch(query);
            return payments;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "You dont have the previllege to view this information");
    }
}

