/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.controller;

import com.hepl.tunefortwo.config.i18n.Translator;
import com.hepl.tunefortwo.dto.GenericData;
import com.hepl.tunefortwo.dto.GenericResponse;
import com.hepl.tunefortwo.dto.PaymentDto;
import com.hepl.tunefortwo.entity.FileType;
import com.hepl.tunefortwo.service.FileService;
import com.hepl.tunefortwo.service.PaymentService;
import com.hepl.tunefortwo.utils.JwtUtils;
import io.jsonwebtoken.Claims;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.mail.MessagingException;
import jakarta.validation.Valid;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@Tag(name="Create and Manage Payment", description="")
@RestController
@RequestMapping(value={"/v1/payment"})
public class PaymentController {
    private static final Logger log = LoggerFactory.getLogger(PaymentController.class);
    private final PaymentService paymentService;
    private final Translator translator;
    private final FileService fileService;
    private final JwtUtils jwtUtils;

    public PaymentController(PaymentService paymentService, Translator translator, FileService fileService, JwtUtils jwtUtils) {
        this.paymentService = paymentService;
        this.translator = translator;
        this.fileService = fileService;
        this.jwtUtils = jwtUtils;
    }

    @PostMapping(consumes={"multipart/form-data"})
    public GenericResponse addPayemnt(@ModelAttribute PaymentDto data, Authentication authentication) throws MessagingException, IOException {
        Object response;
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (!isAdmin) {
            response = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Unauthorized");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        log.info("Adding Payment");
        if (data.getFile() != null) {
            String originalFilename = data.getFile().getOriginalFilename();
            if (originalFilename != null) {
                String fileExtension = originalFilename.substring(originalFilename.lastIndexOf(".") + 1);
                List<String> allowedExtensions = Arrays.asList("jpeg", "png", "jpg", "BMP");
                if (!allowedExtensions.contains(fileExtension.toLowerCase())) {
                    throw new IOException("Only Jpeg,Jpg,BMP and Png files are supported");
                }
            }
            data.setFilePath(this.fileService.uploadFile(data.getFile(), FileType.PAYMENT));
        }
        this.paymentService.savepayment(data);
        response = new GenericResponse(true);
        ((GenericResponse)response).setMessage(this.translator.toLocale("payment.paymentSavedSuccessully"));
        return response;
    }

    @GetMapping(value={"/{id}"})
    public GenericResponse getPaymentById(@PathVariable String id) {
        log.info("Get Payment");
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setPaymentDto(this.paymentService.getPaymentById(id));
        response.setData(data);
        return response;
    }

    @GetMapping(value={"/"})
    public GenericResponse getAllPayments() {
        log.info("Get All Payment");
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setPayments(this.paymentService.getAllPayments());
        response.setData(data);
        return response;
    }

    @Operation(description="")
    @PutMapping(value={"/{id}"}, consumes={"multipart/form-data"})
    public GenericResponse updatePayment(@PathVariable String id, @Valid @ModelAttribute PaymentDto payment, Authentication authentication) throws IOException {
        Object response;
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (!isAdmin) {
            response = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Unauthorized");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        log.info("Update payment ... {}", (Object)id);
        if (payment.getFile() != null && !payment.getFile().isEmpty()) {
            String originalFilename = payment.getFile().getOriginalFilename();
            if (originalFilename != null) {
                String fileExtension = originalFilename.substring(originalFilename.lastIndexOf(".") + 1);
                List<String> allowedExtensions = Arrays.asList("jpeg", "png", "jpg", "BMP");
                if (!allowedExtensions.contains(fileExtension.toLowerCase())) {
                    throw new IOException("Only Jpeg,Jpg,BMP and Png files are supported");
                }
            }
            payment.setFilePath(this.fileService.uploadFile(payment.getFile(), FileType.PAYMENT));
        }
        this.paymentService.updatePayment(payment, id);
        response = new GenericResponse(true);
        ((GenericResponse)response).setMessage(this.translator.toLocale("payment.paymentUpdatedSuccessfully"));
        return response;
    }

    @Operation(description="Delete Payment based on id")
    @DeleteMapping(value={"/{id}"})
    public GenericResponse deletePayment(@PathVariable String id) throws IOException {
        log.info("Delete payment ... {}", (Object)id);
        this.paymentService.delete(id);
        GenericResponse response = new GenericResponse(true);
        response.setMessage(this.translator.toLocale("payment.paymentDeletedSuccessfully"));
        return response;
    }

    @GetMapping(value={"/upi/{filename}"})
    public ResponseEntity<byte[]> serveFile(@PathVariable String filename) throws IOException, UnsupportedAudioFileException {
        log.info("Get filename .. {}", (Object)filename);
        Resource file = this.fileService.loadAsResource(filename, FileType.PAYMENT);
        if (file == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "error.fileNotFound");
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + file.getFilename() + "\""})).body((Object)file.getContentAsByteArray());
    }

    @GetMapping(value={"/calculatedeliverypayment"})
    public GenericResponse getCalculatePremiumPayment(@RequestParam LocalDate date) {
        log.info("Get DeliveryPayment Calculation");
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        data.setDeliveryPayment(this.paymentService.calculateDeliveryPayment(date));
        response.setData(data);
        return response;
    }
}

