/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.controller;

import com.hepl.tunefortwo.dto.GenericResponse;
import com.hepl.tunefortwo.dto.WelcomeVideoDto;
import com.hepl.tunefortwo.entity.FileType;
import com.hepl.tunefortwo.service.FileService;
import com.hepl.tunefortwo.service.WelcomeVideoService;
import com.hepl.tunefortwo.utils.JwtUtils;
import io.jsonwebtoken.Claims;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourceRegion;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRange;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@Tag(name="Add and Manage Welcome Videos", description="")
@RestController
@RequestMapping(value={"/v1/welcomeVideo"})
public class WelcomeVideoController {
    private static final Logger log = LoggerFactory.getLogger(WelcomeVideoController.class);
    private final WelcomeVideoService welcomeVideoService;
    private final FileService fileService;
    private final JwtUtils jwtUtils;

    public WelcomeVideoController(WelcomeVideoService welcomeVideoService, FileService fileService, JwtUtils jwtUtils) {
        this.welcomeVideoService = welcomeVideoService;
        this.fileService = fileService;
        this.jwtUtils = jwtUtils;
    }

    @GetMapping(value={"/getAllWelcomeVideos"})
    public GenericResponse getVideos() {
        return this.welcomeVideoService.getWelcomeVideos();
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/addVideo"})
    public GenericResponse addNewVideo(@ModelAttribute WelcomeVideoDto newVideoData, Authentication authentication) throws MessagingException, IOException {
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (!isAdmin) {
            ResponseEntity response = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Unauthorized");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        if (newVideoData.getVideoClip() != null) {
            String originalFilename = newVideoData.getVideoClip().getOriginalFilename();
            if (originalFilename != null) {
                String fileExtension = originalFilename.substring(originalFilename.lastIndexOf(".") + 1).toLowerCase();
                List<String> allowedExtensions = Arrays.asList("mp4", "mov", "wmv", "avi", "mkv");
                if (!allowedExtensions.contains(fileExtension)) {
                    throw new MessagingException("Only MP4, MOV, AVI, MKV, and WMV files are allowed");
                }
            }
            String filename = this.fileService.uploadFile(newVideoData.getVideoClip(), FileType.WELCOMEVIDEO);
            newVideoData.setVideoName(filename);
        }
        return this.welcomeVideoService.addWelcomeVideo(newVideoData);
    }

    @PutMapping(consumes={"multipart/form-data"}, value={"/updateVideo/{id}"})
    public GenericResponse updateVideoData(@ModelAttribute WelcomeVideoDto updateVideoData, @PathVariable(value="id") String id, Authentication authentication) throws IOException, MessagingException {
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (!isAdmin) {
            ResponseEntity response = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Unauthorized");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        return this.welcomeVideoService.updateWelcomeVideo(updateVideoData, id);
    }

    @GetMapping(value={"/video/{filename}"})
    public ResponseEntity<ResourceRegion> serveFile(@PathVariable String filename, @RequestHeader HttpHeaders headers) throws IOException {
        log.info("Get filename .. {}", (Object)filename);
        Resource file = this.fileService.loadAsResource(filename, FileType.WELCOMEVIDEO);
        if (file == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "error.fileNotFound");
        }
        long contentLength = file.contentLength();
        ResourceRegion resourceRegion = this.resourceRegion(file, headers, contentLength);
        String contentType = Files.probeContentType(Paths.get(file.getURI()));
        if (contentType == null) {
            contentType = "video/mp4";
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.PARTIAL_CONTENT).contentType(MediaType.parseMediaType((String)contentType)).body((Object)resourceRegion);
    }

    private ResourceRegion resourceRegion(Resource file, HttpHeaders headers, long contentLength) throws IOException {
        long chunkSize = 0x100000L;
        if (headers.getRange().isEmpty()) {
            long rangeStart = 0L;
            long rangeEnd = Math.min(0x100000L, contentLength - 1L);
            return new ResourceRegion(file, rangeStart, rangeEnd - rangeStart + 1L);
        }
        HttpRange range = (HttpRange)headers.getRange().get(0);
        long rangeStart = range.getRangeStart(contentLength);
        long rangeEnd = Math.min(range.getRangeEnd(contentLength), contentLength - 1L);
        long rangeLength = Math.min(0x100000L, rangeEnd - rangeStart + 1L);
        return new ResourceRegion(file, rangeStart, rangeLength);
    }

    @GetMapping(value={"/getMobileWelcomeVideo"})
    public GenericResponse getVideoForMobile() {
        return this.welcomeVideoService.getMobileVideo();
    }

    @GetMapping(value={"/{id}"})
    public GenericResponse getWelcomeVideoById(@PathVariable String id, Authentication authentication) {
        boolean isAdmin = false;
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtAuthToken.getToken();
            String tokenValue = jwt.getTokenValue();
            Claims claims = this.jwtUtils.extractClaims(tokenValue);
            String email = claims.getSubject();
            Map userDetails = (Map)claims.get((Object)"userDetails");
            if (userDetails != null) {
                String roleId = (String)userDetails.get("roleId");
                String userId = (String)userDetails.get("id");
                if (roleId.equals("1")) {
                    isAdmin = true;
                }
            }
        }
        if (!isAdmin) {
            ResponseEntity response = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Unauthorized");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Unauthorized");
        }
        log.info("Get WelcomeVIdeo By ID");
        return this.welcomeVideoService.getWelcomeVideoById(id);
    }
}

