/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hepl.tunefortwo.config.jackson.ForceStringDeserializer;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;

public class ContactDto {
    @NotBlank(message="{validation.user.usernameCannotBeEmpty}")
    @Size(max=60, message="{validation.user.usernameMustBeMaximumOf_60Characters}")
    @Pattern(regexp="^[a-zA-Z0-9\\s]*$", message="{validation.user.usernameCannotContainSpecialCharacters}")
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    private @NotBlank(message="{validation.user.usernameCannotBeEmpty}") @Size(max=60, message="{validation.user.usernameMustBeMaximumOf_60Characters}") @Pattern(regexp="^[a-zA-Z0-9\\s]*$", message="{validation.user.usernameCannotContainSpecialCharacters}") String name;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    @Size(min=0, max=750, message="{validation.user.usercommentsMustBeMaximumOf_750Characters}")
    private @Size(min=0, max=750, message="{validation.user.usercommentsMustBeMaximumOf_750Characters}") String message;
    @NotBlank(message="{validation.user.mobileCannotBeEmpty}")
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_WRITE, description="Encrypt data using AES/GCM", example="+128484444545")
    @JsonDeserialize(using=ForceStringDeserializer.class)
    private @NotBlank(message="{validation.user.mobileCannotBeEmpty}") String mobileNumber;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_WRITE)
    @Pattern(regexp="^[a-z0-9]{1,25}(?:[._+][a-z0-9]+)*@[a-z0-9.-]+\\.[a-z]{2,}$", message="{validation.user.emailIsInvalid}")
    private @Pattern(regexp="^[a-z0-9]{1,25}(?:[._+][a-z0-9]+)*@[a-z0-9.-]+\\.[a-z]{2,}$", message="{validation.user.emailIsInvalid}") String email;

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public String getEmail() {
        return this.email;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JsonDeserialize(using=ForceStringDeserializer.class)
    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}

