/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import org.springframework.web.multipart.MultipartFile;

public class InstrumentRequestDto {
    @NotBlank(message="{Instrument Name Cannot Be Empty}")
    @Size(max=60, message="{Instrument Name Must Be Maximum Of_60 Characters}")
    @Pattern(regexp="^[a-zA-Z\\s]*$", message="{Instrument Name Cannot Contain Special Characters}")
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    private @NotBlank(message="{Instrument Name Cannot Be Empty}") @Size(max=60, message="{Instrument Name Must Be Maximum Of_60 Characters}") @Pattern(regexp="^[a-zA-Z\\s]*$", message="{Instrument Name Cannot Contain Special Characters}") String name;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED)
    private double price;
    @Schema(requiredMode=Schema.RequiredMode.NOT_REQUIRED, accessMode=Schema.AccessMode.READ_WRITE, required=false)
    private MultipartFile audio;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, required=false)
    private String audioPath;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private String audioDuration;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    private String description;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    private String image;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    private String imageTitle;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    private boolean isBestSeller;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    private String instrumentCategory;

    public void setName(String name) {
        this.name = name;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public void setAudio(MultipartFile audio) {
        this.audio = audio;
    }

    public void setAudioPath(String audioPath) {
        this.audioPath = audioPath;
    }

    public void setAudioDuration(String audioDuration) {
        this.audioDuration = audioDuration;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setImageTitle(String imageTitle) {
        this.imageTitle = imageTitle;
    }

    public void setBestSeller(boolean isBestSeller) {
        this.isBestSeller = isBestSeller;
    }

    public void setInstrumentCategory(String instrumentCategory) {
        this.instrumentCategory = instrumentCategory;
    }

    public String getName() {
        return this.name;
    }

    public double getPrice() {
        return this.price;
    }

    public MultipartFile getAudio() {
        return this.audio;
    }

    public String getAudioPath() {
        return this.audioPath;
    }

    public String getAudioDuration() {
        return this.audioDuration;
    }

    public String getDescription() {
        return this.description;
    }

    public String getImage() {
        return this.image;
    }

    public String getImageTitle() {
        return this.imageTitle;
    }

    public boolean isBestSeller() {
        return this.isBestSeller;
    }

    public String getInstrumentCategory() {
        return this.instrumentCategory;
    }
}

