/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.repository;

import com.hepl.tunefortwo.entity.Instrument;
import com.mongodb.client.result.UpdateResult;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.data.mongodb.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface InstrumentRepository
extends MongoRepository<Instrument, String> {
    public static final String COLLECTION_NAME = "instrument_master";

    public Instrument findByName(String var1);

    default public UpdateResult updateAccessControlStatus(String id, String status, MongoTemplate mongoTemplate) {
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query().addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id));
        Update update = new Update();
        update.set("status", (Object)status);
        return mongoTemplate.updateFirst(query, (UpdateDefinition)update, COLLECTION_NAME);
    }

    @Query(value="{ 'status': 'ACTIVE' }")
    public List<Instrument> findActiveInstruments(Sort var1);

    default public List<Instrument> findActiveInstrumentsSortedByPrice(Sort.Direction direction) {
        Sort sort = Sort.by((Sort.Direction)direction, (String[])new String[]{"price"});
        return this.findAll(sort).stream().sorted(Comparator.comparing(Instrument::getPrice, direction == Sort.Direction.ASC ? Comparator.naturalOrder() : Comparator.reverseOrder())).collect(Collectors.toList());
    }
}

