/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.service.impl;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.hepl.tunefortwo.config.exceptions.FieldException;
import com.hepl.tunefortwo.dto.FormRequestDto;
import com.hepl.tunefortwo.dto.IsMandatory;
import com.hepl.tunefortwo.dto.OrderPosition;
import com.hepl.tunefortwo.dto.OrderTrackerDto;
import com.hepl.tunefortwo.entity.FileType;
import com.hepl.tunefortwo.entity.Filed;
import com.hepl.tunefortwo.entity.Form;
import com.hepl.tunefortwo.mapper.FormMapper;
import com.hepl.tunefortwo.repository.FiledRepository;
import com.hepl.tunefortwo.repository.FormRepository;
import com.hepl.tunefortwo.service.FileService;
import com.hepl.tunefortwo.service.FormService;
import com.hepl.tunefortwo.service.MailService;
import com.hepl.tunefortwo.service.OtpService;
import com.hepl.tunefortwo.service.TemplateService;
import com.hepl.tunefortwo.service.impl.FileServiceImpl;
import com.hepl.tunefortwo.service.impl.MailServiceImpl;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ResponseStatusException;

@Service
public class FormServiceImpl
implements FormService {
    private static final Logger log = LoggerFactory.getLogger(FormServiceImpl.class);
    private final FormRepository formRepository;
    private final FormMapper formMapper;
    private final MailService mailService;
    private final TemplateService templateService;
    private final FiledRepository filedRepository;
    private final FileServiceImpl fileServiceImpl;
    private final FileService fileService;
    private final PhoneNumberUtil phoneNumberUtil;
    private final OtpService otpService;
    private final String Pending_Stage = "Pending in stage of ";
    private final String Delivered_Stage = "Delivered! Song sent to your email";
    private static final Logger logger = LoggerFactory.getLogger(FormService.class);
    @Value(value="${baseUrl.orderTracker}")
    public String trackorderLink;
    @Autowired
    private MongoTemplate mongoTemplate;

    public FormServiceImpl(FormRepository formRepository, FormMapper formMapper, MailService mailService, TemplateService templateService, FileServiceImpl fileServiceImpl, FiledRepository filedRepository, FileService fileService, PhoneNumberUtil phoneNumberUtil, OtpService otpService) {
        this.formRepository = formRepository;
        this.formMapper = formMapper;
        this.templateService = templateService;
        this.mailService = mailService;
        this.fileServiceImpl = fileServiceImpl;
        this.filedRepository = filedRepository;
        this.fileService = fileService;
        this.phoneNumberUtil = phoneNumberUtil;
        this.otpService = otpService;
    }

    @Override
    public Form saveForm(FormRequestDto form) throws MessagingException {
        Boolean deliveyDate = false;
        log.info("Form service");
        Form data = new Form();
        List filed = this.filedRepository.findAll();
        List filedNames = filed.stream().map(x -> x.getName()).collect(Collectors.toList());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "Name");
        map.put("mail", "Email id");
        map.put("phoneNumber", "Mobile Number");
        map.put("language", "Language");
        map.put("instrument", "Instrument");
        map.put("artist", "Artist");
        map.put("mood", "Mood");
        map.put("songto", "Who is the song to ?");
        map.put("songfrom", "Who is the song  from ?");
        map.put("occasion", "What is the Occasion ?");
        map.put("story", "Tell us your story");
        map.put("clips", "Record your story audio");
        map.put("Mixing", "Select an mixing mastering");
        Boolean name = this.validate((String)map.get("name"), form.getName());
        Boolean mail = this.validate((String)map.get("mail"), form.getMail());
        Boolean phoneNumber = this.validate((String)map.get("phoneNumber"), form.getPhonenumber());
        Boolean language = this.validate((String)map.get("language"), form.getLanuage());
        Boolean artist = this.validate((String)map.get("artist"), form.getArtist());
        Boolean instrument = this.validate((String)map.get("instrument"), form.getInstrument());
        Boolean mood = this.validate((String)map.get("mood"), form.getMood());
        Boolean songto = this.validate((String)map.get("songto"), form.getSongto());
        Boolean songfrom = this.validate((String)map.get("songfrom"), form.getSongfrom());
        Boolean occasion = this.validate((String)map.get("songfrom"), form.getOccasion());
        Boolean story = this.validate((String)map.get("story"), form.getStory());
        Boolean clips = this.validate((String)map.get("clips"), form.getClipPath());
        Boolean mixing = this.validate((String)map.get("Mixing"), form.getMasterRequest() == null ? "" : form.getMasterRequest().toString());
        if (!this.otpService.isEmailVerified(form.getMail())) {
            throw new MessagingException("Email Not Verified");
        }
        System.out.println("name " + name.toString());
        data.setName(form.getName());
        data.setMail(form.getMail());
        data.setPhonenumber(form.getPhonenumber());
        data.setLanuage(form.getLanuage());
        data.setArtist(form.getArtist());
        data.setInstrument(form.getInstrument());
        data.setMood(form.getMood());
        data.setSongto(form.getSongto());
        data.setSongfrom(form.getSongfrom());
        data.setOccasion(form.getOccasion());
        data.setStory(form.getStory());
        data.setClipPath(form.getClipPath());
        data.setOrderTotal(form.getOrderTotal());
        ArrayList<OrderTrackerDto> orderTrackerDtos = new ArrayList<OrderTrackerDto>();
        OrderTrackerDto orderTrackerDto = new OrderTrackerDto();
        orderTrackerDto.setOrderPosition(OrderPosition.ORDER_SAVED.toString());
        String orderNumberString = this.getNextOrderNumber();
        System.out.println(orderNumberString);
        orderTrackerDto.setOrderNumber(orderNumberString);
        orderTrackerDto.setUpdatedDate(LocalDateTime.now());
        orderTrackerDtos.add(orderTrackerDto);
        data.setOrderPosition(orderTrackerDtos);
        data.setCustomerDeliveryDate(form.getCustomerDeliveryDate());
        data.setOrderNumber(orderNumberString);
        data.setStatus(OrderPosition.ORDER_SAVED.toString());
        data.setClipDuration(form.getClipDuration());
        data.setMixtureMaster(form.getMasterRequest() == null ? "" : form.getMasterRequest().toString());
        data.setDurationInMMSS(form.getDurationInMMSS());
        HashMap<String, String> errors = new HashMap<String, String>();
        if (name.booleanValue()) {
            errors.put("Name", "filed.filedNameRequired");
        }
        if (mail.booleanValue()) {
            errors.put("Mail", "filed.filedMailRequired");
        }
        if (phoneNumber.booleanValue()) {
            errors.put("Phonenumber", "filed.filedPhoneNumberRequired");
        }
        if (language.booleanValue()) {
            errors.put("Language", "filed.filedLanguageRequired");
        }
        if (artist.booleanValue()) {
            errors.put("Artist", "filed.filedArtistRequired");
        }
        if (instrument.booleanValue()) {
            errors.put("Instrument", "filed.filedInstrumentRequired");
        }
        if (mood.booleanValue()) {
            errors.put("Mood", "filed.filedMoodRequired");
        }
        if (songto.booleanValue()) {
            errors.put("Songto", "filed.filedSongtoRequired");
        }
        if (songfrom.booleanValue()) {
            errors.put("Songfrom", "filed.filedSongfromRequired");
        }
        if (occasion.booleanValue()) {
            errors.put("Occasion", "filed.filedOccasionRequired");
        }
        if (story.booleanValue()) {
            errors.put("Story", "filed.filedStoryRequired");
        }
        if (clips.booleanValue()) {
            errors.put("Clips", "filed.filedClipsRequired");
        }
        if (mixing.booleanValue()) {
            errors.put("Mixing", "filed.filedMixingRequired");
        }
        if (!errors.isEmpty()) {
            throw new FieldException("", errors);
        }
        return (Form)this.formRepository.save(data);
    }

    private boolean validate(String filed, String dto) {
        Filed filedName = this.filedRepository.findByName(filed);
        System.out.println("hi = " + filedName.getIsMandatory());
        if (filedName.getIsMandatory().equals(IsMandatory.Mandatory.toString())) {
            return dto == null || dto.isEmpty();
        }
        return false;
    }

    private String getNextOrderNumber() {
        Optional<Form> formOptional = this.formRepository.findFirstByOrderByCreatedDateDesc();
        String lastOrderNumber = formOptional.map(Form::getOrderNumber).orElse(null);
        log.info("Form service getNextOrderNumber ");
        if (lastOrderNumber != null) {
            String numericPart = lastOrderNumber.substring(2);
            int incrementedValue = Integer.parseInt(numericPart) + 1;
            return "MS" + incrementedValue;
        }
        return "MS1";
    }

    @Override
    public Map<String, Object> allForms(Pageable pageable, boolean isAdmin, String query) {
        if (isAdmin && query != null && !query.isEmpty()) {
            String regexSearchTerm = ".*" + query + ".*";
            Criteria criteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"name").regex(regexSearchTerm, "i"), Criteria.where((String)"mail").regex(regexSearchTerm, "i"), Criteria.where((String)"phonenumber").regex(regexSearchTerm, "i"), Criteria.where((String)"orderNumber").regex(regexSearchTerm, "i")});
            Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.project((String[])new String[0]).and("_id").as("id").and("name").as("name").and("mail").as("mail").and("phonenumber").as("phonenumber").and("instrument").as("instrument").and("mood").as("mood").and("lanuage").as("lanuage").and("artist").as("artist").and("songto").as("songto").and("songfrom").as("songfrom").and("occasion").as("occasion").and("story").as("story").and("clipPath").as("clipPath").and("adminClipPath").as("adminClipPath").and("clipDuration").as("clipDuration").and("status").as("status").and("orderNumber").as("orderNumber").and("mixtureMaster").as("mixtureMaster").and("comments").as("comments").and("orderPosition").as("orderPosition").and("createdDate").as("createdDate").and("customerDeliveryDate").as("customerDeliveryDate").and("review").as("review").and("rating").as("rating").and("images").as("images").and("video").as("video").and("deliveryDate").as("deliveryDate").and("durationInMMSS").as("durationInMMSS").and("orderTotal").as("orderTotal").and("activeStatus").as("activeStatus").and("paymentId").as("paymentId")});
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, "Form", Form.class);
            List forms = results.getMappedResults();
            int start = (int)pageable.getOffset();
            int end = Math.min(start + pageable.getPageSize(), forms.size());
            List pagedForms = forms.subList(start, end);
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (isAdmin) {
                List allForms = pagedForms.stream().map(this.formMapper::toDto).collect(Collectors.toList());
                result.put("forms", allForms);
            } else {
                List allForms = pagedForms.stream().map(this.formMapper::toDtoCoAdmin).collect(Collectors.toList());
                result.put("forms", allForms);
            }
            result.put("totalElements", forms.size());
            return result;
        }
        if (!(isAdmin || query == null || query.isEmpty() || isAdmin)) {
            String regexSearchTerm = ".*" + query + ".*";
            Criteria criteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"name").regex(regexSearchTerm, "i"), Criteria.where((String)"orderNumber").regex(regexSearchTerm, "i")});
            Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.project((String[])new String[0]).and("_id").as("id").and("name").as("name").and("mail").as("mail").and("phonenumber").as("phonenumber").and("instrument").as("instrument").and("mood").as("mood").and("lanuage").as("lanuage").and("artist").as("artist").and("songto").as("songto").and("songfrom").as("songfrom").and("occasion").as("occasion").and("story").as("story").and("clipPath").as("clipPath").and("adminClipPath").as("adminClipPath").and("clipDuration").as("clipDuration").and("status").as("status").and("orderNumber").as("orderNumber").and("mixtureMaster").as("mixtureMaster").and("comments").as("comments").and("orderPosition").as("orderPosition").and("createdDate").as("createdDate").and("customerDeliveryDate").as("customerDeliveryDate").and("review").as("review").and("rating").as("rating").and("images").as("images").and("video").as("video").and("deliveryDate").as("deliveryDate").and("durationInMMSS").as("durationInMMSS").and("orderTotal").as("orderTotal").and("activeStatus").as("activeStatus").and("paymentId").as("paymentId")});
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, "Form", Form.class);
            List forms = results.getMappedResults();
            int start = (int)pageable.getOffset();
            int end = Math.min(start + pageable.getPageSize(), forms.size());
            List pagedForms = forms.subList(start, end);
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (isAdmin) {
                List allForms = pagedForms.stream().map(this.formMapper::toDto).collect(Collectors.toList());
                result.put("forms", allForms);
            } else {
                List allForms = pagedForms.stream().map(this.formMapper::toDtoCoAdmin).collect(Collectors.toList());
                result.put("forms", allForms);
            }
            result.put("totalElements", forms.size());
            return result;
        }
        log.info("Get all forms");
        List totalForms = this.formRepository.findAll();
        int totalCount = totalForms.size();
        if (isAdmin) {
            List allForms = this.formRepository.findAll(pageable).stream().map(this.formMapper::toDto).collect(Collectors.toList());
            int count = allForms.size();
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("forms", allForms);
            result.put("totalElements", totalCount);
            return result;
        }
        List allForms = this.formRepository.findAll(pageable).stream().map(this.formMapper::toDtoCoAdmin).collect(Collectors.toList());
        int count = allForms.size();
        HashMap<String, Object> resultForCoAdmin = new HashMap<String, Object>();
        resultForCoAdmin.put("forms", allForms);
        resultForCoAdmin.put("totalElements", totalCount);
        return resultForCoAdmin;
    }

    @Override
    public FormRequestDto getFormById(String id) {
        log.info("Get  form by : " + id);
        Form optionalForm = (Form)this.formRepository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "song.songNotFoundwith ID: " + id));
        return this.formMapper.toDto(optionalForm);
    }

    @Override
    public Map<String, Object> getFormsByOrderPosition(OrderPosition position, Sort sort, boolean isAdmin) {
        log.info("Get all forms by OrderPosition");
        List<Form> forms = this.formRepository.findFormsByLastOrderPosition(position.toString(), sort);
        if (isAdmin) {
            List formDtos = forms.stream().map(this.formMapper::toDto).collect(Collectors.toList());
            int count = formDtos.size();
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("forms", formDtos);
            result.put("count", count);
            return result;
        }
        List formDtos = forms.stream().map(this.formMapper::toDtoCoAdmin).collect(Collectors.toList());
        int count = formDtos.size();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("forms", formDtos);
        result.put("count", count);
        return result;
    }

    @Override
    public String updateOrderPosition(OrderPosition orderPosition, String id, String filePath) throws MessagingException {
        log.info("Update the orderPostion By id = " + id);
        Optional optionalForm = this.formRepository.findById(id);
        if (optionalForm.isPresent()) {
            Form form = (Form)optionalForm.get();
            List<OrderTrackerDto> currentOrderPositions = form.getOrderPosition();
            if (currentOrderPositions == null) {
                currentOrderPositions = new ArrayList<OrderTrackerDto>();
            }
            OrderPosition lastOrderPosition = null;
            if (!currentOrderPositions.isEmpty()) {
                OrderTrackerDto lastOrderTracker = currentOrderPositions.get(currentOrderPositions.size() - 1);
                lastOrderPosition = OrderPosition.valueOf(lastOrderTracker.getOrderPosition());
            }
            if (lastOrderPosition != null && !this.isValidTransition(lastOrderPosition, orderPosition)) {
                throw new MessagingException("Invalid transition from " + lastOrderPosition + " to " + orderPosition);
            }
            for (int i = 0; i < currentOrderPositions.size(); ++i) {
                OrderTrackerDto dto = currentOrderPositions.get(i);
                if (!dto.getOrderPosition().equals(orderPosition.toString())) continue;
                throw new MessagingException("Order position already present: " + orderPosition.toString());
            }
            OrderTrackerDto orderTrackerDto = new OrderTrackerDto();
            orderTrackerDto.setOrderPosition(orderPosition.toString());
            orderTrackerDto.setUpdatedDate(LocalDateTime.now());
            if (!orderPosition.toString().equals(OrderPosition.DELIVERED.toString())) {
                orderTrackerDto.setComments("Pending in stage of " + orderPosition);
            }
            orderTrackerDto.setOrderNumber(form.getOrderNumber());
            currentOrderPositions.add(orderTrackerDto);
            form.setOrderPosition(currentOrderPositions);
            form.setStatus(orderPosition.toString());
            System.out.println("Implementation: formdata" + form.getStatus());
            if (filePath != null) {
                form.setAdminClipPath(filePath);
            }
            String songTitle = form.getAdminClipPath().replaceAll("^\\d+-", "");
            Form updatedForm = (Form)this.formRepository.save(form);
            log.info("OrderPosition updated successfully for id = {}", (Object)id);
            LocalDate dateForDeliveryEmail = null;
            if (orderPosition == OrderPosition.DELIVERED) {
                Optional optionalFormForDeliveryDate = this.formRepository.findById(id);
                if (optionalFormForDeliveryDate.isPresent()) {
                    Form formForDeliveryDate = (Form)optionalFormForDeliveryDate.get();
                    LocalDateTime currentDateTime = LocalDateTime.now();
                    LocalDate currentDate = currentDateTime.toLocalDate();
                    Date deliveryDate = new Date();
                    LocalDate localDate = deliveryDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    LocalDate nextDay = localDate.plusDays(1L);
                    Date updatedDeliveryDate = Date.from(nextDay.atStartOfDay(ZoneId.systemDefault()).toInstant());
                    formForDeliveryDate.setDeliveryDate(deliveryDate);
                    Form savedData = (Form)this.formRepository.save(formForDeliveryDate);
                    logger.debug("Saved  : {}", (Object)savedData);
                }
                dateForDeliveryEmail = LocalDate.now();
                String deliverySongPath = MailServiceImpl.BACKEND_BASE_URL + filePath;
                String reviewLink = MailServiceImpl.FRONTEND_BASE_URL + "#/addReview/" + id;
                this.mailService.sendMailByTemplate(this.templateService.getOrderConfirmTemplate(deliverySongPath, reviewLink, form.getOrderNumber(), form.getName(), form.getArtist(), form.getInstrument(), form.getCreatedDate().toLocalDate(), songTitle, dateForDeliveryEmail), form.getMail(), "Order Delivery Email");
            }
            return updatedForm.getStatus();
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "song.songNotFound with ID: " + id);
    }

    @Override
    public void updateForm(FormRequestDto dto, String id) throws IOException, MessagingException {
        log.info("Update the form By id = " + id);
        Form optionalForm = (Form)this.formRepository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "song.songNotFoundwith ID: " + id));
        if (dto.getName() != null) {
            optionalForm.setName(dto.getName());
        }
        if (dto.getPhonenumber() != null) {
            optionalForm.setPhonenumber(dto.getPhonenumber());
        }
        optionalForm.setMail(dto.getMail());
        optionalForm.setLanuage(dto.getLanuage());
        if (dto.getArtist() != null) {
            optionalForm.setArtist(dto.getArtist());
        }
        if (dto.getInstrument() != null) {
            optionalForm.setInstrument(dto.getInstrument());
        }
        if (dto.getMood() != null) {
            optionalForm.setMood(dto.getMood());
        }
        if (dto.getSongto() != null) {
            optionalForm.setSongto(dto.getSongto());
        }
        if (dto.getSongfrom() != null) {
            optionalForm.setSongfrom(dto.getSongfrom());
        }
        if (dto.getOccasion() != null) {
            optionalForm.setOccasion(dto.getOccasion());
        }
        if (dto.getStory() != null) {
            optionalForm.setStory(dto.getStory());
        }
        if (dto.getOrderTotal() != null) {
            optionalForm.setOrderTotal(dto.getOrderTotal());
        }
        if (dto.getClip() != null) {
            String originalFilename = dto.getClip().getOriginalFilename();
            if (originalFilename != null) {
                String fileExtension = originalFilename.substring(originalFilename.lastIndexOf(".") + 1);
                List<String> allowedExtensions = Arrays.asList("mp3", "wav", "OGG", "AAC");
                if (!allowedExtensions.contains(fileExtension.toLowerCase())) {
                    throw new MessagingException("Only MP3,AAC, and WAV files are allowed");
                }
            }
            String filename = this.fileService.uploadFile(dto.getClip(), FileType.CLIP);
            Resource file = this.fileService.loadAsResource(filename, FileType.CLIP);
            dto.setClipPath(filename);
            Path filePath = Paths.get(file.getURI());
            optionalForm.setClipPath(this.fileServiceImpl.uploadFile(dto.getClip(), FileType.CLIP));
        }
        if (dto.getClipDuration() != null) {
            long durationRoundOne = (long)Math.floor(dto.getClipDuration());
            long inMinutes = durationRoundOne / 60L;
            long inSeconds = durationRoundOne % 60L;
            String inFormattedTime = String.format("%02d:%02d", inMinutes, inSeconds);
            optionalForm.setClipDuration(dto.getClipDuration());
            optionalForm.setDurationInMMSS(inFormattedTime);
        }
        if (dto.getMasterRequest() != null) {
            optionalForm.setMixtureMaster(dto.getMasterRequest().toString());
        }
        if (dto.getCustomerDeliveryDate() != null) {
            optionalForm.setCustomerDeliveryDate(dto.getCustomerDeliveryDate());
        }
        this.formRepository.save(optionalForm);
    }

    @Override
    public List<Object> trackerOrder(String number, String orderId) {
        log.info("Track order: " + number);
        Form order = this.formRepository.findByPhonenumberAndOrderNumber(number, orderId).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Validation.song.orderNumberNotFound"));
        List<Object> orderPositions = this.formRepository.findOrderPositionByPhonenumberAndOrderNumber(number, orderId);
        System.out.println(orderPositions.toString());
        if (orderPositions.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Validation.song.mobileNumberNotFound");
        }
        return orderPositions;
    }

    private boolean isValidInput(String number, String orderId) {
        return !StringUtils.isEmpty((Object)number) && !StringUtils.isEmpty((Object)orderId);
    }

    @Override
    public void addScreenShot(String orderId, String path) {
        Form formDetails = this.formRepository.findByOrderNumber(orderId).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "song.songNotFoundwith OrderNumber: " + orderId));
        formDetails.setScreenshot(path);
        this.formRepository.save(formDetails);
    }

    @Override
    public void addcomment(String orderId, String comment, LocalDate deliveryDate, String orderNumber) throws MessagingException {
        LocalDate dateForConfirmationEmail = null;
        Form formDetails = this.formRepository.findByOrderNumber(orderId).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "song.songNotFoundwith OrderNumber: " + orderId));
        System.out.println("queryresult" + (formDetails.getId() != null ? formDetails.getId() : ""));
        dateForConfirmationEmail = deliveryDate == null ? formDetails.getCustomerDeliveryDate() : deliveryDate;
        List<OrderTrackerDto> currentOrderPositions = formDetails.getOrderPosition();
        OrderTrackerDto lastOrderPosition = currentOrderPositions.get(currentOrderPositions.size() - 1);
        String deliveredPosition = lastOrderPosition.getOrderPosition();
        if (comment != null && comment != "") {
            lastOrderPosition.setComments(comment);
        } else if (!lastOrderPosition.getOrderPosition().equals(OrderPosition.DELIVERED.toString())) {
            lastOrderPosition.setComments("Pending in stage of " + lastOrderPosition.getOrderPosition().toString().replace("_", " "));
        }
        if (deliveredPosition.equals(OrderPosition.DELIVERED.toString())) {
            Object finalComment = lastOrderPosition.getComments();
            if (finalComment == null) {
                finalComment = "Delivered! Song sent to your email";
            } else if (((String)finalComment).isEmpty()) {
                finalComment = "Delivered! Song sent to your email";
            } else {
                finalComment = (String)finalComment + System.lineSeparator();
                finalComment = (String)finalComment + "Delivered! Song sent to your email";
            }
            lastOrderPosition.setComments((String)finalComment);
        }
        System.out.println("appendedcomment" + (formDetails.getComments() != null ? formDetails.getComments() : ""));
        this.formRepository.save(formDetails);
        if (deliveredPosition.equals(OrderPosition.ORDER_CONFIRMED.toString())) {
            this.mailService.sendMailByTemplate(this.templateService.getAccountSetupTemlate(formDetails.getName(), formDetails.getCreatedDate().toLocalDate(), formDetails.getArtist(), formDetails.getInstrument(), dateForConfirmationEmail, orderNumber, this.trackorderLink + formDetails.getId()), formDetails.getMail(), "Order Confirmed");
        }
    }

    @Override
    public void updateRatingAndReview(int rating, String review, String id, List<String> image, String video) {
        Form formDetails = (Form)this.formRepository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "song.songNotFound with ID: " + id));
        formDetails.setRating(rating);
        formDetails.setReview(review);
        formDetails.setVideo(video);
        if (image != null && image.size() > 0) {
            formDetails.setImages(image);
        }
        this.formRepository.save(formDetails);
    }

    @Override
    public void addReview(String orderId, String summary, int star, String image, String video) {
    }

    @Override
    public FormRequestDto getRatingandReview(String id) {
        log.info("Get  RatingandReview by : " + id);
        Form optionalForm = (Form)this.formRepository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "song.songNotFoundwith ID: " + id));
        return this.formMapper.toDto(optionalForm);
    }

    @Override
    public boolean isValidTransition(OrderPosition currentOrderPosition, OrderPosition newOrderPosition) {
        switch (currentOrderPosition) {
            case ORDER_SAVED: {
                return newOrderPosition == OrderPosition.ORDER_CONFIRMED;
            }
            case ORDER_CONFIRMED: {
                return newOrderPosition == OrderPosition.SONG_COMPOSING;
            }
            case SONG_COMPOSING: {
                return newOrderPosition == OrderPosition.SONG_RECORDING;
            }
            case SONG_RECORDING: {
                return newOrderPosition == OrderPosition.DELIVERED;
            }
            case DELIVERED: {
                return false;
            }
        }
        return false;
    }

    @Override
    public FormRequestDto rejectAFormByItsId(String id, String activestatus) {
        log.info("Reject form By id = " + id);
        Form formTobeRejectOrUpdated = (Form)this.formRepository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "song.songNotFoundwith ID: " + id));
        formTobeRejectOrUpdated.setActiveStatus(activestatus);
        if ("inactive".equals(activestatus)) {
            formTobeRejectOrUpdated.setStatus("REJECTED");
        }
        if ("active".equals(activestatus)) {
            formTobeRejectOrUpdated.setStatus(OrderPosition.ORDER_SAVED.toString());
        }
        this.formRepository.save(formTobeRejectOrUpdated);
        FormRequestDto optionalFormUpdated = this.formMapper.toDto(formTobeRejectOrUpdated);
        return optionalFormUpdated;
    }

    @Override
    public Map<String, Object> getAllRejectedForms(String activestatus) {
        List<Form> activeOrInactiveForms = this.formRepository.findByActiveStatus(activestatus);
        if (activeOrInactiveForms.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Forms not found for the given status");
        }
        List allAvailableForms = activeOrInactiveForms.stream().map(this.formMapper::toDto).collect(Collectors.toList());
        int newCount = allAvailableForms.size();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("forms", allAvailableForms);
        result.put("count", newCount);
        return result;
    }

    @Override
    public void exportToExcel(LocalDate startDate, LocalDate endDate, OutputStream outputStream) throws IOException {
    }

    @Override
    public boolean validateMobileNumber(String countryCode, String mobileNumber) {
        try {
            String fullNumber = countryCode + mobileNumber;
            Phonenumber.PhoneNumber phoneNumber = this.phoneNumberUtil.parse((CharSequence)fullNumber, null);
            return this.phoneNumberUtil.isValidNumber(phoneNumber);
        }
        catch (NumberParseException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public String getNumberInfo(String countryCode, String mobileNumber) {
        try {
            String fullNumber = countryCode + mobileNumber;
            Phonenumber.PhoneNumber phoneNumber = this.phoneNumberUtil.parse((CharSequence)fullNumber, null);
            if (this.phoneNumberUtil.isValidNumber(phoneNumber)) {
                String region = this.phoneNumberUtil.getRegionCodeForNumber(phoneNumber);
                PhoneNumberUtil.PhoneNumberType numberType = this.phoneNumberUtil.getNumberType(phoneNumber);
                return String.format("Valid number. Region: %s, Type: %s", region, numberType);
            }
            return "Invalid number";
        }
        catch (NumberParseException e) {
            e.printStackTrace();
            return "Error parsing number: " + e.getMessage();
        }
    }

    @Override
    public String[] extractCountryCodeAndNationalNumber(String phoneNumber) {
        try {
            Phonenumber.PhoneNumber number = this.phoneNumberUtil.parse((CharSequence)phoneNumber, null);
            int countryCode = number.getCountryCode();
            String nationalNumber = String.valueOf(number.getNationalNumber());
            String formattedCountryCode = "+" + countryCode;
            return new String[]{formattedCountryCode, nationalNumber};
        }
        catch (NumberParseException e) {
            return new String[]{null, null};
        }
    }

    @Override
    public Map<String, Object> genericFormSearch(String query, boolean isAdmin) {
        String regexSearchTerm = ".*" + query + ".*";
        Criteria criteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"name").regex(regexSearchTerm, "i"), Criteria.where((String)"mail").regex(regexSearchTerm, "i"), Criteria.where((String)"phonenumber").regex(regexSearchTerm, "i"), Criteria.where((String)"orderNumber").regex(regexSearchTerm, "i")});
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.project((String[])new String[0]).and("_id").as("id").and("name").as("name").and("mail").as("mail").and("phonenumber").as("phonenumber").and("instrument").as("instrument").and("mood").as("mood").and("lanuage").as("lanuage").and("artist").as("artist").and("songto").as("songto").and("songfrom").as("songfrom").and("occasion").as("occasion").and("story").as("story").and("clipPath").as("clipPath").and("adminClipPath").as("adminClipPath").and("clipDuration").as("clipDuration").and("status").as("status").and("orderNumber").as("orderNumber").and("mixtureMaster").as("mixtureMaster").and("comments").as("comments").and("orderPosition").as("orderPosition").and("createdDate").as("createdDate").and("customerDeliveryDate").as("customerDeliveryDate").and("review").as("review").and("rating").as("rating").and("images").as("images").and("video").as("video").and("deliveryDate").as("deliveryDate").and("durationInMMSS").as("durationInMMSS").and("orderTotal").as("orderTotal").and("activeStatus").as("activeStatus").and("paymentId").as("paymentId")});
        AggregationResults results = this.mongoTemplate.aggregate(aggregation, "Form", Form.class);
        List forms = results.getMappedResults();
        if (isAdmin) {
            List allForms = forms.stream().map(this.formMapper::toDto).collect(Collectors.toList());
            int count = allForms.size();
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("forms", allForms);
            result.put("totalElements", count);
            return result;
        }
        List allForms = forms.stream().map(this.formMapper::toDtoCoAdmin).collect(Collectors.toList());
        int count = allForms.size();
        HashMap<String, Object> resultForCoAdmin = new HashMap<String, Object>();
        resultForCoAdmin.put("forms", allForms);
        resultForCoAdmin.put("totalElements", count);
        return resultForCoAdmin;
    }
}

