/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.service.impl;

import com.hepl.tunefortwo.dto.OrderSummaryDto;
import com.hepl.tunefortwo.entity.OrderSummary;
import com.hepl.tunefortwo.repository.OrderSummaryRepository;
import com.hepl.tunefortwo.service.OrderSummaryService;
import jakarta.mail.MessagingException;
import java.time.LocalDateTime;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class OrderSummaryServiceImp
implements OrderSummaryService {
    private final OrderSummaryRepository orderSummaryRepository;

    public OrderSummaryServiceImp(OrderSummaryRepository orderSummaryRepository) {
        this.orderSummaryRepository = orderSummaryRepository;
    }

    @Override
    public void updateorderSummary(String id, double languageAmount, double VersionAmount, double masterAmount, double deliverydateAmount, double totalAmount, double artistAmount) {
        OrderSummary orderSummary = (OrderSummary)this.orderSummaryRepository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "error.resourceNotFound"));
        orderSummary.setLangugaeAmount(languageAmount);
        orderSummary.setDeliverydateAmount(deliverydateAmount);
        orderSummary.setMasterAmount(masterAmount);
        orderSummary.setUpdatedAt(LocalDateTime.now());
        orderSummary.setVersionAmount(VersionAmount);
        orderSummary.setArtistAmount(artistAmount);
        this.orderSummaryRepository.save(orderSummary);
    }

    @Override
    public OrderSummary getordersummarybyid(String id) {
        Optional<OrderSummary> optionalOrderSummary = Optional.of((OrderSummary)this.orderSummaryRepository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "orderSummaryNotFoundwith OrderNumber: " + id)));
        OrderSummary orderSummary = optionalOrderSummary.get();
        orderSummary.setTotalAmount(orderSummary.getLangugaeAmount() + orderSummary.getMasterAmount() + orderSummary.getVersionAmount() + orderSummary.getDeliverydateAmount() + orderSummary.getArtistAmount());
        return orderSummary;
    }

    @Override
    public OrderSummary saveOrderSummary(OrderSummaryDto ordersummarydto, double total) throws MessagingException {
        OrderSummary orderSummaryData = new OrderSummary();
        orderSummaryData.setDeliverydateAmount(ordersummarydto.getDeliverydateAmount());
        orderSummaryData.setLangugaeAmount(ordersummarydto.getLanguageAmount());
        orderSummaryData.setMasterAmount(ordersummarydto.getMasterAmount());
        orderSummaryData.setVersionAmount(ordersummarydto.getVersionAmount());
        orderSummaryData.setTotalAmount(total);
        orderSummaryData.setCreatedAt(LocalDateTime.now());
        orderSummaryData.setArtistAmount(ordersummarydto.getArtistAmount());
        return (OrderSummary)this.orderSummaryRepository.save(orderSummaryData);
    }
}

