/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.service.impl;

import com.hepl.tunefortwo.dto.PaymentDto;
import com.hepl.tunefortwo.entity.DeliveryDate;
import com.hepl.tunefortwo.entity.Payment;
import com.hepl.tunefortwo.repository.DeliveryDateRepository;
import com.hepl.tunefortwo.repository.PaymentRepository;
import com.hepl.tunefortwo.service.PaymentService;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class PaymentServiceImpl
implements PaymentService {
    private static final Logger log = LoggerFactory.getLogger(PaymentServiceImpl.class);
    private final PaymentRepository repository;
    private final DeliveryDateRepository deliveryDateRepository;

    public PaymentServiceImpl(PaymentRepository repository, DeliveryDateRepository deliveryDateRepository) {
        this.repository = repository;
        this.deliveryDateRepository = deliveryDateRepository;
    }

    @Override
    public Payment savepayment(PaymentDto dto) {
        log.info("save payment");
        Payment payment = new Payment();
        payment.setEmailId(dto.getEmailId());
        payment.setName(dto.getName());
        payment.setUpiPath(dto.getFilePath());
        return (Payment)this.repository.save(payment);
    }

    @Override
    public void updatePayment(PaymentDto dto, String id) {
        log.info("save payment");
        Payment payment = (Payment)this.repository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "error.resourceNotFound"));
        if (dto.getEmailId() != null && !dto.getEmailId().isEmpty()) {
            payment.setEmailId(dto.getEmailId());
        }
        if (dto.getName() != null && !dto.getName().isEmpty()) {
            payment.setName(dto.getName());
        }
        if (dto.getFilePath() != null && !dto.getFilePath().isEmpty()) {
            payment.setUpiPath(dto.getFilePath());
        }
        this.repository.save(payment);
    }

    @Override
    public void delete(String id) {
        log.info("Delete payment : " + id);
        Payment payment = (Payment)this.repository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "error.resourceNotFound"));
        this.repository.deleteById(id);
    }

    @Override
    public PaymentDto getPaymentById(String id) {
        log.info("Get payment : " + id);
        Payment payment = (Payment)this.repository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "error.resourceNotFound"));
        PaymentDto dto = new PaymentDto();
        dto.setEmailId(payment.getEmailId());
        dto.setName(payment.getName());
        dto.setFilePath(payment.getUpiPath());
        return dto;
    }

    @Override
    public List<Payment> getAllPayments() {
        log.info("Get all payments ");
        return this.repository.findAll();
    }

    @Override
    public double calculateDeliveryPayment(LocalDate clientDate) {
        List findAllDeliveryDates = this.deliveryDateRepository.findAll();
        if (!findAllDeliveryDates.isEmpty()) {
            DeliveryDate deliveryDateFound = (DeliveryDate)findAllDeliveryDates.get(0);
            double basePrice = deliveryDateFound.getPriceForTotalDays();
            double variablePrice = deliveryDateFound.getPricePerDay();
            System.out.println("basePrice-------------------------------" + basePrice);
            LocalDate currentDate = LocalDate.now();
            long difference = ChronoUnit.DAYS.between(currentDate, clientDate);
            String estimatedDaysStr = deliveryDateFound.getEstimatedDays();
            long estimatedDays = Long.parseLong(estimatedDaysStr);
            if (difference > estimatedDays) {
                return 0.0;
            }
            if (difference == estimatedDays) {
                return basePrice;
            }
            double multiplier = (double)(estimatedDays - difference) * variablePrice;
            return basePrice + multiplier;
        }
        throw new DataIntegrityViolationException("Delivery date Base Price not available");
    }
}

