/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.service.impl;

import com.hepl.tunefortwo.dto.ResetPasswordDto;
import com.hepl.tunefortwo.dto.UserDTO;
import com.hepl.tunefortwo.entity.Users;
import com.hepl.tunefortwo.mapper.UserMapper;
import com.hepl.tunefortwo.repository.UserRepository;
import com.hepl.tunefortwo.service.MailService;
import com.hepl.tunefortwo.service.TemplateService;
import com.hepl.tunefortwo.service.UserService;
import jakarta.mail.MessagingException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    @Value(value="${resetPassword.url}")
    private String resetPasswordUrl;
    @Value(value="${resetTokenExpiration.seconds}")
    @DurationUnit(value=ChronoUnit.SECONDS)
    private long RESET_TOKEN_EXPIRATION_DURATION_SECONDS;
    private final UserRepository userRepository;
    private final UserMapper userMapper;
    private final MailService mailService;
    private final TemplateService templateService;

    public UserServiceImpl(UserRepository userRepository, UserMapper userMapper, MailService mailService, TemplateService templateService) {
        this.userRepository = userRepository;
        this.userMapper = userMapper;
        this.mailService = mailService;
        this.templateService = templateService;
    }

    @Override
    public Users saveUser(UserDTO users) {
        log.info("User service");
        Users userToBeInserted = this.userMapper.toUserEntity(users);
        return (Users)this.userRepository.save(userToBeInserted);
    }

    @Override
    public Users findUserForEmail(String email) {
        Users userForEmail = this.userRepository.findByEmail(email);
        return userForEmail;
    }

    @Override
    public String generateResetToken() {
        return UUID.randomUUID().toString();
    }

    @Override
    public Users setResetToken(Users user, String token) throws MessagingException {
        if (token != null) {
            user.setResetToken(token);
            user.setResetTokenCreatedTime(LocalDateTime.now());
        }
        Users updatedToken = (Users)this.userRepository.save(user);
        String resetPasswordLink = this.resetPasswordUrl + token;
        this.mailService.sendMailByTemplate(this.templateService.getResetPasswordTemplateNew(updatedToken.getUsername(), resetPasswordLink), updatedToken.getEmail(), "Reset Password Email");
        return updatedToken;
    }

    @Override
    public Users findUserByToken(String token) {
        Users userForToken = this.userRepository.findByResetToken(token);
        return userForToken;
    }

    @Override
    public boolean isResetTokenExpired(Users user) {
        Users userForTokenValidation = this.userRepository.findByEmail(user.getEmail());
        if (userForTokenValidation == null) {
            throw new IllegalArgumentException("User not found for email: " + user.getEmail());
        }
        String resetToken = userForTokenValidation.getResetToken();
        LocalDateTime tokenCreationTime = userForTokenValidation.getResetTokenCreatedTime();
        if (resetToken == null || tokenCreationTime == null) {
            return true;
        }
        LocalDateTime expirationTime = tokenCreationTime.plusSeconds(this.RESET_TOKEN_EXPIRATION_DURATION_SECONDS);
        LocalDateTime currentTime = LocalDateTime.now();
        return currentTime.isAfter(expirationTime);
    }

    @Override
    public ResponseEntity<String> updateNewPassword(ResetPasswordDto newPass) {
        Users userForEmail = this.userRepository.findByEmail(newPass.getEmail());
        if (userForEmail == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("No user found for email: " + newPass.getEmail()));
        }
        if (userForEmail.getResetToken() == null || !userForEmail.getResetToken().equals(newPass.getResetToken())) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Access denied");
        }
        userForEmail.setPassword(newPass.getNewPassword());
        userForEmail.setResetToken(null);
        userForEmail.setResetTokenCreatedTime(null);
        this.userRepository.save(userForEmail);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)"Password updated successfully");
    }
}

