/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.service.impl;

import com.hepl.tunefortwo.dto.GenericData;
import com.hepl.tunefortwo.dto.GenericResponse;
import com.hepl.tunefortwo.dto.WelcomeVideoDto;
import com.hepl.tunefortwo.entity.FileType;
import com.hepl.tunefortwo.entity.WelcomeVideo;
import com.hepl.tunefortwo.repository.WelcomeVideoRepository;
import com.hepl.tunefortwo.service.FileService;
import com.hepl.tunefortwo.service.WelcomeVideoService;
import com.hepl.tunefortwo.service.impl.FileServiceImpl;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class WelcomeVideoServiceImpl
implements WelcomeVideoService {
    private final WelcomeVideoRepository welcomeVideoRepository;
    private final FileService fileService;
    private final FileServiceImpl fileServiceImpl;

    public WelcomeVideoServiceImpl(WelcomeVideoRepository welcomeVideoRepository, FileService fileService, FileServiceImpl fileServiceImpl) {
        this.welcomeVideoRepository = welcomeVideoRepository;
        this.fileService = fileService;
        this.fileServiceImpl = fileServiceImpl;
    }

    @Override
    public GenericResponse addWelcomeVideo(WelcomeVideoDto newWelcomeVideo) {
        WelcomeVideo newVideo = new WelcomeVideo();
        newVideo.setVideoFlag(newWelcomeVideo.isVideoFlag());
        newVideo.setVideoLink(newWelcomeVideo.getVideoLink());
        newVideo.setVideoName(newWelcomeVideo.getVideoName());
        newVideo.setVideoType(newWelcomeVideo.getVideoType());
        WelcomeVideo savedVideo = (WelcomeVideo)this.welcomeVideoRepository.save(newVideo);
        ArrayList<WelcomeVideo> welcomeVideoList = new ArrayList<WelcomeVideo>();
        welcomeVideoList.add(savedVideo);
        int videoCount = welcomeVideoList.size();
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        HashMap<String, Object> videoMap = new HashMap<String, Object>();
        videoMap.put("count", videoCount);
        videoMap.put("welcomeVideos", welcomeVideoList);
        data.setWelcomeVideoResponse(videoMap);
        response.setData(data);
        response.setMessage("Welcome Video Added Successfully");
        return response;
    }

    @Override
    public GenericResponse updateWelcomeVideo(WelcomeVideoDto updatesToBeMade, String id) throws IOException, MessagingException {
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        WelcomeVideo foundVideo = (WelcomeVideo)this.welcomeVideoRepository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Welcome Video with ID: " + id + " not found"));
        foundVideo.setVideoFlag(updatesToBeMade.isVideoFlag());
        if (updatesToBeMade.getVideoLink() != null) {
            foundVideo.setVideoLink(updatesToBeMade.getVideoLink());
        }
        if (updatesToBeMade.getVideoType() != null) {
            foundVideo.setVideoType(updatesToBeMade.getVideoType());
        }
        if (updatesToBeMade.getVideoName() != null) {
            foundVideo.setVideoName(id);
        }
        if (updatesToBeMade.getVideoClip() != null) {
            String originalFilename = updatesToBeMade.getVideoClip().getOriginalFilename();
            if (originalFilename != null) {
                String fileExtension = originalFilename.substring(originalFilename.lastIndexOf(".") + 1);
                List<String> allowedExtensions = Arrays.asList("mp4", "mov", "wmv", "avi", "mkv");
                if (!allowedExtensions.contains(fileExtension)) {
                    throw new MessagingException("Only MP4, MOV, AVI, MKV, and WMV files are allowed");
                }
            }
            String filename = this.fileService.uploadFile(updatesToBeMade.getVideoClip(), FileType.WELCOMEVIDEO);
            Resource file = this.fileService.loadAsResource(filename, FileType.WELCOMEVIDEO);
            updatesToBeMade.setVideoName(filename);
            Path filePath = Paths.get(file.getURI());
            foundVideo.setVideoName(filename);
        }
        WelcomeVideo updatedData = (WelcomeVideo)this.welcomeVideoRepository.save(foundVideo);
        if (id != null) {
            List videos = this.welcomeVideoRepository.findAll();
            for (WelcomeVideo video : videos) {
                video.setVideoFlag(updatesToBeMade.isVideoFlag());
                this.welcomeVideoRepository.save(video);
            }
        }
        ArrayList<WelcomeVideo> welcomeVideoList = new ArrayList<WelcomeVideo>();
        welcomeVideoList.add(updatedData);
        int videoCount = welcomeVideoList.size();
        HashMap<String, Object> updateVideoMap = new HashMap<String, Object>();
        updateVideoMap.put("count", videoCount);
        updateVideoMap.put("welcomeVideos", welcomeVideoList);
        data.setWelcomeVideoResponse(updateVideoMap);
        response.setData(data);
        response.setMessage("Welcome Video Details Updated Successfully");
        return response;
    }

    @Override
    public GenericResponse removeAWelcomeVideo(WelcomeVideoDto videoToBeRemoved) {
        return null;
    }

    @Override
    public GenericResponse getWelcomeVideos() {
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        List allVideos = this.welcomeVideoRepository.findAll();
        if (allVideos.size() > 0) {
            int videoCount = allVideos.size();
            HashMap<String, Object> videoListMap = new HashMap<String, Object>();
            videoListMap.put("count", videoCount);
            videoListMap.put("welcomeVideos", allVideos);
            data.setWelcomeVideoResponse(videoListMap);
            response.setData(data);
            response.setMessage("Welcome Videos Found");
            return response;
        }
        response.setMessage("No welcome videos found");
        response.setStatus(false);
        return response;
    }

    @Override
    public GenericResponse serveVideo() {
        return null;
    }

    @Override
    public GenericResponse getMobileVideo() {
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        List<WelcomeVideo> allVideos = this.welcomeVideoRepository.findByVideoType("Mobile");
        if (allVideos.size() > 0) {
            int videoCount = allVideos.size();
            HashMap<String, Object> videoListMap = new HashMap<String, Object>();
            videoListMap.put("count", videoCount);
            videoListMap.put("welcomeVideos", allVideos);
            data.setWelcomeVideoResponse(videoListMap);
            response.setData(data);
            response.setMessage("Welcome Videos Found");
            return response;
        }
        response.setMessage("No welcome videos found");
        response.setStatus(false);
        return response;
    }

    @Override
    public GenericResponse getWelcomeVideoById(String id) {
        GenericResponse response = new GenericResponse(true);
        GenericData data = new GenericData();
        WelcomeVideo foundVideo = (WelcomeVideo)this.welcomeVideoRepository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Welcome Video Not Found for the given Id"));
        ArrayList<WelcomeVideo> videoList = new ArrayList<WelcomeVideo>();
        videoList.add(foundVideo);
        int videoCount = videoList.size();
        HashMap<String, Object> videoListMap = new HashMap<String, Object>();
        videoListMap.put("count", videoCount);
        videoListMap.put("welcomeVideos", foundVideo);
        data.setWelcomeVideoResponse(videoListMap);
        response.setData(data);
        response.setMessage("Welcome Videos Found");
        return response;
    }
}

