/*
 * Decompiled with CFR 0.152.
 */
package com.hepl.tunefortwo.utils;

import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class PaymentUtils {
    private static final String HMAC_SHA256 = "HmacSHA256";

    public static boolean verifyPaymentSignature(String paymentId, String orderId, String signature, String secret) {
        try {
            String message = orderId + "|" + paymentId;
            SecretKeySpec keySpec = new SecretKeySpec(secret.getBytes(), HMAC_SHA256);
            Mac mac = Mac.getInstance(HMAC_SHA256);
            mac.init(keySpec);
            byte[] calculatedSignatureBytes = mac.doFinal(message.getBytes());
            String calculatedSignature = Base64.getEncoder().encodeToString(calculatedSignatureBytes);
            return calculatedSignature.equals(signature);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while verifying payment signature", e);
        }
    }
}

